/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.ActionSetContentProvider;
import org.eclipse.ui.internal.dialogs.ActionSetDialogInput;
import org.eclipse.ui.internal.dialogs.ActionSetLabelProvider;
import org.eclipse.ui.internal.dialogs.ActionSetSorter;
import org.eclipse.ui.internal.dialogs.FakePerspectiveActionSet;
import org.eclipse.ui.internal.dialogs.FakeViewActionSet;
import org.eclipse.ui.internal.dialogs.FakeWizardActionSet;
import org.eclipse.ui.internal.registry.ActionSetCategory;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class ActionSetSelectionDialog
extends Dialog {
    private Perspective perspective;
    private ActionSetDialogInput input;
    private CheckboxTreeViewer actionSetViewer;
    private Label actionLabel;
    private TableViewer actionViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;

    public ActionSetSelectionDialog(Shell parentShell, Perspective persp) {
        super(parentShell);
        this.perspective = persp;
        this.input = new ActionSetDialogInput();
    }

    private void checkInitialSelections() {
        String id;
        int nX;
        ArrayList actions;
        IActionSetDescriptor[] actionSets = this.perspective.getActionSets();
        if (actionSets != null) {
            int i = 0;
            while (i < actionSets.length) {
                this.actionSetViewer.setChecked((Object)actionSets[i], true);
                ++i;
            }
        }
        if ((actions = this.perspective.getShowViewActionIds()) != null) {
            nX = 0;
            while (nX < actions.size()) {
                id = (String)actions.get(nX);
                this.actionSetViewer.setChecked((Object)this.input.getViewActionSet(id), true);
                ++nX;
            }
        }
        if ((actions = this.perspective.getPerspectiveActionIds()) != null) {
            nX = 0;
            while (nX < actions.size()) {
                id = (String)actions.get(nX);
                this.actionSetViewer.setChecked((Object)this.input.getPerspectiveActionSet(id), true);
                ++nX;
            }
        }
        if ((actions = this.perspective.getNewWizardActionIds()) != null) {
            nX = 0;
            while (nX < actions.size()) {
                id = (String)actions.get(nX);
                this.actionSetViewer.setChecked((Object)this.input.getWizardActionSet(id), true);
                ++nX;
            }
        }
        Object[] categories = this.input.getCategories();
        int i = 0;
        while (i < categories.length) {
            ActionSetCategory cat = (ActionSetCategory)categories[i];
            ArrayList sets = cat.getActionSets();
            if (sets != null && sets.size() > 0) {
                boolean baseChildState = this.actionSetViewer.getChecked(sets.get(0));
                this.updateCategoryState(cat, baseChildState);
            }
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.getString("ActionSetSelection.customize"));
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.action_set_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        Font font = parent.getFont();
        Label descLabel = new Label(composite, 64);
        descLabel.setText(WorkbenchMessages.format("ActionSetSelection.selectLabel", new Object[]{this.perspective.getDesc().getLabel()}));
        descLabel.setFont(font);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        descLabel.setLayoutData((Object)data);
        Composite actionSetGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionSetGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        actionSetGroup.setLayoutData((Object)data);
        actionSetGroup.setFont(font);
        Label selectionLabel = new Label(actionSetGroup, 0);
        selectionLabel.setText(WorkbenchMessages.getString("ActionSetSelection.available"));
        selectionLabel.setFont(font);
        this.actionSetViewer = new CheckboxTreeViewer(actionSetGroup, 2048);
        data = new GridData(1808);
        data.heightHint = 300;
        data.widthHint = 300;
        this.actionSetViewer.getTree().setLayoutData((Object)data);
        this.actionSetViewer.getTree().setFont(font);
        this.actionSetViewer.setLabelProvider((IBaseLabelProvider)new ActionSetLabelProvider());
        this.actionSetViewer.setContentProvider((IContentProvider)new ActionSetContentProvider());
        this.actionSetViewer.setInput((Object)this.input);
        this.actionSetViewer.setSorter((ViewerSorter)new ActionSetSorter());
        this.actionSetViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                IActionSetDescriptor actionSet = null;
                if (sel.getFirstElement() instanceof IActionSetDescriptor) {
                    actionSet = (IActionSetDescriptor)sel.getFirstElement();
                }
                if (actionSet != ActionSetSelectionDialog.this.actionViewer.getInput()) {
                    ActionSetSelectionDialog.this.actionViewer.setInput((Object)actionSet);
                }
            }
        });
        this.actionSetViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ActionSetSelectionDialog.this.handleActionSetChecked(event);
            }
        });
        Composite actionGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        actionGroup.setLayoutData((Object)data);
        actionGroup.setFont(font);
        this.actionLabel = new Label(actionGroup, 0);
        this.actionLabel.setText(WorkbenchMessages.getString("ActionSetSelection.details"));
        this.actionLabel.setFont(font);
        Table actionTable = new Table(actionGroup, 2816);
        actionTable.setBackground(WorkbenchColors.getSystemColor(22));
        data = new GridData(1808);
        data.heightHint = 300;
        data.widthHint = 300;
        actionTable.setLayoutData((Object)data);
        actionTable.setFont(font);
        this.actionViewer = new TableViewer(actionTable);
        this.actionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.actionViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.actionViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.checkInitialSelections();
        return composite;
    }

    private void handleActionSetChecked(CheckStateChangedEvent event) {
        if (event.getElement() instanceof ActionSetCategory) {
            if (event.getChecked()) {
                this.actionSetViewer.setSubtreeChecked(event.getElement(), true);
                return;
            }
            if (this.actionSetViewer.getGrayed(event.getElement())) {
                this.actionSetViewer.setChecked(event.getElement(), true);
                this.actionSetViewer.setGrayed(event.getElement(), false);
                this.actionSetViewer.setSubtreeChecked(event.getElement(), true);
                return;
            }
            this.actionSetViewer.setSubtreeChecked(event.getElement(), false);
            return;
        }
        if (event.getElement() instanceof IActionSetDescriptor) {
            IActionSetDescriptor desc = (IActionSetDescriptor)event.getElement();
            ActionSetCategory cat = this.input.findCategory(desc.getCategory());
            this.updateCategoryState(cat, event.getChecked());
            return;
        }
    }

    protected void okPressed() {
        ArrayList<Object> actionSets = new ArrayList<Object>();
        ArrayList<String> viewActions = new ArrayList<String>();
        ArrayList<String> perspActions = new ArrayList<String>();
        ArrayList<String> wizardActions = new ArrayList<String>();
        Object[] selected = this.actionSetViewer.getCheckedElements();
        int nX = 0;
        while (nX < selected.length) {
            Object obj = selected[nX];
            if (obj instanceof FakeViewActionSet) {
                viewActions.add(((FakeViewActionSet)obj).getView().getID());
            } else if (obj instanceof FakePerspectiveActionSet) {
                perspActions.add(((FakePerspectiveActionSet)obj).getPerspective().getId());
            } else if (obj instanceof FakeWizardActionSet) {
                wizardActions.add(((FakeWizardActionSet)obj).getWizard().getID());
            } else if (obj instanceof ActionSetDescriptor) {
                actionSets.add(obj);
            }
            ++nX;
        }
        this.perspective.setShowViewActionIds(viewActions);
        this.perspective.setPerspectiveActionIds(perspActions);
        this.perspective.setNewWizardActionIds(wizardActions);
        IActionSetDescriptor[] actionSetArray = new IActionSetDescriptor[actionSets.size()];
        actionSetArray = actionSets.toArray(actionSetArray);
        this.perspective.setActionSets(actionSetArray);
        super.okPressed();
    }

    private void updateCategoryState(ActionSetCategory cat, boolean baseChildState) {
        boolean allSameState = true;
        Iterator iterator = ((AbstractList)cat.getActionSets()).iterator();
        while (iterator.hasNext()) {
            if (this.actionSetViewer.getChecked(iterator.next()) == baseChildState) continue;
            allSameState = false;
            break;
        }
        if (allSameState) {
            this.actionSetViewer.setGrayed((Object)cat, false);
            this.actionSetViewer.setChecked((Object)cat, baseChildState);
            return;
        }
        this.actionSetViewer.setGrayed((Object)cat, true);
        this.actionSetViewer.setChecked((Object)cat, true);
    }
}

