/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PathVariableSelectionDialog;

public class CreateLinkedResourceGroup {
    private Listener listener;
    private String linkTarget;
    private int type;
    private boolean createLink = false;
    private FontMetrics fontMetrics;
    private Composite groupComposite;
    private Text linkTargetField;
    private Button browseButton;
    private Button variablesButton;
    private Label resolvedPathLabelText;
    private Label resolvedPathLabelData;

    public CreateLinkedResourceGroup(int type, Listener listener) {
        this.type = type;
        this.listener = listener;
    }

    public Composite createContents(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        this.groupComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.groupComposite.setLayout((Layout)layout);
        this.groupComposite.setLayoutData((Object)new GridData(784));
        this.groupComposite.setFont(font);
        final Button createLinkButton = new Button(this.groupComposite, 32);
        if (this.type == 1) {
            createLinkButton.setText(WorkbenchMessages.getString("CreateLinkedResourceGroup.linkFileButton"));
        } else {
            createLinkButton.setText(WorkbenchMessages.getString("CreateLinkedResourceGroup.linkFolderButton"));
        }
        createLinkButton.setSelection(this.createLink);
        createLinkButton.setFont(font);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateLinkedResourceGroup.this.createLink = createLinkButton.getSelection();
                CreateLinkedResourceGroup.this.browseButton.setEnabled(CreateLinkedResourceGroup.this.createLink);
                CreateLinkedResourceGroup.this.variablesButton.setEnabled(CreateLinkedResourceGroup.this.createLink);
                CreateLinkedResourceGroup.this.linkTargetField.setEnabled(CreateLinkedResourceGroup.this.createLink);
                if (CreateLinkedResourceGroup.this.listener != null) {
                    CreateLinkedResourceGroup.this.listener.handleEvent(new Event());
                }
            }
        };
        createLinkButton.addSelectionListener((SelectionListener)selectionListener);
        this.createLinkLocationGroup(this.groupComposite, this.createLink);
        return this.groupComposite;
    }

    private void createLinkLocationGroup(Composite locationGroup, boolean enabled) {
        Font font = locationGroup.getFont();
        Button button = new Button(locationGroup, 32);
        int indent = button.computeSize((int)-1, (int)-1).x;
        button.dispose();
        Composite linkTargetGroup = new Composite(locationGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        linkTargetGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalIndent = indent;
        linkTargetGroup.setLayoutData((Object)data);
        linkTargetGroup.setFont(font);
        this.linkTargetField = new Text(linkTargetGroup, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.linkTargetField.setLayoutData((Object)data);
        this.linkTargetField.setFont(font);
        this.linkTargetField.setEnabled(enabled);
        this.linkTargetField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLinkedResourceGroup.this.linkTarget = CreateLinkedResourceGroup.this.linkTargetField.getText();
                CreateLinkedResourceGroup.this.resolveVariable();
                if (CreateLinkedResourceGroup.this.listener != null) {
                    CreateLinkedResourceGroup.this.listener.handleEvent(new Event());
                }
            }
        });
        this.browseButton = new Button(linkTargetGroup, 8);
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.setFont(font);
        this.browseButton.setText(WorkbenchMessages.getString("CreateLinkedResourceGroup.browseButton"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateLinkedResourceGroup.this.handleLinkTargetBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.variablesButton = new Button(linkTargetGroup, 8);
        this.setButtonLayoutData(this.variablesButton);
        this.variablesButton.setFont(font);
        this.variablesButton.setText(WorkbenchMessages.getString("CreateLinkedResourceGroup.variablesButton"));
        this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateLinkedResourceGroup.this.handleVariablesButtonPressed();
            }
        });
        this.variablesButton.setEnabled(enabled);
        Composite resolvedPathGroup = new Composite(locationGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        resolvedPathGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalIndent = indent;
        resolvedPathGroup.setLayoutData((Object)data);
        resolvedPathGroup.setFont(font);
        this.resolvedPathLabelText = new Label(resolvedPathGroup, 4);
        this.resolvedPathLabelText.setText(WorkbenchMessages.getString("CreateLinkedResourceGroup.resolvedPathLabel"));
        this.resolvedPathLabelText.setVisible(false);
        this.resolvedPathLabelData = new Label(resolvedPathGroup, 4);
        data = new GridData(768);
        this.resolvedPathLabelData.setLayoutData((Object)data);
        this.resolvedPathLabelData.setVisible(false);
        if (this.linkTarget != null) {
            this.linkTargetField.setText(this.linkTarget);
        }
    }

    private IStatus createStatus(int severity, String message) {
        return new Status(severity, WorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier(), severity, message, null);
    }

    public void dispose() {
        if (this.groupComposite != null && !this.groupComposite.isDisposed()) {
            this.groupComposite.dispose();
        }
    }

    public String getLinkTarget() {
        if (this.createLink && this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            return this.linkTargetField.getText();
        }
        return null;
    }

    private void handleLinkTargetBrowseButtonPressed() {
        String linkTargetName = this.linkTargetField.getText();
        File file = null;
        String selection = null;
        if (!"".equals(linkTargetName) && !(file = new File(linkTargetName)).exists()) {
            file = null;
        }
        if (this.type == 1) {
            FileDialog dialog = new FileDialog(this.linkTargetField.getShell());
            if (file != null) {
                if (file.isFile()) {
                    dialog.setFileName(linkTargetName);
                } else {
                    dialog.setFilterPath(linkTargetName);
                }
            }
            selection = dialog.open();
        } else {
            DirectoryDialog dialog = new DirectoryDialog(this.linkTargetField.getShell());
            if (file != null) {
                if (file.isFile()) {
                    linkTargetName = file.getParent();
                }
                if (linkTargetName != null) {
                    dialog.setFilterPath(linkTargetName);
                }
            }
            dialog.setMessage(WorkbenchMessages.getString("CreateLinkedResourceGroup.targetSelectionLabel"));
            selection = dialog.open();
        }
        if (selection != null) {
            this.linkTargetField.setText(selection);
        }
    }

    private void handleVariablesButtonPressed() {
        String[] variableNames;
        PathVariableSelectionDialog dialog;
        int variableTypes = 2;
        if (this.type == 1) {
            variableTypes |= 1;
        }
        if ((dialog = new PathVariableSelectionDialog(this.linkTargetField.getShell(), variableTypes)).open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
            this.linkTargetField.setText(variableNames[0]);
        }
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void resolveVariable() {
        IPath resolvedPath;
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        Path path = new Path(this.linkTargetField.getText());
        if (path.equals((Object)(resolvedPath = pathVariableManager.resolvePath((IPath)path)))) {
            this.resolvedPathLabelText.setVisible(false);
            this.resolvedPathLabelData.setVisible(false);
        } else {
            this.resolvedPathLabelText.setVisible(true);
            this.resolvedPathLabelData.setVisible(true);
        }
        this.resolvedPathLabelData.setText(resolvedPath.toOSString());
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        data.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fontMetrics, (int)14);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    public void setLinkTarget(String target) {
        this.linkTarget = target;
        if (this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            this.linkTargetField.setText(target);
        }
    }

    private IStatus validateFileType(File linkTargetFile) {
        if (this.type == 1 && !linkTargetFile.isFile()) {
            return this.createStatus(4, WorkbenchMessages.getString("CreateLinkedResourceGroup.linkTargetNotFile"));
        }
        if (this.type == 2 && !linkTargetFile.isDirectory()) {
            return this.createStatus(4, WorkbenchMessages.getString("CreateLinkedResourceGroup.linkTargetNotFolder"));
        }
        return this.createStatus(0, "");
    }

    public IStatus validateLinkLocation(IResource linkHandle) {
        if (this.linkTargetField == null || this.linkTargetField.isDisposed()) {
            return this.createStatus(0, "");
        }
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        String linkTargetName = this.linkTargetField.getText();
        Path path = new Path(linkTargetName);
        if (!this.createLink) {
            return this.createStatus(0, "");
        }
        IStatus locationStatus = workspace.validateLinkLocation(linkHandle, (IPath)path);
        if (locationStatus.getSeverity() == 4) {
            return locationStatus;
        }
        linkTargetName = this.resolvedPathLabelData.getText();
        path = new Path(linkTargetName);
        File linkTargetFile = new Path(linkTargetName).toFile();
        if (linkTargetFile.exists()) {
            IStatus fileTypeStatus = this.validateFileType(linkTargetFile);
            if (!fileTypeStatus.isOK()) {
                return fileTypeStatus;
            }
        } else if (locationStatus.getSeverity() == 0) {
            return this.createStatus(2, WorkbenchMessages.getString("CreateLinkedResourceGroup.linkTargetNonExistent"));
        }
        return locationStatus;
    }
}

