/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class FileFolderSelectionDialog
extends ElementTreeSelectionDialog {
    public FileFolderSelectionDialog(Shell parent, boolean multiSelect, int type) {
        super(parent, (ILabelProvider)new FileLabelProvider(), new FileContentProvider((type & 1) != 0));
        this.setSorter(new FileViewerSorter());
        this.setValidator(new FileSelectionValidator(multiSelect, (type & 2) != 0));
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        FileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof File) {
                File curr = (File)element;
                if (curr.isDirectory()) {
                    return IMG_FOLDER;
                }
                return IMG_FILE;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof File) {
                return ((File)element).getName();
            }
            return super.getText(element);
        }
    }

    private static class FileContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private FileFilter fileFilter;

        public FileContentProvider(boolean showFiles) {
            this.fileFilter = new FileFilter(this, showFiles){
                final /* synthetic */ FileContentProvider this$1;
                private final /* synthetic */ boolean val$showFiles;
                {
                    this.this$1 = fileContentProvider;
                    this.val$showFiles = bl;
                }

                public boolean accept(File file) {
                    return !file.isFile() || this.val$showFiles;
                }
            };
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children;
            if (parentElement instanceof File && (children = ((File)parentElement).listFiles(this.fileFilter)) != null) {
                return children;
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof File) {
                return ((File)element).getParentFile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FileViewerSorter
    extends ViewerSorter {
        FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof File && ((File)element).isFile()) {
                return 1;
            }
            return 0;
        }
    }

    private static class FileSelectionValidator
    implements ISelectionStatusValidator {
        private boolean multiSelect;
        private boolean acceptFolders;

        public FileSelectionValidator(boolean multiSelect, boolean acceptFolders) {
            this.multiSelect = multiSelect;
            this.acceptFolders = acceptFolders;
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            String pluginId = WorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier();
            if (nSelected == 0 || nSelected > 1 && !this.multiSelect) {
                return new Status(4, pluginId, 4, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                Object curr = selection[i];
                if (curr instanceof File) {
                    File file = (File)curr;
                    if (!this.acceptFolders && !file.isFile()) {
                        return new Status(4, pluginId, 4, "", null);
                    }
                }
                ++i;
            }
            return new Status(0, pluginId, 0, "", null);
        }
    }
}

