/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

class InternalBase64Encoder {
    private static final String mappings = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String filler = "=";

    InternalBase64Encoder() {
    }

    public static String encode(byte[] contents) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < contents.length) {
            if (result.length() == 76) {
                result.append("\n\r");
            }
            result.append(mappings.charAt((contents[i] & 0xFC) >> 2));
            int c2 = (contents[i] & 3) << 4;
            if (i + 1 >= contents.length) {
                result.append(mappings.charAt(c2));
                result.append(filler);
                result.append(filler);
                return result.toString();
            }
            result.append(mappings.charAt(c2 |= (contents[i + 1] & 0xF0) >> 4));
            int c3 = (contents[i + 1] & 0xF) << 2;
            if (i + 2 >= contents.length) {
                result.append(mappings.charAt(c3));
                result.append(filler);
                return result.toString();
            }
            result.append(mappings.charAt(c3 |= (contents[i + 2] & 0xC0) >> 6));
            result.append(mappings.charAt(contents[i + 2] & 0x3F));
            i += 3;
        }
        return result.toString();
    }
}

