/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PathVariablesGroup;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferencePage;

public class LinkedResourcesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label topLabel;
    private PathVariablesGroup pathVariablesGroup = new PathVariablesGroup(true, 3);

    public LinkedResourcesPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.linked_resource_preference_page_context");
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        pageComponent.setFont(font);
        final Button enableLinkedResourcesButton = new Button(pageComponent, 32);
        enableLinkedResourcesButton.setText(WorkbenchMessages.getString("LinkedResourcesPreference.enableLinkedResources"));
        enableLinkedResourcesButton.setFont(font);
        enableLinkedResourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = enableLinkedResourcesButton.getSelection();
                Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
                preferences.setValue("description.disableLinking", !enabled);
                LinkedResourcesPreferencePage.this.updateWidgetState(enabled);
                if (enabled) {
                    MessageDialog.openWarning((Shell)LinkedResourcesPreferencePage.this.getShell(), (String)WorkbenchMessages.getString("LinkedResourcesPreference.linkedResourcesWarningTitle"), (String)WorkbenchMessages.getString("LinkedResourcesPreference.linkedResourcesWarningMessage"));
                }
            }
        });
        WorkbenchPreferencePage.createSpace(pageComponent);
        this.topLabel = new Label(pageComponent, 0);
        this.topLabel.setText(WorkbenchMessages.getString("LinkedResourcesPreference.explanation"));
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        this.topLabel.setLayoutData((Object)data);
        this.topLabel.setFont(font);
        this.pathVariablesGroup.createContents(pageComponent);
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        boolean enableLinking = !preferences.getBoolean("description.disableLinking");
        enableLinkedResourcesButton.setSelection(enableLinking);
        this.updateWidgetState(enableLinking);
        return pageComponent;
    }

    public void dispose() {
        this.pathVariablesGroup.dispose();
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        return this.pathVariablesGroup.performOk();
    }

    protected void updateWidgetState(boolean enableLinking) {
        this.topLabel.setEnabled(enableLinking);
        this.pathVariablesGroup.setEnabled(enableLinking);
    }
}

