/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.FileFolderSelectionDialog;
import org.eclipse.ui.internal.dialogs.PathVariablesGroup;

public class PathVariableSelectionDialog
extends SelectionDialog {
    private static final int EXTEND_ID = 1025;
    private PathVariablesGroup pathVariablesGroup;
    private int variableType;

    public PathVariableSelectionDialog(Shell parentShell, int variableType) {
        super(parentShell);
        this.setTitle(WorkbenchMessages.getString("PathVariableSelectionDialog.title"));
        this.variableType = variableType;
        this.pathVariablesGroup = new PathVariablesGroup(false, variableType, new Listener(){

            public void handleEvent(Event event) {
                PathVariableSelectionDialog.this.updateExtendButtonState();
            }
        });
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            FileFolderSelectionDialog dialog = new FileFolderSelectionDialog(this.getShell(), false, this.variableType);
            PathVariablesGroup.PathVariableElement selection = this.pathVariablesGroup.getSelection()[0];
            dialog.setTitle(WorkbenchMessages.getString("PathVariableSelectionDialog.ExtensionDialog.title"));
            dialog.setMessage(WorkbenchMessages.format("PathVariableSelectionDialog.ExtensionDialog.description", new Object[]{selection.name}));
            dialog.setInput(selection.path.toFile());
            if (dialog.open() == 0 && this.pathVariablesGroup.performOk()) {
                this.setExtensionResult(selection, (File)dialog.getResult()[0]);
                super.okPressed();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.path_variable_selection_dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1025, WorkbenchMessages.getString("PathVariableSelectionDialog.extendButton"), false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateExtendButtonState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.pathVariablesGroup.createContents(dialogArea);
        return dialogArea;
    }

    public boolean close() {
        this.pathVariablesGroup.dispose();
        return super.close();
    }

    protected void okPressed() {
        if (this.pathVariablesGroup.performOk()) {
            PathVariablesGroup.PathVariableElement[] selection = this.pathVariablesGroup.getSelection();
            Object[] variableNames = new String[selection.length];
            int i = 0;
            while (i < selection.length) {
                variableNames[i] = selection[i].name;
                ++i;
            }
            this.setSelectionResult(variableNames);
        } else {
            this.setSelectionResult(null);
        }
        super.okPressed();
    }

    private void setExtensionResult(PathVariablesGroup.PathVariableElement variable, File extensionFile) {
        Path extensionPath = new Path(extensionFile.getPath());
        int matchCount = extensionPath.matchingFirstSegments(variable.path);
        Path resultPath = new Path(variable.name);
        extensionPath = extensionPath.removeFirstSegments(matchCount);
        resultPath = resultPath.append((IPath)extensionPath);
        this.setSelectionResult(new String[]{resultPath.toOSString()});
    }

    protected void updateExtendButtonState() {
        PathVariablesGroup.PathVariableElement[] selection = this.pathVariablesGroup.getSelection();
        Button extendButton = this.getButton(1025);
        if (extendButton == null) {
            return;
        }
        if (selection.length == 1) {
            File file = selection[0].path.toFile();
            if (!file.exists() || file.isFile()) {
                extendButton.setEnabled(false);
            } else {
                extendButton.setEnabled(true);
            }
        } else {
            extendButton.setEnabled(false);
        }
    }
}

