/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ResourceInfoPage
extends PropertyPage {
    private Button editableBox;
    private Button derivedBox;
    private boolean previousReadOnlyValue;
    private boolean previousDerivedValue;
    private static String READ_ONLY = WorkbenchMessages.getString("ResourceInfo.readOnly");
    private static String DERIVED = WorkbenchMessages.getString("ResourceInfo.derived");
    private static String TYPE_TITLE = WorkbenchMessages.getString("ResourceInfo.type");
    private static String LOCATION_TITLE = WorkbenchMessages.getString("ResourceInfo.location");
    private static String RESOLVED_LOCATION_TITLE = WorkbenchMessages.getString("ResourceInfo.resolvedLocation");
    private static String SIZE_TITLE = WorkbenchMessages.getString("ResourceInfo.size");
    private static String BYTES_LABEL = WorkbenchMessages.getString("ResourceInfo.bytes");
    private static String FILE_LABEL = WorkbenchMessages.getString("ResourceInfo.file");
    private static String FOLDER_LABEL = WorkbenchMessages.getString("ResourceInfo.folder");
    private static String PROJECT_LABEL = WorkbenchMessages.getString("ResourceInfo.project");
    private static String LINKED_FILE_LABEL = WorkbenchMessages.getString("ResourceInfo.linkedFile");
    private static String LINKED_FOLDER_LABEL = WorkbenchMessages.getString("ResourceInfo.linkedFolder");
    private static String UNKNOWN_LABEL = WorkbenchMessages.getString("ResourceInfo.unknown");
    private static String NOT_LOCAL_TEXT = WorkbenchMessages.getString("ResourceInfo.notLocal");
    private static String MISSING_PATH_VARIABLE_TEXT = WorkbenchMessages.getString("ResourceInfo.undefinedPathVariable");
    private static String NOT_EXIST_TEXT = WorkbenchMessages.getString("ResourceInfo.notExist");
    private static String PATH_TITLE = WorkbenchMessages.getString("ResourceInfo.path");
    private static String TIMESTAMP_TITLE = WorkbenchMessages.getString("ResourceInfo.lastModified");
    private static String FILE_NOT_EXIST_TEXT = WorkbenchMessages.getString("ResourceInfo.fileNotExist");
    private static final int MAX_VALUE_WIDTH = 80;

    private Composite createBasicInfoGroup(Composite parent, IResource resource) {
        Font font = parent.getFont();
        Composite basicInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        basicInfoComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        basicInfoComposite.setLayoutData((Object)data);
        basicInfoComposite.setFont(font);
        Label pathLabel = new Label(basicInfoComposite, 0);
        pathLabel.setText(PATH_TITLE);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        pathLabel.setLayoutData((Object)gd);
        pathLabel.setFont(font);
        Text pathValueText = new Text(basicInfoComposite, 72);
        pathValueText.setText(resource.getFullPath().toString());
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        pathValueText.setLayoutData((Object)gd);
        pathValueText.setFont(font);
        Label typeTitle = new Label(basicInfoComposite, 16384);
        typeTitle.setText(TYPE_TITLE);
        typeTitle.setFont(font);
        Text typeValue = new Text(basicInfoComposite, 16392);
        typeValue.setText(this.getTypeString(resource));
        typeValue.setFont(font);
        Label locationTitle = new Label(basicInfoComposite, 16384);
        locationTitle.setText(LOCATION_TITLE);
        gd = new GridData();
        gd.verticalAlignment = 128;
        locationTitle.setLayoutData((Object)gd);
        locationTitle.setFont(font);
        Text locationValue = new Text(basicInfoComposite, 72);
        locationValue.setText(this.getLocationText(resource));
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        locationValue.setLayoutData((Object)gd);
        locationValue.setFont(font);
        if (this.isPathVariable(resource)) {
            Label resolvedLocationTitle = new Label(basicInfoComposite, 16384);
            resolvedLocationTitle.setText(RESOLVED_LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            resolvedLocationTitle.setLayoutData((Object)gd);
            resolvedLocationTitle.setFont(font);
            Text resolvedLocationValue = new Text(basicInfoComposite, 72);
            resolvedLocationValue.setText(this.getResolvedLocationText(resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            resolvedLocationValue.setLayoutData((Object)gd);
            resolvedLocationValue.setFont(font);
        }
        if (resource.getType() == 1) {
            Label sizeTitle = new Label(basicInfoComposite, 16384);
            sizeTitle.setText(SIZE_TITLE);
            sizeTitle.setFont(font);
            Text sizeValue = new Text(basicInfoComposite, 16392);
            sizeValue.setText(this.getSizeString((IFile)resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            sizeValue.setLayoutData((Object)gd);
            sizeValue.setFont(font);
        }
        return basicInfoComposite;
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.resource_info_property_page_context");
        IResource resource = (IResource)this.getElement();
        if (resource.getType() != 4) {
            this.previousReadOnlyValue = resource.isReadOnly();
            this.previousDerivedValue = resource.isDerived();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createBasicInfoGroup(composite, resource);
        this.createSeparator(composite);
        this.createStateGroup(composite, resource);
        return composite;
    }

    private void createEditableButton(Composite composite) {
        this.editableBox = new Button(composite, 131104);
        this.editableBox.setAlignment(16384);
        this.editableBox.setText(READ_ONLY);
        this.editableBox.setSelection(this.previousReadOnlyValue);
        this.editableBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.editableBox.setLayoutData((Object)data);
    }

    private void createDerivedButton(Composite composite) {
        this.derivedBox = new Button(composite, 131104);
        this.derivedBox.setAlignment(16384);
        this.derivedBox.setText(DERIVED);
        this.derivedBox.setSelection(this.previousDerivedValue);
        this.derivedBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.derivedBox.setLayoutData((Object)data);
    }

    private void createSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void createStateGroup(Composite parent, IResource resource) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Label timeStampLabel = new Label(composite, 0);
        timeStampLabel.setText(TIMESTAMP_TITLE);
        timeStampLabel.setFont(font);
        Text timeStampValue = new Text(composite, 8);
        timeStampValue.setText(this.getDateStringValue(resource));
        timeStampValue.setFont(font);
        timeStampValue.setLayoutData((Object)new GridData(768));
        if (resource.getType() != 4) {
            this.createEditableButton(composite);
            this.createDerivedButton(composite);
        }
    }

    private String getDateStringValue(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            DateFormat format = DateFormat.getDateTimeInstance(1, 2);
            return format.format(new Date(localFile.lastModified()));
        }
        return NOT_EXIST_TEXT;
    }

    private String getLocationText(IResource resource) {
        File file;
        IPath resolvedLocation;
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resolvedLocation = resource.getLocation();
        if (resource.isLinked()) {
            location = resource.getRawLocation();
        }
        if (location == null) {
            return NOT_EXIST_TEXT;
        }
        String locationString = location.toOSString();
        if (resolvedLocation != null && !this.isPathVariable(resource) && !(file = resolvedLocation.toFile()).exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    private String getResolvedLocationText(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        String locationString = location.toOSString();
        File file = location.toFile();
        if (!file.exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    private String getSizeString(IFile file) {
        if (!file.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = file.getLocation();
        if (location == null) {
            if (file.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            String bytesString = Long.toString(localFile.length());
            return MessageFormat.format(BYTES_LABEL, bytesString);
        }
        return NOT_EXIST_TEXT;
    }

    private String getTypeString(IResource resource) {
        if (resource.getType() == 1) {
            if (resource.isLinked()) {
                return LINKED_FILE_LABEL;
            }
            return FILE_LABEL;
        }
        if (resource.getType() == 2) {
            if (resource.isLinked()) {
                return LINKED_FOLDER_LABEL;
            }
            return FOLDER_LABEL;
        }
        if (resource.getType() == 4) {
            return PROJECT_LABEL;
        }
        return UNKNOWN_LABEL;
    }

    private boolean isPathVariable(IResource resource) {
        if (!resource.isLinked()) {
            return false;
        }
        IPath resolvedLocation = resource.getLocation();
        if (resolvedLocation == null) {
            return true;
        }
        IPath rawLocation = resource.getRawLocation();
        return !resolvedLocation.equals((Object)rawLocation);
    }

    protected void performDefaults() {
        if (this.editableBox != null) {
            this.editableBox.setSelection(false);
        }
        if (this.derivedBox != null) {
            this.derivedBox.setSelection(false);
        }
    }

    public boolean performOk() {
        boolean localReadOnlyValue;
        IResource resource = (IResource)this.getElement();
        if (this.editableBox != null && this.previousReadOnlyValue != (localReadOnlyValue = this.editableBox.getSelection())) {
            resource.setReadOnly(localReadOnlyValue);
        }
        if (this.derivedBox != null) {
            try {
                boolean localDerivedValue = this.derivedBox.getSelection();
                if (this.previousDerivedValue != localDerivedValue) {
                    resource.setDerived(localDerivedValue);
                }
            }
            catch (CoreException exception) {
                ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("InternalError"), (String)exception.getLocalizedMessage(), (IStatus)exception.getStatus());
                return false;
            }
        }
        return true;
    }
}

