/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;

public class StartupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table pluginsList;
    private Workbench workbench;

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.startup_preference_page_context");
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.getString("StartupPreferencePage.label"));
        label.setFont(font);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        this.pluginsList = new Table(composite, 2848);
        data = new GridData(1808);
        this.pluginsList.setFont(font);
        this.pluginsList.setLayoutData((Object)data);
        this.populatePluginsList();
        return composite;
    }

    private void populatePluginsList() {
        IPluginDescriptor[] descriptors = this.workbench.getEarlyActivatedPlugins();
        IPreferenceStore store = this.workbench.getPreferenceStore();
        String pref = store.getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        if (pref == null) {
            pref = new String();
        }
        int i = 0;
        while (i < descriptors.length) {
            IPluginDescriptor desc = descriptors[i];
            TableItem item = new TableItem(this.pluginsList, 0);
            item.setText(desc.getLabel());
            item.setData((Object)desc);
            String id = String.valueOf(desc.getUniqueIdentifier()) + ';';
            item.setChecked(pref.indexOf(id) < 0);
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
        this.workbench = (Workbench)workbench;
    }

    protected void performDefaults() {
        TableItem[] items = this.pluginsList.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(true);
            ++i;
        }
    }

    public boolean performOk() {
        StringBuffer preference = new StringBuffer();
        TableItem[] items = this.pluginsList.getItems();
        int i = 0;
        while (i < items.length) {
            if (!items[i].getChecked()) {
                IPluginDescriptor descriptor = (IPluginDescriptor)items[i].getData();
                preference.append(descriptor.getUniqueIdentifier());
                preference.append(';');
            }
            ++i;
        }
        String pref = preference.toString();
        IPreferenceStore store = this.workbench.getPreferenceStore();
        store.putValue("PLUGINS_NOT_ACTIVATED_ON_STARTUP", pref);
        return true;
    }
}

