/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PreferenceErrorDialog;

public class WorkbenchPreferenceDialog
extends PreferenceDialog {
    private Button loadButton;
    private static final int LOAD_ID = 1025;
    private static final String LOAD_SETTING = "WorkbenchPreferenceDialog.load";
    private Button saveButton;
    private static final int SAVE_ID = 1026;
    private static final String SAVE_SETTING = "WorkbenchPreferenceDialog.save";
    private static final String PREFERENCE_EXT = "epf";
    private static final String[] DIALOG_PREFERENCE_EXTENSIONS = new String[]{"*.epf", "*.*"};

    public WorkbenchPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.loadPressed();
                return;
            }
            case 1026: {
                this.savePressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.loadButton = this.createButton(parent, 1025, WorkbenchMessages.getString(LOAD_SETTING), false);
        this.saveButton = this.createButton(parent, 1026, WorkbenchMessages.getString(SAVE_SETTING), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void loadPressed() {
        int result;
        String lastFilename = WorkbenchPlugin.getDefault().getDialogSettings().get(LOAD_SETTING);
        FileDialog d = new FileDialog(this.getShell(), 4096);
        d.setFileName(lastFilename);
        d.setFilterExtensions(DIALOG_PREFERENCE_EXTENSIONS);
        String filename = d.open();
        if (filename == null) {
            return;
        }
        Path path = new Path(filename);
        if (path.getFileExtension() == null && !path.toFile().exists()) {
            path = path.addFileExtension(PREFERENCE_EXT);
            filename = path.toOSString();
        }
        WorkbenchPlugin.getDefault().getDialogSettings().put(LOAD_SETTING, filename);
        IStatus status = Preferences.validatePreferenceVersions((IPath)path);
        if (status.getSeverity() == 4) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyErrorMessage", new Object[]{filename}), (IStatus)status);
            return;
        }
        if (status.getSeverity() == 2 && (result = PreferenceErrorDialog.openError(this.getShell(), WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyWarningMessage", new Object[]{filename}), status)) != 0) {
            return;
        }
        try {
            Preferences.importPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadErrorMessage", new Object[]{filename}), (IStatus)e.getStatus());
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadMessage", new Object[]{filename}));
        this.close();
    }

    protected void savePressed() {
        String lastFilename = WorkbenchPlugin.getDefault().getDialogSettings().get(SAVE_SETTING);
        FileDialog d = new FileDialog(this.getShell(), 8192);
        d.setFileName(lastFilename);
        d.setFilterExtensions(DIALOG_PREFERENCE_EXTENSIONS);
        String filename = d.open();
        if (filename == null) {
            return;
        }
        Path path = new Path(filename);
        if (path.getFileExtension() == null) {
            path = path.addFileExtension(PREFERENCE_EXT);
            filename = path.toOSString();
        }
        WorkbenchPlugin.getDefault().getDialogSettings().put(SAVE_SETTING, filename);
        File file = path.toFile();
        if (file.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.existsErrorMessage", new Object[]{filename}))) {
            return;
        }
        Iterator nodes = this.getPreferenceManager().getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (page == null || page.performOk()) continue;
            return;
        }
        long lastModified = file.lastModified();
        try {
            Preferences.exportPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.saveErrorMessage", new Object[]{filename}), (IStatus)e.getStatus());
            return;
        }
        if (file.exists() && file.lastModified() != lastModified) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.saveMessage", new Object[]{filename}));
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveErrorTitle"), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.noPreferencesMessage"));
        }
        this.close();
    }
}

