/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editorsupport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;

public final class ComponentSupport {
    static /* synthetic */ Class class$0;

    public static IEditorPart getComponentEditor() {
        if (SWT.getPlatform().equals("win32")) {
            return ComponentSupport.getOleEditor();
        }
        return null;
    }

    public static IEditorPart getComponentEditor(IFile input) {
        if (SWT.getPlatform().equals("win32") && ComponentSupport.testForOleEditor(input)) {
            return ComponentSupport.getOleEditor();
        }
        return null;
    }

    private static IEditorPart getOleEditor() {
        try {
            Class<?> oleEditorClass = Class.forName("org.eclipse.ui.internal.editorsupport.win32.OleEditor");
            return (IEditorPart)oleEditorClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    public static boolean testForOleEditor(IFile input) {
        String strName = input.getName();
        int nDot = strName.lastIndexOf(46);
        if (nDot >= 0) {
            try {
                strName = strName.substring(nDot);
                Class<?> oleClass = Class.forName("org.eclipse.swt.ole.win32.OLE");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Method findMethod = oleClass.getDeclaredMethod("findProgramID", classArray);
                strName = (String)findMethod.invoke(null, strName);
                if (strName.length() > 0) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
        }
        return false;
    }
}

