/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.registry.MarkerQuery;
import org.eclipse.ui.internal.registry.MarkerQueryResult;
import org.eclipse.ui.internal.registry.RegistryReader;

public class MarkerHelpRegistryReader
extends RegistryReader {
    private ArrayList markerQueries;
    private MarkerHelpRegistry markerHelpRegistry;
    private ArrayList currentAttributeNames;
    private ArrayList currentAttributeValues;
    private static final String TAG_HELP = "markerHelp";
    private static final String TAG_RESOLUTION_GENERATOR = "markerResolutionGenerator";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String ATT_TYPE = "markerType";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";

    public void addHelp(MarkerHelpRegistry registry) {
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        this.markerHelpRegistry = registry;
        this.markerQueries = new ArrayList();
        this.readRegistry(pluginRegistry, "org.eclipse.ui", TAG_HELP);
        this.markerQueries = new ArrayList();
        this.readRegistry(pluginRegistry, "org.eclipse.ui", "markerResolution");
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_HELP)) {
            this.readHelpElement(element);
            return true;
        }
        if (element.getName().equals(TAG_RESOLUTION_GENERATOR)) {
            this.readResolutionElement(element);
            return true;
        }
        if (element.getName().equals(TAG_ATTRIBUTE)) {
            this.readAttributeElement(element);
            return true;
        }
        return false;
    }

    private void readHelpElement(IConfigurationElement element) {
        String type = element.getAttribute(ATT_TYPE);
        this.currentAttributeNames = new ArrayList();
        this.currentAttributeValues = new ArrayList();
        this.readElementChildren(element);
        String[] attributeNames = this.currentAttributeNames.toArray(new String[this.currentAttributeNames.size()]);
        String[] attributeValues = this.currentAttributeValues.toArray(new String[this.currentAttributeValues.size()]);
        MarkerQuery query = new MarkerQuery(type, attributeNames);
        MarkerQueryResult result = new MarkerQueryResult(attributeValues);
        this.markerHelpRegistry.addHelpQuery(query, result, element);
    }

    private void readResolutionElement(IConfigurationElement element) {
        String type = element.getAttribute(ATT_TYPE);
        this.currentAttributeNames = new ArrayList();
        this.currentAttributeValues = new ArrayList();
        this.readElementChildren(element);
        String[] attributeNames = this.currentAttributeNames.toArray(new String[this.currentAttributeNames.size()]);
        String[] attributeValues = this.currentAttributeValues.toArray(new String[this.currentAttributeValues.size()]);
        MarkerQuery query = new MarkerQuery(type, attributeNames);
        MarkerQueryResult result = new MarkerQueryResult(attributeValues);
        this.markerHelpRegistry.addResolutionQuery(query, result, element);
    }

    private void readAttributeElement(IConfigurationElement element) {
        String name = element.getAttribute(ATT_NAME);
        String value = element.getAttribute(ATT_VALUE);
        if (name != null && value != null) {
            this.currentAttributeNames.add(name);
            this.currentAttributeValues.add(value);
        }
    }
}

