/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.IMarkerImageProvider;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.MarkerImageProviderRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class MarkerImageProviderRegistry {
    private static final String ATT_PROVIDER_CLASS = "class";
    private static final String ATT_ICON = "icon";
    private static final String ATT_MARKER_TYPE = "markertype";
    private static final String ATT_ID = "id";
    private static final String MARKER_ATT_KEY = "org.eclipse.ui.internal.registry.MarkerImageProviderRegistry";
    private static final String TAG_PROVIDER = "imageprovider";
    private ArrayList descriptors = new ArrayList();

    public MarkerImageProviderRegistry() {
        class MarkerImageReader
        extends RegistryReader {
            final /* synthetic */ MarkerImageProviderRegistry this$0;

            MarkerImageReader(MarkerImageProviderRegistry markerImageProviderRegistry) {
                this.this$0 = markerImageProviderRegistry;
            }

            protected boolean readElement(IConfigurationElement element) {
                if (element.getName().equals("imageprovider")) {
                    this.this$0.addProvider(element);
                    return true;
                }
                return false;
            }

            public void readRegistry() {
                this.readRegistry(Platform.getPluginRegistry(), "org.eclipse.ui", "markerImageProviders");
            }
        }
        new MarkerImageReader(this).readRegistry();
    }

    public void addProvider(IConfigurationElement element) {
        Descriptor desc = new Descriptor();
        desc.element = element;
        desc.pluginDescriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        desc.id = element.getAttribute(ATT_ID);
        desc.markerType = element.getAttribute(ATT_MARKER_TYPE);
        desc.imagePath = element.getAttribute(ATT_ICON);
        desc.className = element.getAttribute(ATT_PROVIDER_CLASS);
        if (desc.imagePath != null) {
            desc.imageDescriptor = this.getImageDescriptor(desc);
        }
        if (desc.className == null) {
            desc.element = null;
            desc.pluginDescriptor = null;
        }
        this.descriptors.add(desc);
    }

    public ImageDescriptor getImageDescriptor(IMarker marker) {
        int size = this.descriptors.size();
        int i = 0;
        while (i < size) {
            Descriptor desc = (Descriptor)this.descriptors.get(i);
            try {
                if (marker.isSubtypeOf(desc.markerType)) {
                    if (desc.className != null) {
                        if (desc.pluginDescriptor.isPluginActivated()) {
                            String path;
                            if (desc.provider == null) {
                                desc.provider = (IMarkerImageProvider)WorkbenchPlugin.createExtension(desc.element, ATT_PROVIDER_CLASS);
                            }
                            if ((path = desc.provider.getImagePath(marker)) != desc.imagePath) {
                                desc.imagePath = path;
                                desc.imageDescriptor = this.getImageDescriptor(desc);
                                return desc.imageDescriptor;
                            }
                            return desc.imageDescriptor;
                        }
                        if (desc.imageDescriptor == null) {
                            desc.imagePath = (String)marker.getAttribute(MARKER_ATT_KEY);
                            desc.imageDescriptor = this.getImageDescriptor(desc);
                        }
                        return desc.imageDescriptor;
                    }
                    if (desc.imageDescriptor != null) {
                        return desc.imageDescriptor;
                    }
                }
            }
            catch (CoreException e) {
                WorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, "Exception creating image descriptor for: " + desc.markerType, (Throwable)e));
                return null;
            }
            ++i;
        }
        return null;
    }

    ImageDescriptor getImageDescriptor(Descriptor desc) {
        try {
            URL installURL = desc.pluginDescriptor.getInstallURL();
            URL url = new URL(installURL, desc.imagePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    class Descriptor {
        String id;
        String markerType;
        String className;
        String imagePath;
        ImageDescriptor imageDescriptor;
        IConfigurationElement element;
        IPluginDescriptor pluginDescriptor;
        IMarkerImageProvider provider;

        Descriptor() {
        }
    }
}

