/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EmptyPreferencePage;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.misc.Sorter;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PreferencePageRegistryReader
extends RegistryReader {
    public static final String ATT_CATEGORY = "category";
    public static final String ATT_CLASS = "class";
    public static final String ATT_NAME = "name";
    public static final String ATT_ID = "id";
    public static final String TAG_PAGE = "page";
    public static final String ATT_ICON = "icon";
    public static final String PREFERENCE_SEPARATOR = "/";
    private List nodes;
    private IWorkbench workbench;

    public PreferencePageRegistryReader(IWorkbench newWorkbench) {
        this.workbench = newWorkbench;
    }

    private WorkbenchPreferenceNode findNode(String id) {
        int i = 0;
        while (i < this.nodes.size()) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)((Object)this.nodes.get(i));
            if (node.getId().equals(id)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private WorkbenchPreferenceNode findNode(WorkbenchPreferenceNode parent, String id) {
        IPreferenceNode[] nodes = parent.getSubNodes();
        int i = 0;
        while (i < nodes.length) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)nodes[i];
            if (node.getId().equals(id)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public List getPreferenceContributions(IPluginRegistry registry) {
        this.loadNodesFromRegistry(registry);
        ArrayList<WorkbenchPreferenceNode> contributions = new ArrayList<WorkbenchPreferenceNode>();
        WorkbenchPreferenceNode workbenchNode = this.findNode("org.eclipse.ui.preferencePages.Workbench");
        if (workbenchNode == null) {
            workbenchNode = new WorkbenchPreferenceNode("org.eclipse.ui.preferencePages.Workbench", "Workbench", null, null, new EmptyPreferencePage());
            this.nodes.add(workbenchNode);
        }
        contributions.add(workbenchNode);
        Object[] sortedNodes = this.sortByCategories(this.nodes);
        int i = 0;
        while (i < sortedNodes.length) {
            CategoryNode categoryNode = (CategoryNode)sortedNodes[i];
            WorkbenchPreferenceNode node = categoryNode.getNode();
            if (node != workbenchNode) {
                String category = node.getCategory();
                if (category == null) {
                    contributions.add(node);
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(category, PREFERENCE_SEPARATOR);
                    WorkbenchPreferenceNode parent = null;
                    while (tokenizer.hasMoreElements()) {
                        String currentToken = tokenizer.nextToken();
                        WorkbenchPreferenceNode child = null;
                        child = parent == null ? this.findNode(currentToken) : this.findNode(parent, currentToken);
                        if (child == null) {
                            parent = null;
                            break;
                        }
                        parent = child;
                    }
                    if (parent != null) {
                        parent.add((IPreferenceNode)node);
                    } else {
                        WorkbenchPlugin.log("Invalid preference page path: " + categoryNode.getFlatCategory());
                        contributions.add(node);
                    }
                }
            }
            ++i;
        }
        return contributions;
    }

    protected void loadNodesFromRegistry(IPluginRegistry registry) {
        this.nodes = new ArrayList();
        this.readRegistry(registry, "org.eclipse.ui", "preferencePages");
    }

    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_PAGE)) {
            return false;
        }
        String name = element.getAttribute(ATT_NAME);
        String id = element.getAttribute(ATT_ID);
        String category = element.getAttribute(ATT_CATEGORY);
        String imageName = element.getAttribute(ATT_ICON);
        String className = element.getAttribute(ATT_CLASS);
        if (name == null) {
            this.logMissingAttribute(element, ATT_NAME);
        }
        if (id == null) {
            this.logMissingAttribute(element, ATT_ID);
        }
        if (className == null) {
            this.logMissingAttribute(element, ATT_CLASS);
        }
        if (name == null || id == null || className == null) {
            return true;
        }
        ImageDescriptor image = null;
        if (imageName != null) {
            image = WorkbenchImages.getImageDescriptorFromPlugin(element.getDeclaringExtension().getDeclaringPluginDescriptor(), imageName);
        }
        WorkbenchPreferenceNode node = new WorkbenchPreferenceNode(id, name, category, image, element, this.workbench);
        this.nodes.add(node);
        this.readElementChildren(element);
        return true;
    }

    private Object[] sortByCategories(List nodes) {
        Object[] nodeArray = new CategoryNode[nodes.size()];
        int i = 0;
        while (i < nodes.size()) {
            nodeArray[i] = new CategoryNode((WorkbenchPreferenceNode)((Object)nodes.get(i)));
            ++i;
        }
        Sorter sorter = new Sorter(){
            private Collator collator = Collator.getInstance();

            public boolean compare(Object o1, Object o2) {
                String s1 = ((CategoryNode)o1).getFlatCategory();
                String s2 = ((CategoryNode)o2).getFlatCategory();
                return this.collator.compare(s2, s1) > 0;
            }
        };
        return sorter.sort(nodeArray);
    }

    class CategoryNode {
        private WorkbenchPreferenceNode node;
        private String flatCategory;

        public CategoryNode(WorkbenchPreferenceNode node) {
            this.node = node;
        }

        public WorkbenchPreferenceNode getNode() {
            return this.node;
        }

        public String getFlatCategory() {
            if (this.flatCategory == null) {
                this.initialize();
                if (this.flatCategory == null) {
                    this.flatCategory = this.node.getLabelText();
                }
            }
            return this.flatCategory;
        }

        private void initialize() {
            String category = this.node.getCategory();
            if (category == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            StringTokenizer stok = new StringTokenizer(category, PreferencePageRegistryReader.PREFERENCE_SEPARATOR);
            WorkbenchPreferenceNode immediateParent = null;
            while (stok.hasMoreTokens()) {
                String pathID = stok.nextToken();
                immediateParent = PreferencePageRegistryReader.this.findNode(pathID);
                if (immediateParent == null) {
                    return;
                }
                if (sb.length() > 0) {
                    sb.append(PreferencePageRegistryReader.PREFERENCE_SEPARATOR);
                }
                sb.append(immediateParent.getLabelText());
            }
            if (sb.length() > 0) {
                sb.append(PreferencePageRegistryReader.PREFERENCE_SEPARATOR);
            }
            sb.append(this.node.getLabelText());
            this.flatCategory = sb.toString();
        }
    }
}

