/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WorkingSetDescriptor {
    private String id;
    private String name;
    private String icon;
    private String pageClassName;
    private IConfigurationElement configElement;
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_PAGE_CLASS = "pageClass";

    public WorkingSetDescriptor(IConfigurationElement configElement) throws CoreException {
        this.configElement = configElement;
        this.id = configElement.getAttribute(ATT_ID);
        this.name = configElement.getAttribute(ATT_NAME);
        this.icon = configElement.getAttribute(ATT_ICON);
        this.pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        if (this.name == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing class name): " + this.id, null));
        }
        if (this.pageClassName == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing page class name): " + this.id, null));
        }
    }

    public IWorkingSetPage createWorkingSetPage() {
        Object page = null;
        if (this.pageClassName != null) {
            try {
                page = WorkbenchPlugin.createExtension(this.configElement, ATT_PAGE_CLASS);
            }
            catch (CoreException exception) {
                WorkbenchPlugin.log("Unable to create working set page: " + this.pageClassName, exception.getStatus());
            }
        }
        return (IWorkingSetPage)page;
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            return null;
        }
        return WorkbenchImages.getImageDescriptorFromExtension(this.configElement.getDeclaringExtension(), this.icon);
    }

    public String getId() {
        return this.id;
    }

    public String getPageClassName() {
        return this.pageClassName;
    }

    public String getName() {
        return this.name;
    }
}

