/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;

public class WizardExternalProjectImportPage
extends WizardPage {
    private FileFilter projectFilter = new FileFilter(){

        public boolean accept(File pathName) {
            return pathName.getName().equals(".project");
        }
    };
    private static String previouslyBrowsedDirectory = "";
    private Text projectNameField;
    private Text locationPathField;
    private Button browseButton;
    private IProjectDescription description;
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardExternalProjectImportPage.this.setPageComplete(WizardExternalProjectImportPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public WizardExternalProjectImportPage() {
        super("wizardExternalProjectPage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.getString("WizardExternalProjectImportPage.title"));
        this.setDescription(DataTransferMessages.getString("WizardExternalProjectImportPage.description"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, "org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(parent.getFont());
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(DataTransferMessages.getString("WizardExternalProjectImportPage.projectContentsLabel"));
        projectContentsLabel.setFont(parent.getFont());
        this.createUserSpecifiedProjectLocationGroup(projectGroup);
    }

    private final void createProjectNameGroup(Composite parent) {
        Font dialogFont = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setFont(dialogFont);
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(DataTransferMessages.getString("WizardExternalProjectImportPage.nameLabel"));
        projectLabel.setFont(dialogFont);
        this.projectNameField = new Text(projectGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(dialogFont);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup) {
        Font dialogFont = projectGroup.getFont();
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(dialogFont);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(DataTransferMessages.getString("WizardExternalProjectImportPage.browseLabel"));
        this.browseButton.setFont(dialogFont);
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardExternalProjectImportPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(DataTransferMessages.getString("WizardExternalProjectImportPage.directoryLabel"));
        String dirName = this.getProjectLocationFieldValue();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(this.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.locationPathField.setText(previouslyBrowsedDirectory);
            this.setProjectName(this.projectFile(previouslyBrowsedDirectory));
        }
    }

    private boolean validatePage() {
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(DataTransferMessages.getString("WizardExternalProjectImportPage.projectLocationEmpty"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(DataTransferMessages.getString("WizardExternalProjectImportPage.locationError"));
            return false;
        }
        File projectFile = this.projectFile(locationFieldContents);
        if (projectFile == null) {
            this.setErrorMessage(DataTransferMessages.format("WizardExternalProjectImportPage.notAProject", new String[]{locationFieldContents}));
            return false;
        }
        this.setProjectName(projectFile);
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(DataTransferMessages.getString("WizardExternalProjectImportPage.projectExistsMessage"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private IWorkspace getWorkspace() {
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        return workspace;
    }

    private boolean isPrefixOfRoot(IPath locationPath) {
        return Platform.getLocation().isPrefixOf(locationPath);
    }

    private void setProjectName(File projectFile) {
        if (projectFile == null) {
            return;
        }
        Path path = new Path(projectFile.getPath());
        IProjectDescription newDescription = null;
        try {
            newDescription = this.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (CoreException coreException) {}
        if (newDescription == null) {
            this.description = null;
            this.projectNameField.setText("");
        } else {
            this.description = newDescription;
            this.projectNameField.setText(this.description.getName());
        }
    }

    private File projectFile(String locationFieldContents) {
        File directory = new File(locationFieldContents);
        if (directory.isFile()) {
            return null;
        }
        File[] files = directory.listFiles(this.projectFilter);
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }

    IProject createExistingProject() {
        String projectName = this.projectNameField.getText();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        if (this.description == null) {
            this.description = workspace.newProjectDescription(projectName);
            IPath locationPath = this.getLocationPath();
            if (this.isPrefixOfRoot(locationPath)) {
                this.description.setLocation(null);
            } else {
                this.description.setLocation(locationPath);
            }
        } else {
            this.description.setName(projectName);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 2000);
                project.create(WizardExternalProjectImportPage.this.description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.getString("WizardExternalProjectImportPage.errorMessage"), (String)DataTransferMessages.getString("WizardExternalProjectImportPage.caseVariantExistsError"));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.getString("WizardExternalProjectImportPage.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
                }
            }
            return null;
        }
        return project;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.locationPathField.setFocus();
        }
    }
}

