/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.command;

import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.ejb.CMPAttribute;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.logger.proxy.Logger;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public class FixPrimKeyCommand
extends AbstractCommand {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private EJBJarFile ejbJarFile;

    public FixPrimKeyCommand(EJBJarFile eJBJarFile) {
        this.ejbJarFile = eJBJarFile;
    }

    public void execute() {
        EList eList = this.ejbJarFile.getDeploymentDescriptor().getEnterpriseBeans();
        int n = 0;
        while (n < eList.size()) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(n);
            if (enterpriseBean.isContainerManagedEntity()) {
                this.fixKeyFor((ContainerManagedEntity)enterpriseBean);
            }
            ++n;
        }
    }

    protected void fixKeyFor(ContainerManagedEntity containerManagedEntity) {
        CMPAttribute cMPAttribute = containerManagedEntity.getPrimaryKeyAttribute();
        if (cMPAttribute == null) {
            return;
        }
        Field field = cMPAttribute.getField();
        if (field == null) {
            if (!containerManagedEntity.getPrimaryKey().isExistingType()) {
                Logger.getLogger().logWarning(ResourceHandler.getString("key_class_reflection_ERROR_", new Object[]{containerManagedEntity.getPrimaryKey().getQualifiedName(), cMPAttribute.getName(), containerManagedEntity.getName()}));
            }
            return;
        }
        JavaHelpers javaHelpers = (JavaHelpers)field.getEType();
        if (javaHelpers == null) {
            Logger.getLogger().logWarning(ResourceHandler.getString("key_field_reflection_ERROR_", new Object[]{cMPAttribute.getName(), containerManagedEntity.getName()}));
        }
        if (javaHelpers != containerManagedEntity.getPrimaryKey()) {
            Logger.getLogger().logWarning(ResourceHandler.getString("removing_key_field_INFO_", new Object[]{cMPAttribute.getName(), containerManagedEntity.getName()}));
            containerManagedEntity.getKeyAttributes().remove((Object)cMPAttribute);
            cMPAttribute.setEType((EClassifier)javaHelpers);
        }
    }

    public static void main(String[] stringArray) {
        block4: {
            if (!FixPrimKeyCommand.validateArgs(stringArray)) {
                return;
            }
            try {
                EJBJarFile eJBJarFile = ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory().openEJBJarFile(stringArray[0]);
                new FixPrimKeyCommand(eJBJarFile).execute();
                if (stringArray.length > 1) {
                    eJBJarFile.saveAs(stringArray[1]);
                    break block4;
                }
                eJBJarFile.save();
            }
            catch (Exception exception) {
                System.out.println(ResourceHandler.getString("FixPrimKeyCommand_failed_-_EXC_"));
                exception.printStackTrace();
            }
        }
    }

    public void redo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static boolean validateArgs(String[] var0) {
        block13: {
            if (var0.length != 1 && var0.length != 2) {
                Logger.getLogger().logError(ResourceHandler.getString("FixPrimKeyCommand_usage___"));
                return false;
            }
            var1_1 = new File(var0[0]);
            var2_2 = false;
            var3_3 = null;
            try {
                var3_3 = new ZipFile(var1_1);
                var2_2 = true;
                var6_4 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var7_9) {
                        // empty catch block
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (IOException var7_7) {}
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (IOException var4_10) {
                    var2_2 = false;
                    var6_5 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var7_8) {}
                    }
                }
            }
        }
        if (!var2_2 && !var1_1.isDirectory()) {
            Logger.getLogger().logError(ResourceHandler.getString("FixPrimKeyCommand_usage__s_EXC_"));
            return false;
        }
        return true;
    }
}

