/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.command;

import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.logger.proxy.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;

public class RepairArchiveCommand
extends AbstractCommand {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Archive archive;
    protected static Map uriNames;
    protected static Map directoryNames;

    public RepairArchiveCommand(Archive archive) {
        super("Repair Archive", ResourceHandler.getString("Repairs_all_entries_in_the"));
        this.archive = archive;
        RepairArchiveCommand.getDirectoryNames();
        RepairArchiveCommand.getUriNames();
    }

    public void execute() {
        EList eList = this.archive.getFiles();
        int n = 0;
        while (n < eList.size()) {
            com.ibm.etools.commonarchive.File file = (com.ibm.etools.commonarchive.File)eList.get(n);
            if (file.isArchive()) {
                new RepairArchiveCommand((Archive)file).execute();
            } else {
                String string = file.getURI().toUpperCase();
                if (uriNames.containsKey(string)) {
                    file.setURI((String)uriNames.get(string));
                } else {
                    Iterator iterator = directoryNames.entrySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = file.getURI();
                        Map.Entry entry = iterator.next();
                        String string3 = (String)entry.getKey();
                        String string4 = (String)entry.getValue();
                        if (!string.startsWith(string3) || string2.startsWith(string4)) continue;
                        String string5 = string2.substring(string3.length());
                        file.setURI(string4.concat(string5));
                        break;
                    }
                }
            }
            ++n;
        }
    }

    protected static Map getDirectoryNames() {
        if (directoryNames == null) {
            directoryNames = new HashMap(6);
            directoryNames.put("META-INF".toUpperCase(), "META-INF");
            directoryNames.put("WEB-INF".toUpperCase(), "WEB-INF");
            directoryNames.put("WEB-INF/lib/".toUpperCase(), "WEB-INF/lib/");
            directoryNames.put("WEB-INF/classes/".toUpperCase(), "WEB-INF/classes/");
        }
        return directoryNames;
    }

    public Collection getResult() {
        return Arrays.asList(this.archive);
    }

    protected static Map getUriNames() {
        if (uriNames == null) {
            uriNames = new HashMap(20);
            uriNames.put("META-INF/MANIFEST.MF".toUpperCase(), "META-INF/MANIFEST.MF");
            uriNames.put("META-INF/application-client.xml".toUpperCase(), "META-INF/application-client.xml");
            uriNames.put("META-INF/ibm-application-client-bnd.xmi".toUpperCase(), "META-INF/ibm-application-client-bnd.xmi");
            uriNames.put("META-INF/client-resource.xmi".toUpperCase(), "META-INF/client-resource.xmi");
            uriNames.put("META-INF/application.xml".toUpperCase(), "META-INF/application.xml");
            uriNames.put("META-INF/ibm-application-bnd.xmi".toUpperCase(), "META-INF/ibm-application-bnd.xmi");
            uriNames.put("META-INF/ibm-application-ext.xmi".toUpperCase(), "META-INF/ibm-application-ext.xmi");
            uriNames.put("META-INF/ejb-jar.xml".toUpperCase(), "META-INF/ejb-jar.xml");
            uriNames.put("META-INF/ibm-ejb-jar-bnd.xmi".toUpperCase(), "META-INF/ibm-ejb-jar-bnd.xmi");
            uriNames.put("META-INF/ibm-ejb-jar-ext.xmi".toUpperCase(), "META-INF/ibm-ejb-jar-ext.xmi");
            uriNames.put("WEB-INF/web.xml".toUpperCase(), "WEB-INF/web.xml");
            uriNames.put("WEB-INF/ibm-web-bnd.xmi".toUpperCase(), "WEB-INF/ibm-web-bnd.xmi");
            uriNames.put("WEB-INF/ibm-web-ext.xmi".toUpperCase(), "WEB-INF/ibm-web-ext.xmi");
            uriNames.put("META-INF/ra.xml".toUpperCase(), "META-INF/ra.xml");
        }
        return uriNames;
    }

    public static void main(String[] stringArray) {
        if (!RepairArchiveCommand.validateArgs(stringArray)) {
            return;
        }
        try {
            Archive archive = ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory().primOpenArchive(stringArray[0]);
            new RepairArchiveCommand(archive).execute();
            archive.saveAs(stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println(ResourceHandler.getString("Repair_command_failed_-_ex_EXC_"));
            exception.printStackTrace();
        }
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static boolean validateArgs(String[] var0) {
        block14: {
            if (var0.length != 2) {
                Logger.getLogger().logError(ResourceHandler.getString("RepairArchiveCommand_usage"));
                return false;
            }
            var1_1 = new File(var0[0]);
            var2_2 = false;
            var3_3 = null;
            try {
                var3_3 = new ZipFile(var1_1);
                var2_2 = true;
                var6_4 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var7_9) {
                        // empty catch block
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (IOException var7_7) {}
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (IOException var4_10) {
                    var2_2 = false;
                    var6_5 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var7_8) {}
                    }
                }
            }
        }
        if (!var2_2 && !var1_1.isDirectory()) {
            System.out.println(ResourceHandler.getString("RepairArchiveCommand_usage1_ERROR_"));
            return false;
        }
        if (new File(var0[1]).canWrite()) {
            System.out.println(ResourceHandler.getString("repair_usage_ERROR_", new Object[]{var0[1]}));
            return false;
        }
        return true;
    }
}

