/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.command;

import com.ibm.etools.archive.command.XmlValidationResult;
import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.j2ee.xml.CollectingErrorHandler;
import com.ibm.etools.j2ee.xml.bridge.XmlDocumentReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class ValidateXmlCommand
extends AbstractCommand {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected List results;
    protected ModuleFile archive;
    public boolean validateNested = true;

    protected ValidateXmlCommand() {
    }

    public ValidateXmlCommand(ModuleFile moduleFile) {
        this.archive = moduleFile;
    }

    protected ValidateXmlCommand(String string) {
        super(string);
    }

    protected ValidateXmlCommand(String string, String string2) {
        super(string, string2);
    }

    public void execute() {
        this.results = new ArrayList();
        this.validatateXml();
        if (this.isValidateNested()) {
            List list = this.archive.getArchiveFiles();
            int n = 0;
            while (n < list.size()) {
                Archive archive = (Archive)list.get(n);
                if (archive.isModuleFile()) {
                    ModuleFile moduleFile = (ModuleFile)archive;
                    ValidateXmlCommand validateXmlCommand = new ValidateXmlCommand(moduleFile);
                    validateXmlCommand.execute();
                    this.results.addAll(validateXmlCommand.getResult());
                }
                ++n;
            }
        }
    }

    public Collection getResult() {
        return this.results;
    }

    public boolean isValidateNested() {
        return this.validateNested;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    public void setValidateNested(boolean bl) {
        this.validateNested = bl;
    }

    protected void validatateXml() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Resource resource = this.archive.getStandardDeploymentDescriptor().eResource();
        XmlValidationResult xmlValidationResult = new XmlValidationResult();
        xmlValidationResult.setArchive(this.archive);
        try {
            resource.save((OutputStream)byteArrayOutputStream, new HashMap());
        }
        catch (Exception exception) {
            throw new ArchiveRuntimeException(exception);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputSource inputSource = new InputSource(byteArrayInputStream);
        CollectingErrorHandler collectingErrorHandler = new CollectingErrorHandler();
        XmlDocumentReader xmlDocumentReader = new XmlDocumentReader(inputSource, null, (ErrorHandler)collectingErrorHandler);
        try {
            xmlDocumentReader.parseDocument();
        }
        catch (RuntimeException runtimeException) {
            if (collectingErrorHandler.getCaughtExceptions() != null) {
                xmlValidationResult.setArchive(this.archive);
                xmlValidationResult.setCaughtExceptions(collectingErrorHandler.getCaughtExceptions());
                this.results.add(xmlValidationResult);
            }
            throw runtimeException;
        }
        xmlValidationResult.setArchive(this.archive);
        xmlValidationResult.setCaughtExceptions(collectingErrorHandler.getCaughtExceptions());
        this.results.add(xmlValidationResult);
    }
}

