/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.ejb10;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndFactory;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.impl.EjbbndFactoryImpl;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.Identity;
import com.ibm.ejs.models.base.extensions.ejbext.IsolationLevelAttributes;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SessionExtension;
import com.ibm.ejs.models.base.extensions.ejbext.TxIsolationLevel;
import com.ibm.ejs.models.base.extensions.ejbext.impl.EjbextFactoryImpl;
import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.ArchiveTypeDiscriminator;
import com.ibm.etools.archive.ImportStrategy;
import com.ibm.etools.archive.ejb10.DDNames;
import com.ibm.etools.archive.ejb10.EJBJar10ImportStrategy;
import com.ibm.etools.archive.ejb10.Ejb10ManifestComparatorImpl;
import com.ibm.etools.archive.exception.DeploymentDescriptorLoadException;
import com.ibm.etools.archive.exception.NoEJB10DescriptorsException;
import com.ibm.etools.archive.exception.NotADeploymentDescriptorException;
import com.ibm.etools.archive.exception.OpenFailureException;
import com.ibm.etools.archive.impl.ArchiveTypeDiscriminatorImpl;
import com.ibm.etools.archive.impl.ImportStrategyImpl;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.archive.util.ObjectInputStreamCustomResolver;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EjbFactory;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.Session;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.common.util.IDUtility;
import com.ibm.etools.j2ee.ejb10.readers.AssemblyDescriptor10ReadAdaptor;
import com.ibm.etools.j2ee.ejb10.readers.ContainerManagedEntity10ReadAdapter;
import com.ibm.etools.j2ee.ejb10.readers.EnterpriseBean10ReadAdapter;
import com.ibm.etools.j2ee.ejb10.readers.Entity10ReadAdapter;
import com.ibm.etools.j2ee.ejb10.readers.Session10ReadAdapter;
import com.ibm.etools.java.adapters.ReflectionAdaptor;
import com.ibm.etools.logger.proxy.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class EJBJar10ImportStrategyImpl
extends ImportStrategyImpl
implements EJBJar10ImportStrategy {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Map deploymentDescriptors;
    protected DDNames ddNames;
    protected static Discriminator discriminator;

    public void addAssemblyDescriptor() {
        EJBJar eJBJar = this.getEjbJar();
        AssemblyDescriptor assemblyDescriptor = this.getEjbFactory().createAssemblyDescriptor();
        AssemblyDescriptor10ReadAdaptor assemblyDescriptor10ReadAdaptor = new AssemblyDescriptor10ReadAdaptor((Notifier)assemblyDescriptor, this.getDeploymentDescriptors());
        eJBJar.setAssemblyDescriptor(assemblyDescriptor);
        assemblyDescriptor10ReadAdaptor.reflectValuesIfNecessary();
    }

    public void addBindings() {
        EJBJarBinding eJBJarBinding = this.getEJBJarFile().getBindings();
        Iterator iterator = this.getDeploymentDescriptors().values().iterator();
        while (iterator.hasNext()) {
            this.addEjbBinding((DeploymentDescriptor)iterator.next(), eJBJarBinding);
        }
    }

    protected EnterpriseBeanBinding addEjbBinding(DeploymentDescriptor deploymentDescriptor, EJBJarBinding eJBJarBinding) {
        EnterpriseBean enterpriseBean = this.getEnterpriseBeanFor(deploymentDescriptor);
        EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding(enterpriseBean);
        enterpriseBeanBinding.setJndiName(deploymentDescriptor.getBeanHomeName().toString());
        return enterpriseBeanBinding;
    }

    protected EnterpriseBeanExtension addEjbExtension(DeploymentDescriptor deploymentDescriptor, EJBJarExtension eJBJarExtension) {
        ControlDescriptor[] controlDescriptorArray;
        EnterpriseBean enterpriseBean = this.getEnterpriseBeanFor(deploymentDescriptor);
        EnterpriseBeanExtension enterpriseBeanExtension = eJBJarExtension.getEJBExtension(enterpriseBean);
        if (enterpriseBeanExtension.isSession()) {
            ((SessionExtension)enterpriseBeanExtension).setTimeout(((SessionDescriptor)deploymentDescriptor).getSessionTimeout());
        }
        if ((controlDescriptorArray = deploymentDescriptor.getControlDescriptors()) != null) {
            int n = 0;
            while (n < controlDescriptorArray.length) {
                ControlDescriptor controlDescriptor = controlDescriptorArray[n];
                enterpriseBeanExtension.getRunAsSettings().add((Object)this.convertControlDescriptor(deploymentDescriptor, controlDescriptor));
                ++n;
            }
        }
        return enterpriseBeanExtension;
    }

    public void addEnterpriseBeans() {
        EJBJar eJBJar = this.getEjbJar();
        if (this.getDeploymentDescriptors().isEmpty()) {
            throw new DeploymentDescriptorLoadException(ResourceHandler.getString("no_dds_10_EXC_", new Object[]{this.getArchive().getURI()}));
        }
        List list = this.getDeploymentDescriptorNames();
        int n = 0;
        while (n < list.size()) {
            String string = (String)list.get(n);
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)this.getDeploymentDescriptors().get(string);
            EnterpriseBean enterpriseBean = this.createEnterpriseBeanFor(deploymentDescriptor);
            eJBJar.getEnterpriseBeans().add((Object)enterpriseBean);
            IDUtility.setDefaultID((EObject)enterpriseBean);
            ReflectionAdaptor reflectionAdaptor = ReflectionAdaptor.retrieveAdaptorFrom((EObject)enterpriseBean);
            reflectionAdaptor.reflectValuesIfNecessary();
            ++n;
        }
    }

    public void addExtensions() {
        EJBJarExtension eJBJarExtension = this.getEJBJarFile().getExtensions();
        Iterator iterator = this.getDeploymentDescriptors().values().iterator();
        while (iterator.hasNext()) {
            this.addEjbExtension((DeploymentDescriptor)iterator.next(), eJBJarExtension);
        }
    }

    protected SecurityIdentity convertControlDescriptor(DeploymentDescriptor deploymentDescriptor, ControlDescriptor controlDescriptor) {
        MethodElement methodElement;
        Object object;
        Object object2;
        SecurityIdentity securityIdentity = this.getExtensionsFactory().createSecurityIdentity();
        int n = controlDescriptor.getRunAsMode();
        if (n == 0) {
            object2 = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory().createUseCallerIdentity();
            securityIdentity.setRunAsMode((RunAsMode)object2);
        } else if (n == 2) {
            object2 = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory().createUseSystemIdentity();
            securityIdentity.setRunAsMode((RunAsMode)object2);
        } else if (n == 1) {
            object2 = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory().createRunAsSpecifiedIdentity();
            securityIdentity.setRunAsMode((RunAsMode)object2);
            object = controlDescriptor.getRunAsIdentity();
            if (object != null) {
                methodElement = this.getExtensionsFactory().createIdentity();
                methodElement.setRoleName(controlDescriptor.getRunAsIdentity().toString());
                methodElement.setDescription(controlDescriptor.getRunAsIdentity().getInfo());
                object2.setRunAsSpecifiedIdentity((Identity)methodElement);
            }
        }
        object2 = controlDescriptor.getMethod();
        object = this.getEjbFactory().createMethodElementFrom((Method)object2);
        methodElement = this.getEjbFactory().createMethodElementFrom((Method)object2);
        EnterpriseBean enterpriseBean = this.getEnterpriseBeanFor(deploymentDescriptor);
        object.setEnterpriseBean(enterpriseBean);
        methodElement.setEnterpriseBean(enterpriseBean);
        securityIdentity.getMethodElements().add(object);
        this.copyIsolationLevel(methodElement, controlDescriptor);
        return securityIdentity;
    }

    public void copyIsolationLevel(MethodElement methodElement, ControlDescriptor controlDescriptor) {
        EnterpriseBean enterpriseBean = methodElement.getEnterpriseBean();
        EnterpriseBeanExtension enterpriseBeanExtension = EjbExtensionsHelper.getEjbExtension((EnterpriseBean)enterpriseBean);
        IsolationLevelAttributes isolationLevelAttributes = this.getEjbextFactory().createIsolationLevelAttributes();
        enterpriseBeanExtension.getIsolationLevelAttributes().add((Object)isolationLevelAttributes);
        isolationLevelAttributes.getMethodElements().add((Object)methodElement);
        if (controlDescriptor.getIsolationLevel() == 2) {
            isolationLevelAttributes.setIsolationLevel(TxIsolationLevel.READ_COMMITTED_LITERAL);
        } else if (controlDescriptor.getIsolationLevel() == 1) {
            isolationLevelAttributes.setIsolationLevel(TxIsolationLevel.READ_UNCOMMITTED_LITERAL);
        } else if (controlDescriptor.getIsolationLevel() == 4) {
            isolationLevelAttributes.setIsolationLevel(TxIsolationLevel.REPEATABLE_READ_LITERAL);
        } else if (controlDescriptor.getIsolationLevel() == 8) {
            isolationLevelAttributes.setIsolationLevel(TxIsolationLevel.SERIALIZABLE_LITERAL);
        }
    }

    protected EnterpriseBean createEnterpriseBeanFor(DeploymentDescriptor deploymentDescriptor) {
        Object object;
        if (deploymentDescriptor == null) {
            return null;
        }
        Session session = null;
        EnterpriseBean10ReadAdapter enterpriseBean10ReadAdapter = null;
        if (deploymentDescriptor instanceof SessionDescriptor) {
            session = this.getEjbFactory().createSession();
            enterpriseBean10ReadAdapter = new Session10ReadAdapter((Notifier)session, deploymentDescriptor);
        } else if (deploymentDescriptor instanceof EntityDescriptor) {
            object = (EntityDescriptor)deploymentDescriptor;
            Field[] fieldArray = object.getContainerManagedFields();
            if (fieldArray != null && fieldArray.length != 0) {
                session = this.getEjbFactory().createContainerManagedEntity();
                enterpriseBean10ReadAdapter = new ContainerManagedEntity10ReadAdapter((Notifier)session, deploymentDescriptor);
            } else {
                session = this.getEjbFactory().createEntity();
                enterpriseBean10ReadAdapter = new Entity10ReadAdapter((Notifier)session, deploymentDescriptor);
            }
        }
        object = EJBJar10ImportStrategyImpl.getDefaultBeanNameFor(deploymentDescriptor);
        session.setName((String)object);
        session.eAdapters().add((Object)enterpriseBean10ReadAdapter);
        return session;
    }

    public ImportStrategy createImportStrategy(Archive archive, Archive archive2) {
        return EJBJar10ImportStrategyImpl.getDiscriminator().createImportStrategy(archive, archive2);
    }

    protected EjbbndFactory getBindingsFactory() {
        return (EjbbndFactory)EjbbndFactoryImpl.getPackage().getEFactoryInstance();
    }

    public DDNames getDDNames() {
        return this.ddNames;
    }

    public static String getDefaultBeanNameFor(DeploymentDescriptor deploymentDescriptor) {
        if (deploymentDescriptor.getBeanHomeName() != null) {
            return deploymentDescriptor.getBeanHomeName().toString().replace('/', '_');
        }
        String string = deploymentDescriptor.getRemoteInterfaceClassName();
        int n = string.lastIndexOf(46);
        n = n == -1 ? 0 : n + 1;
        String string2 = string.substring(n);
        return string2;
    }

    /*
     * Loose catch block
     */
    protected static DeploymentDescriptor getDeploymentDescriptorFor(String string, Archive archive) throws StreamCorruptedException, NotADeploymentDescriptorException {
        DeploymentDescriptor deploymentDescriptor;
        block20: {
            deploymentDescriptor = null;
            ObjectInputStreamCustomResolver objectInputStreamCustomResolver = null;
            InputStream inputStream = null;
            try {
                inputStream = archive.getInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DeploymentDescriptorLoadException(ResourceHandler.getString("manifest_dd_find_EXC_", new Object[]{string}), fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new DeploymentDescriptorLoadException(ResourceHandler.getString("io_ex_reading_dd_EXC_", new Object[]{string}), iOException);
            }
            objectInputStreamCustomResolver = new ObjectInputStreamCustomResolver(inputStream, archive.getArchiveClassLoader());
            Object object = objectInputStreamCustomResolver.readObject();
            if (!(object instanceof DeploymentDescriptor)) {
                throw new NotADeploymentDescriptorException(ResourceHandler.getString("ser_not_dd_EXC_", new Object[]{string}));
            }
            deploymentDescriptor = (DeploymentDescriptor)object;
            Object var10_10 = null;
            try {
                if (objectInputStreamCustomResolver != null) {
                    objectInputStreamCustomResolver.close();
                }
                break block20;
            }
            catch (IOException iOException) {}
            break block20;
            {
                catch (StreamCorruptedException streamCorruptedException) {
                    throw streamCorruptedException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    EJBJar10ImportStrategyImpl.handleMissingClass(classNotFoundException, string);
                    Object var10_11 = null;
                    try {
                        if (objectInputStreamCustomResolver != null) {
                            objectInputStreamCustomResolver.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException) {}
                    break block20;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    EJBJar10ImportStrategyImpl.handleMissingClass(noClassDefFoundError, string);
                    Object var10_12 = null;
                    try {
                        if (objectInputStreamCustomResolver != null) {
                            objectInputStreamCustomResolver.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException) {}
                    break block20;
                }
                catch (Exception exception) {
                    throw new DeploymentDescriptorLoadException(ResourceHandler.getString("reading_dd_EXC_", new Object[]{string}), exception);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (objectInputStreamCustomResolver != null) {
                        objectInputStreamCustomResolver.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return deploymentDescriptor;
    }

    public List getDeploymentDescriptorNames() {
        return this.ddNames.getNames();
    }

    public static DDNames getDeploymentDescriptorNames(Archive archive) {
        return EJBJar10ImportStrategyImpl.getDeploymentDescriptorNames(archive, false);
    }

    public static DDNames getDeploymentDescriptorNames(Archive archive, boolean bl) {
        boolean bl2 = false;
        List list = EJBJar10ImportStrategyImpl.getEJBEntries(archive.getManifest());
        if (bl) {
            Collections.sort(list, Ejb10ManifestComparatorImpl.getSingleton());
        }
        List list2 = new ArrayList();
        if (!list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                Map.Entry entry = (Map.Entry)list.get(n);
                list2.add(entry.getKey());
                ++n;
            }
        }
        if (list2.size() == 0 && !archive.getLoadStrategy().isDirectory()) {
            list2 = EJBJar10ImportStrategyImpl.getInferredDeploymentDescriptorNames(archive);
            bl2 = true;
        }
        return new DDNames(list2, bl2);
    }

    public static DDNames getDeploymentDescriptorNamesSorted(Archive archive) {
        return EJBJar10ImportStrategyImpl.getDeploymentDescriptorNames(archive, true);
    }

    public Map getDeploymentDescriptors() {
        if (this.deploymentDescriptors == null) {
            this.deploymentDescriptors = new HashMap();
        }
        return this.deploymentDescriptors;
    }

    public static Map getDeploymentDescriptors(Archive archive, DDNames dDNames) {
        CharSequence charSequence;
        ArrayList arrayList = new ArrayList(dDNames.getNames());
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        HashMap<CharSequence, Object> hashMap = new HashMap<CharSequence, Object>((int)((float)n / 0.75f));
        HashMap<String, DeploymentDescriptor> hashMap2 = new HashMap<String, DeploymentDescriptor>((int)((float)n / 0.75f));
        int n2 = 0;
        while (n2 < n) {
            charSequence = (String)arrayList.get(n2);
            try {
                hashMap2.put((String)charSequence, EJBJar10ImportStrategyImpl.getDeploymentDescriptorFor((String)charSequence, archive));
            }
            catch (StreamCorruptedException streamCorruptedException) {
                EJBJar10ImportStrategyImpl.not_A_DD(dDNames, (String)charSequence, streamCorruptedException);
                hashMap.put(charSequence, streamCorruptedException);
            }
            catch (NotADeploymentDescriptorException notADeploymentDescriptorException) {
                EJBJar10ImportStrategyImpl.not_A_DD(dDNames, (String)charSequence, notADeploymentDescriptorException);
                hashMap.put(charSequence, notADeploymentDescriptorException);
            }
            catch (DeploymentDescriptorLoadException deploymentDescriptorLoadException) {
                EJBJar10ImportStrategyImpl.not_A_DD(dDNames, (String)charSequence, deploymentDescriptorLoadException);
                hashMap.put(charSequence, (Object)deploymentDescriptorLoadException);
            }
            ++n2;
        }
        if (hashMap2.isEmpty()) {
            throw new NoEJB10DescriptorsException();
        }
        if (!hashMap.isEmpty() && dDNames.isInferred()) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(ResourceHandler.getString("inferred_dds_EXC_", new Object[]{archive.getName()}));
            ((StringBuffer)charSequence).append(ResourceHandler.getString("_The_following_files_could_EXC_"));
            ((StringBuffer)charSequence).append('\n');
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ((StringBuffer)charSequence).append(ResourceHandler.getString("filename_exception_EXC_", new Object[]{entry.getKey(), ((Exception)entry.getValue()).getMessage()}));
                ((StringBuffer)charSequence).append('\n');
            }
            Logger.getLogger().logTrace(((StringBuffer)charSequence).toString());
        }
        return hashMap2;
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public static List getEJBEntries(ArchiveManifest archiveManifest) {
        if (archiveManifest == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = archiveManifest.getEntries().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Attributes attributes = (Attributes)entry.getValue();
            String string = ArchiveUtil.getValueIgnoreKeyCase("Enterprise-bean", attributes);
            if (!"true".equalsIgnoreCase(string)) continue;
            arrayList.add(entry);
        }
        return arrayList;
    }

    public EjbextFactory getEjbextFactory() {
        return ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
    }

    protected EjbFactory getEjbFactory() {
        return ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
    }

    public EJBJar getEjbJar() {
        return this.getEJBJarFile().getDeploymentDescriptor();
    }

    public EJBJarFile getEJBJarFile() {
        return (EJBJarFile)this.getArchive();
    }

    public EnterpriseBean getEnterpriseBeanFor(DeploymentDescriptor deploymentDescriptor) {
        return this.getEjbJar().getEnterpriseBeanNamed(EJBJar10ImportStrategyImpl.getDefaultBeanNameFor(deploymentDescriptor));
    }

    protected EjbextFactory getExtensionsFactory() {
        return (EjbextFactory)EjbextFactoryImpl.getPackage().getEFactoryInstance();
    }

    public static List getInferredDeploymentDescriptorNames(Archive archive) {
        ArrayList<String> arrayList = new ArrayList<String>();
        EList eList = archive.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.getURI().toLowerCase().endsWith(".ser")) {
                arrayList.add(file.getURI());
            }
            ++n;
        }
        return arrayList;
    }

    public static DDNames getLoadedDDNamesFrom(EJBJarFile eJBJarFile) {
        EJBJar10ImportStrategy eJBJar10ImportStrategy = (EJBJar10ImportStrategy)eJBJarFile.getImportStrategy();
        return eJBJar10ImportStrategy.getDDNames();
    }

    public static Map getLoadedDeploymentDescriptorsFrom(EJBJarFile eJBJarFile) {
        EJBJar10ImportStrategy eJBJar10ImportStrategy = (EJBJar10ImportStrategy)eJBJarFile.getImportStrategy();
        return eJBJar10ImportStrategy.getDeploymentDescriptors();
    }

    protected static void handleMissingClass(Throwable throwable, String string) throws DeploymentDescriptorLoadException {
        throw new DeploymentDescriptorLoadException(ResourceHandler.getString("missing_class_EXC_", new Object[]{string, throwable.getMessage()}));
    }

    public void importMetaData() throws Exception {
        EJBJarFile eJBJarFile = (EJBJarFile)this.getArchive();
        XMLResource xMLResource = (XMLResource)eJBJarFile.makeDeploymentDescriptorResource();
        xMLResource.setPublicId("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN");
        xMLResource.setSystemId("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd");
        ((XMIResource)eJBJarFile.getDeploymentDescriptor().eResource()).setID((EObject)eJBJarFile.getDeploymentDescriptor(), "ejb-jar_ID");
        eJBJarFile.getDeploymentDescriptor().setDisplayName(ArchiveUtil.truncateIgnoreCase(eJBJarFile.getName(), ".jar"));
        this.addEnterpriseBeans();
        this.addAssemblyDescriptor();
        this.addBindings();
        this.addExtensions();
        eJBJarFile.reflectFinderDescriptorsIfNecessary();
    }

    public boolean isEJB10() {
        return true;
    }

    protected static void not_A_DD(DDNames dDNames, String string, DeploymentDescriptorLoadException deploymentDescriptorLoadException) {
        if (!dDNames.isInferred()) {
            throw deploymentDescriptorLoadException;
        }
        dDNames.getNames().remove(string);
    }

    protected static void not_A_DD(DDNames dDNames, String string, Exception exception) {
        if (!dDNames.isInferred()) {
            throw new DeploymentDescriptorLoadException(ResourceHandler.getString("manifest_dd_load_EXC_", new Object[]{string}), exception);
        }
        dDNames.getNames().remove(string);
    }

    public void setDDNames(DDNames dDNames) {
        this.ddNames = dDNames;
    }

    public void setDeploymentDescriptors(Map map) {
        this.deploymentDescriptors = map;
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        public Archive convert(Archive archive) throws OpenFailureException {
            try {
                return super.convert(archive);
            }
            catch (NoEJB10DescriptorsException noEJB10DescriptorsException) {
                return null;
            }
        }

        public boolean canImport(Archive archive) {
            return !EJBJar10ImportStrategyImpl.getDeploymentDescriptorNames(archive).getNames().isEmpty();
        }

        public ImportStrategy createImportStrategy(Archive archive, Archive archive2) {
            EJBJar10ImportStrategyImpl eJBJar10ImportStrategyImpl = new EJBJar10ImportStrategyImpl();
            DDNames dDNames = EJBJar10ImportStrategyImpl.getDeploymentDescriptorNamesSorted(archive2);
            eJBJar10ImportStrategyImpl.setDDNames(dDNames);
            eJBJar10ImportStrategyImpl.setDeploymentDescriptors(EJBJar10ImportStrategyImpl.getDeploymentDescriptors(archive2, dDNames));
            return eJBJar10ImportStrategyImpl;
        }

        public String getUnableToOpenMessage() {
            return ResourceHandler.getString("Archive_is_not_a_valid_EJB_EXC_");
        }

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createEJBJarFile();
        }

        public Archive openArchive(Archive archive) throws OpenFailureException {
            Archive archive2 = super.openArchive(archive);
            if (archive2 == archive) {
                return null;
            }
            return archive2;
        }
    }
}

