/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.LoadStrategy;
import java.util.HashMap;
import java.util.Map;

public class ArchiveOptions
implements Cloneable {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private LoadStrategy loadStrategy;
    private boolean useJavaReflection = true;
    private boolean isReadOnly;
    private boolean saveLibrariesAsFiles = true;
    private boolean saveOnlyDirtyMofResources = true;
    private boolean discriminateNestedArchives = false;
    private Map readOnlyFlags;

    public Object clone() {
        return this.cloneWith(null);
    }

    public ArchiveOptions cloneWith(LoadStrategy loadStrategy) {
        try {
            ArchiveOptions archiveOptions = (ArchiveOptions)super.clone();
            archiveOptions.setLoadStrategy(loadStrategy);
            archiveOptions.readOnlyFlags = null;
            return archiveOptions;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ArchiveOptions cloneWith(LoadStrategy loadStrategy, String string) {
        ArchiveOptions archiveOptions = this.cloneWith(loadStrategy);
        archiveOptions.setIsReadOnly(this.isReadOnly(string));
        return archiveOptions;
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean saveOnlyDirtyMofResources() {
        return this.saveOnlyDirtyMofResources;
    }

    public void setIsReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public void setIsReadOnly(boolean bl, String string) {
        if (this.readOnlyFlags == null) {
            this.readOnlyFlags = new HashMap();
        }
        this.readOnlyFlags.put(string, new Boolean(bl));
    }

    public boolean isReadOnly(String string) {
        Boolean bl;
        if (this.readOnlyFlags != null && (bl = (Boolean)this.readOnlyFlags.get(string)) != null) {
            return bl;
        }
        return this.isReadOnly;
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
    }

    public void setSaveOnlyDirtyMofResources(boolean bl) {
        this.saveOnlyDirtyMofResources = bl;
    }

    public void setUseJavaReflection(boolean bl) {
        this.useJavaReflection = bl;
    }

    public boolean useJavaReflection() {
        return this.useJavaReflection;
    }

    public boolean isSaveLibrariesAsFiles() {
        return this.saveLibrariesAsFiles;
    }

    public void setSaveLibrariesAsFiles(boolean bl) {
        this.saveLibrariesAsFiles = bl;
    }

    public boolean shouldDiscriminateNestedArchives() {
        return this.discriminateNestedArchives;
    }

    public void setDiscriminateNestedArchives(boolean bl) {
        this.discriminateNestedArchives = bl;
    }
}

