/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.ArchiveTypeDiscriminator;
import com.ibm.etools.archive.ImportStrategy;
import com.ibm.etools.archive.exception.OpenFailureException;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.ModuleFile;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class ArchiveTypeDiscriminatorImpl
implements ArchiveTypeDiscriminator {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected List children;

    public void addChild(ArchiveTypeDiscriminator archiveTypeDiscriminator) {
        if (this.hasChild(archiveTypeDiscriminator)) {
            return;
        }
        this.getChildren().add(archiveTypeDiscriminator);
    }

    public void addChildAfter(ArchiveTypeDiscriminator archiveTypeDiscriminator, ArchiveTypeDiscriminator archiveTypeDiscriminator2) throws NoSuchElementException {
        if (this.hasChild(archiveTypeDiscriminator)) {
            return;
        }
        int n = this.getChildren().indexOf(archiveTypeDiscriminator2);
        if (n < 0) {
            throw new NoSuchElementException(archiveTypeDiscriminator2.toString());
        }
        this.getChildren().add(++n, archiveTypeDiscriminator);
    }

    public void addChildBefore(ArchiveTypeDiscriminator archiveTypeDiscriminator, ArchiveTypeDiscriminator archiveTypeDiscriminator2) throws NoSuchElementException {
        if (this.hasChild(archiveTypeDiscriminator)) {
            return;
        }
        int n = this.getChildren().indexOf(archiveTypeDiscriminator2);
        if (n < 0) {
            throw new NoSuchElementException(archiveTypeDiscriminator2.toString());
        }
        this.getChildren().add(n, archiveTypeDiscriminator);
    }

    public abstract boolean canImport(Archive var1);

    public Archive convert(Archive archive) throws OpenFailureException {
        Archive archive2 = this.createConvertedArchive();
        archive2.eSetDeliver(false);
        archive2.eSetDeliver(false);
        archive2.setURI(archive.getURI());
        archive2.setOriginalURI(archive.getURI());
        archive2.setSize(archive.getSize());
        archive2.setLastModified(archive.getLastModified());
        archive2.setLoadStrategy(archive.getLoadStrategy());
        archive2.setOptions(archive.getOptions());
        archive2.setExtraClasspath(archive.getExtraClasspath());
        if (archive2.isModuleFile()) {
            ImportStrategy importStrategy = this.createImportStrategy(archive, archive2);
            ((ModuleFile)archive2).setImportStrategy(importStrategy);
        }
        archive2.eSetDeliver(true);
        archive2.eSetDeliver(true);
        return archive2;
    }

    public abstract Archive createConvertedArchive();

    public abstract ImportStrategy createImportStrategy(Archive var1, Archive var2);

    public List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    protected Archive getImportableArchiveFromChild(Archive archive) throws OpenFailureException {
        if (!this.hasChildren()) {
            return null;
        }
        List list = this.getChildren();
        Archive archive2 = null;
        int n = 0;
        while (n < list.size()) {
            ArchiveTypeDiscriminator archiveTypeDiscriminator = (ArchiveTypeDiscriminator)list.get(n);
            archive2 = archiveTypeDiscriminator.openArchive(archive);
            if (archive2 != null) {
                return archive2;
            }
            ++n;
        }
        return null;
    }

    protected String getXmlDDMessage(String string, String string2) {
        return ResourceHandler.getString("invalid_archive_EXC_", new Object[]{string, string2});
    }

    public boolean hasChild(ArchiveTypeDiscriminator archiveTypeDiscriminator) {
        return this.hasChildren() && this.getChildren().contains(archiveTypeDiscriminator);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public Archive openArchive(Archive archive) throws OpenFailureException {
        if (!this.canImport(archive)) {
            return null;
        }
        Archive archive2 = this.convert(archive);
        Archive archive3 = this.getImportableArchiveFromChild(archive2);
        if (archive3 != null) {
            return archive3;
        }
        return archive2;
    }

    public void removeChild(ArchiveTypeDiscriminator archiveTypeDiscriminator) {
        this.getChildren().remove(archiveTypeDiscriminator);
    }

    public void setChildren(List list) {
        this.children = list;
    }
}

