/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.commonarchive.Archive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class ArchiveURIConverterImpl
extends URIConverterImpl {
    protected static final String fileProtocol = "file";
    protected static final String platformProtocol = "platform";
    private String inFilepath;
    private String outFilepath;
    protected Archive archive;
    protected String resourcesPath;

    public ArchiveURIConverterImpl(Archive archive, String string) {
        LoadStrategy loadStrategy;
        this.setArchive(archive);
        this.resourcesPath = string;
        this.setInputFilepath(string);
        String string2 = string;
        if (string2 == null && (loadStrategy = archive.getLoadStrategy()) != null && loadStrategy.isDirectory()) {
            try {
                string2 = loadStrategy.getAbsolutePath();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.setOutputFilepath(string2);
    }

    public Archive getArchive() {
        return this.archive;
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        InputStream inputStream = null;
        if (this.resourcesPath != null) {
            inputStream = this.makeInputStream(uRI);
        }
        if (inputStream != null) {
            return inputStream;
        }
        return this.getArchive().getInputStream(uRI.toString());
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setResourcesPath(String string) {
        this.resourcesPath = string;
        this.setInputFilepath(string);
        this.setOutputFilepath(string);
    }

    public URI normalize(URI uRI) {
        return this.getInternalURIMap().getURI(uRI);
    }

    public String getInputFilepath() {
        return this.inFilepath;
    }

    public void setInputFilepath(String string) {
        this.inFilepath = string;
    }

    public String getOutputFilepath() {
        return this.outFilepath;
    }

    public void setOutputFilepath(String string) {
        this.outFilepath = string;
    }

    public InputStream makeInputStream(URI uRI) throws IOException {
        URI uRI2 = uRI;
        if ((fileProtocol.equals(uRI2.scheme()) || uRI2.scheme() == null) && this.inFilepath != null) {
            return this.searchFilePath(uRI2.toString());
        }
        URL uRL = this.createURL(uRI2.toString());
        URLConnection uRLConnection = uRL.openConnection();
        return uRLConnection.getInputStream();
    }

    protected InputStream searchFilePath(String string) throws IOException {
        File file = new File(string);
        if (file.isAbsolute()) {
            return new FileInputStream(file);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.inFilepath, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream inputStream = null;
            if (zipFile != null) {
                inputStream = this.searchZipFile(zipFile, string);
                if (inputStream == null) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                inputStream = this.searchDirectory(string2, string);
            }
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    protected InputStream searchDirectory(String string, String string2) throws IOException {
        File file;
        if (string.equals(".")) {
            string = System.getProperty("user.dir");
        }
        if (!(file = new File(string + System.getProperty("file.separator") + string2.replace('/', File.separatorChar))).exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    protected InputStream searchZipFile(ZipFile zipFile, String string) throws IOException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        return zipFile.getInputStream(zipEntry);
    }

    public URL createURL(String string) throws MalformedURLException {
        MalformedURLException malformedURLException = null;
        if (string == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            malformedURLException = (MalformedURLException)exception;
        }
        if (uRL != null) {
            return uRL;
        }
        int n = string.indexOf(":");
        if (n == -1 || n == 1) {
            string = "file:" + string;
        } else if (n > 0) {
            string = "file:" + string.substring(n + 1);
        }
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL != null) {
            return uRL;
        }
        throw malformedURLException;
    }

    public OutputStream createOutputStream(URI uRI) throws IOException {
        URL uRL;
        URI uRI2 = uRI;
        if (platformProtocol.equals(uRI2.scheme()) && (uRL = this.resolvePlatform(new URL(uRI2.toString()))) != null) {
            uRI2 = URI.createFileURI((String)uRL.getFile());
        }
        if (fileProtocol.equals(uRI2.scheme()) || uRI2.scheme() == null) {
            return this.openFileOutputStream(uRI2);
        }
        uRL = this.createURL(uRI2.toString());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        return uRLConnection.getOutputStream();
    }

    protected URL resolvePlatform(URL uRL) throws IOException {
        return null;
    }

    protected OutputStream openFileOutputStream(URI uRI) throws IOException {
        String string;
        File file = new File(uRI.toFileString());
        if (!file.isAbsolute() && this.outFilepath != null) {
            file = new File(this.outFilepath + File.separator + uRI.toFileString());
        }
        if ((string = file.getParent()) != null) {
            new File(string).mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return fileOutputStream;
    }
}

