/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.DirectoryArchiveLoadStrategy;
import com.ibm.etools.archive.impl.LoadStrategyImpl;
import com.ibm.etools.archive.util.ArchiveUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class DirectoryLoadStrategyImpl
extends LoadStrategyImpl
implements DirectoryArchiveLoadStrategy {
    static boolean IS_AIX = "AIX".equals(System.getProperty("os.name"));
    protected String directoryUri;
    protected String directoryUriAsZipString;
    protected static char SEPARATOR_CHAR = File.separatorChar;

    public DirectoryLoadStrategyImpl(String string) {
        this.setDirectoryUri(string);
        String string2 = null;
        try {
            string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        this.setDirectoryUriAsZipString(string2.replace(SEPARATOR_CHAR, '/'));
    }

    protected abstract void addDirectory(File var1, List var2);

    protected void addFile(File file, List list) {
        String string = this.getURIFrom(file);
        if (this.collectedLooseArchiveFiles.containsKey(string)) {
            return;
        }
        com.ibm.etools.commonarchive.File file2 = this.createFile(string);
        file2.setSize(file.length());
        file2.setLastModified(file.lastModified());
        list.add(file2);
    }

    protected void addFiles(File file, List list) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2;
            String string = ArchiveUtil.concatUri(file.getPath(), stringArray[n], SEPARATOR_CHAR);
            if (!(stringArray[n] == null || IS_AIX && ".backup".equals(stringArray[n]) || !(file2 = new File(string)).exists())) {
                if (file2.isDirectory() && !this.isArchive(this.getURIFrom(file2))) {
                    this.addDirectory(file2, list);
                } else {
                    this.addFile(file2, list);
                }
            }
            ++n;
        }
    }

    protected boolean primContains(String string) {
        return new File(this.getFileNameFrom(string)).exists();
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return new File(this.getDirectoryUri()).getAbsolutePath();
    }

    protected abstract File getDirectoryForList();

    public String getDirectoryUri() {
        return this.directoryUri;
    }

    public String getDirectoryUriAsZipString() {
        return this.directoryUriAsZipString;
    }

    protected String getFileNameFrom(String string) {
        String string2 = string;
        if (SEPARATOR_CHAR != '/') {
            string2 = string2.replace('/', SEPARATOR_CHAR);
        }
        return this.getDirectoryUri() + SEPARATOR_CHAR + string2;
    }

    public List getFiles() {
        ArrayList arrayList = new ArrayList();
        File file = this.getDirectoryForList();
        this.addFiles(file, arrayList);
        return arrayList;
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        return new FileInputStream(this.getFileNameFrom(string));
    }

    protected String getURIFrom(File file) {
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        String string2 = this.getDirectoryUriAsZipString();
        while (string2.endsWith("/")) {
            string2 = ArchiveUtil.truncateIgnoreCase(string2, "/");
        }
        if (string.startsWith(string2)) {
            string = string.substring(string2.length() + 1);
        } else {
            string = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            if (string.startsWith(string2)) {
                string = string.substring(string2.length() + 1);
            }
        }
        return string;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isUsing(File file) {
        File file2 = new File(this.getDirectoryUri());
        return file2.equals(file);
    }

    public void setDirectoryUri(String string) {
        this.directoryUri = string;
    }

    public void setDirectoryUriAsZipString(String string) {
        this.directoryUriAsZipString = string;
    }
}

