/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.SaveStrategy;
import com.ibm.etools.archive.exception.SaveFailureException;
import com.ibm.etools.archive.impl.ArchiveURIConverterImpl;
import com.ibm.etools.archive.impl.SaveStrategyImpl;
import com.ibm.etools.archive.impl.ZipStreamSaveStrategyImpl;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.Archive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;

public class DirectorySaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected String directoryName;
    protected URIConverter uriConverter;
    protected int expansionFlags;

    public DirectorySaveStrategyImpl() {
    }

    public DirectorySaveStrategyImpl(String string, int n) {
        this.setDirectoryName(string);
        this.setExpansionFlags(n);
        this.initialize();
    }

    protected SaveStrategy createNestedDirectoryStrategy(Archive archive) {
        String string = ArchiveUtil.getOSUri(this.getDirectoryName(), archive.getURI());
        return new DirectorySaveStrategyImpl(string, this.getExpansionFlags());
    }

    protected SaveStrategy createNestedSaveStrategy(Archive archive) throws IOException {
        if (this.shouldExpand(archive)) {
            return this.createNestedDirectoryStrategy(archive);
        }
        return this.createNestedZipStrategy(archive);
    }

    protected SaveStrategy createNestedZipStrategy(Archive archive) throws IOException {
        OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createURI((String)archive.getURI()));
        return new ZipStreamSaveStrategyImpl(outputStream);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getExpansionFlags() {
        return this.expansionFlags;
    }

    protected OutputStream getOutputStreamForResource(Resource resource) throws IOException {
        return this.getUriConverter().createOutputStream(resource.getURI());
    }

    public URIConverter getUriConverter() {
        return this.uriConverter;
    }

    public void initialize() {
        ArchiveURIConverterImpl archiveURIConverterImpl = new ArchiveURIConverterImpl(this.getArchive(), this.getDirectoryName());
        archiveURIConverterImpl.setOutputFilepath(this.getDirectoryName());
        this.setUriConverter((URIConverter)archiveURIConverterImpl);
    }

    public boolean isDirectory() {
        return true;
    }

    protected void mkdirs(String string) {
        File file = new File(this.getDirectoryName() + File.separatorChar + string);
        file.mkdirs();
    }

    public void save(ArchiveManifest archiveManifest) throws SaveFailureException {
        try {
            OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createURI((String)"META-INF/MANIFEST.MF"));
            archiveManifest.write(outputStream);
            outputStream.close();
            if (this.getArchive().getOptions().isReadOnly()) {
                this.setTimestampAfterSaving("META-INF/MANIFEST.MF");
            }
        }
        catch (IOException iOException) {
            throw new SaveFailureException("META-INF/MANIFEST.MF", iOException);
        }
    }

    public void save(com.ibm.etools.commonarchive.File file, InputStream inputStream) throws SaveFailureException {
        String string = file.getURI();
        if (file.isDirectoryEntry()) {
            this.mkdirs(string);
        } else {
            try {
                OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createURI((String)string));
                ArchiveUtil.copy(inputStream, outputStream);
                this.setTimestampAfterSaving(file);
            }
            catch (IOException iOException) {
                throw new SaveFailureException(file.getURI(), iOException);
            }
        }
    }

    protected void saveMofResource(Resource resource, OutputStream outputStream) throws IOException {
        super.saveMofResource(resource, outputStream);
        outputStream.close();
    }

    public void setDirectoryName(String string) {
        this.directoryName = string;
    }

    public void setExpansionFlags(int n) {
        this.expansionFlags = n;
    }

    protected void setTimestampAfterSaving(com.ibm.etools.commonarchive.File file) {
        long l = file.getLastModified();
        if (l == 0L) {
            return;
        }
        String string = ArchiveUtil.getOSUri(this.getDirectoryName(), file.getURI());
        File file2 = new File(string);
        file2.setLastModified(l);
    }

    protected void setTimestampAfterSaving(String string) {
        com.ibm.etools.commonarchive.File file = null;
        try {
            file = this.getArchive().getFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        this.setTimestampAfterSaving(file);
    }

    public void setUriConverter(URIConverter uRIConverter) {
        this.uriConverter = uRIConverter;
    }

    protected boolean shouldExpand(Archive archive) {
        int n = 0;
        n = archive.isWARFile() ? 2 : (archive.isEARFile() ? 4 : (archive.isRARFile() ? 64 : (archive.isEJBJarFile() ? 8 : (archive.isApplicationClientFile() ? 16 : 32))));
        return (this.getExpansionFlags() & n) != 0;
    }

    protected boolean shouldIterateOver(Archive archive) {
        return super.shouldIterateOver(archive) || this.shouldExpand(archive);
    }
}

