/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.applicationclientext.ApplicationClientExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.etools.application.Application;
import com.ibm.etools.archive.ArchiveConstants;
import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.webapplication.WebApp;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

class InternalModuleHelper
implements ArchiveConstants {
    InternalModuleHelper() {
    }

    public static void fixupBndOrExtRootsIfNecessary(Resource resource) {
        if (resource instanceof XMLResource || resource.getContents().isEmpty()) {
            return;
        }
        String string = resource.getURI().lastSegment();
        if ("ibm-application-bnd.xmi".equals(string)) {
            InternalModuleHelper.applicationBindingsLoaded(resource);
        } else if ("ibm-application-ext.xmi".equals(string)) {
            InternalModuleHelper.applicationExtensionsLoaded(resource);
        } else if ("ibm-application-client-bnd.xmi".equals(string)) {
            InternalModuleHelper.appClientBindingsLoaded(resource);
        } else if ("ibm-application-client-ext.xmi".equals(string)) {
            InternalModuleHelper.appClientExtensionsLoaded(resource);
        } else if ("ibm-ejb-jar-bnd.xmi".equals(string)) {
            InternalModuleHelper.ejbJarBindingsLoaded(resource);
        } else if ("ibm-ejb-jar-ext.xmi".equals(string)) {
            InternalModuleHelper.ejbJarExtensionsLoaded(resource);
        } else if ("ibm-web-bnd.xmi".equals(string)) {
            InternalModuleHelper.webAppBindingsLoaded(resource);
        } else if ("ibm-web-ext.xmi".equals(string)) {
            InternalModuleHelper.webAppExtensionsLoaded(resource);
        }
    }

    private static URI getDDResourceURIIfProxy(EObject eObject) {
        if (eObject.eIsProxy()) {
            return ((InternalEObject)eObject).eProxyURI().trimFragment();
        }
        return null;
    }

    private static Resource getDDResourceIfProxy(Resource resource, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        URI uRI = InternalModuleHelper.getDDResourceURIIfProxy(eObject);
        if (uRI == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        return resourceSet.getResource(uRI, true);
    }

    private static void webAppExtensionsLoaded(Resource resource) {
        WebAppExtension webAppExtension = (WebAppExtension)resource.getContents().get(0);
        WebApp webApp = webAppExtension.getWebApp();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)webApp);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            WebApp webApp2 = (WebApp)resource2.getContents().get(0);
            webAppExtension.setWebApp(webApp2);
        }
    }

    private static void webAppBindingsLoaded(Resource resource) {
        WebAppBinding webAppBinding = (WebAppBinding)resource.getContents().get(0);
        WebApp webApp = webAppBinding.getWebapp();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)webApp);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            WebApp webApp2 = (WebApp)resource2.getContents().get(0);
            webAppBinding.setWebapp(webApp2);
        }
    }

    private static void ejbJarExtensionsLoaded(Resource resource) {
        EJBJarExtension eJBJarExtension = (EJBJarExtension)resource.getContents().get(0);
        EJBJar eJBJar = eJBJarExtension.getEjbJar();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)eJBJar);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            EJBJar eJBJar2 = (EJBJar)resource2.getContents().get(0);
            eJBJarExtension.setEjbJar(eJBJar2);
        }
    }

    private static void ejbJarBindingsLoaded(Resource resource) {
        EJBJarBinding eJBJarBinding = (EJBJarBinding)resource.getContents().get(0);
        EJBJar eJBJar = eJBJarBinding.getEjbJar();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)eJBJar);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            EJBJar eJBJar2 = (EJBJar)resource2.getContents().get(0);
            eJBJarBinding.setEjbJar(eJBJar2);
        }
    }

    private static void appClientExtensionsLoaded(Resource resource) {
        ApplicationClientExtension applicationClientExtension = (ApplicationClientExtension)resource.getContents().get(0);
        ApplicationClient applicationClient = applicationClientExtension.getExtendedApplicationClient();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)applicationClient);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            ApplicationClient applicationClient2 = (ApplicationClient)resource2.getContents().get(0);
            applicationClientExtension.setExtendedApplicationClient(applicationClient2);
        }
    }

    private static void appClientBindingsLoaded(Resource resource) {
        ApplicationClientBinding applicationClientBinding = (ApplicationClientBinding)resource.getContents().get(0);
        ApplicationClient applicationClient = applicationClientBinding.getApplicationClient();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)applicationClient);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            ApplicationClient applicationClient2 = (ApplicationClient)resource2.getContents().get(0);
            applicationClientBinding.setApplicationClient(applicationClient2);
        }
    }

    private static void applicationExtensionsLoaded(Resource resource) {
        ApplicationExtension applicationExtension = (ApplicationExtension)resource.getContents().get(0);
        Application application = applicationExtension.getApplication();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)application);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            Application application2 = (Application)resource2.getContents().get(0);
            applicationExtension.setApplication(application2);
        }
    }

    private static void applicationBindingsLoaded(Resource resource) {
        ApplicationBinding applicationBinding = (ApplicationBinding)resource.getContents().get(0);
        Application application = applicationBinding.getApplication();
        Resource resource2 = InternalModuleHelper.getDDResourceIfProxy(resource, (EObject)application);
        if (resource2 != null && !resource2.getContents().isEmpty()) {
            Application application2 = (Application)resource2.getContents().get(0);
            applicationBinding.setApplication(application2);
        }
    }
}

