/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.FileIterator;
import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.exception.OpenFailureException;
import com.ibm.etools.archive.exception.ResourceLoadException;
import com.ibm.etools.archive.impl.ArchiveURIConverterImpl;
import com.ibm.etools.archive.impl.FileIteratorImpl;
import com.ibm.etools.archive.impl.InternalModuleHelper;
import com.ibm.etools.archive.impl.ResourceProxyValidator;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.looseconfig.LooseArchive;
import com.ibm.etools.commonarchive.looseconfig.LooseConfigRegister;
import com.ibm.etools.emf.ecore.utilities.ExtendedEcoreUtil;
import com.ibm.etools.j2ee.common.impl.J2EEResourceFactoryRegistry;
import com.ibm.etools.java.adapters.jdk.JavaJDKAdapterFactory;
import com.ibm.etools.logger.proxy.Logger;
import com.ibm.etools.wft.util.WorkbenchUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public abstract class LoadStrategyImpl
extends AdapterImpl
implements LoadStrategy {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected boolean isOpen = true;
    protected Container container;
    protected ResourceSet resourceSet;
    protected LooseArchive looseArchive;
    protected Map collectedLooseArchiveFiles;

    public void addOrReplaceMofResource(Resource resource) {
        Resource resource2 = this.getResourceSet().getResource(resource.getURI(), false);
        if (resource2 != null) {
            this.getResourceSet().getResources().remove((Object)resource2);
        }
        this.getResourceSet().getResources().add((Object)resource);
    }

    protected void updateModificationTracking(Resource resource) {
        boolean bl;
        boolean bl2 = resource.isTrackingModification();
        boolean bl3 = bl = !((Archive)this.container).getOptions().isReadOnly() && !ArchiveUtil.isJavaResource(resource) && !ArchiveUtil.isRegisteredURIMapping(resource);
        if (bl && !bl2) {
            resource.setTrackingModification(true);
        }
    }

    public void close() {
        this.setIsOpen(false);
    }

    protected abstract boolean primContains(String var1);

    public boolean contains(String string) {
        if (this.containsUsingLooseArchive(string)) {
            return true;
        }
        return this.primContains(string);
    }

    protected boolean containsUsingLooseArchive(String string) {
        if (this.getLooseArchive() == null) {
            return false;
        }
        LooseArchive looseArchive = this.getLooseArchive();
        if (looseArchive.getResourcesPath() == null) {
            return false;
        }
        File file = new File(looseArchive.getResourcesPath(), string);
        if (file.exists()) {
            return true;
        }
        return LooseConfigRegister.singleton().findFirstLooseChild(string, looseArchive) != null;
    }

    protected com.ibm.etools.commonarchive.File createFile(String string) {
        com.ibm.etools.commonarchive.File file = null;
        if (this.isArchive(string)) {
            file = this.openNestedArchive(string);
        }
        if (file == null) {
            file = this.getArchiveFactory().createFile();
            file.setURI(string);
            file.setOriginalURI(string);
        }
        file.setLoadingContainer(this.getContainer());
        return file;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String getAbsolutePath() throws FileNotFoundException {
        throw new FileNotFoundException(ResourceHandler.getString("Absolute_path_unknown_EXC_"));
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLooseArchive() == null ? this.getAbsolutePath() : this.getLooseArchive().getResourcesPath();
    }

    protected String primGetResourcesPath() {
        return this.getLooseArchive() == null ? null : this.getLooseArchive().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        return this.getLooseArchive() == null ? this.getAbsolutePath() : this.getLooseArchive().getBinariesPath();
    }

    public CommonarchiveFactory getArchiveFactory() {
        return ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory();
    }

    public Container getContainer() {
        return this.container;
    }

    public ResourceSet primGetResourceSet() {
        return this.resourceSet;
    }

    public boolean requiresIterationOnSave() {
        if (!this.getContainer().isArchive() || this.isDirectory()) {
            return true;
        }
        Archive archive = (Archive)this.getContainer();
        if (archive.isModuleFile()) {
            return !archive.getOptions().isReadOnly();
        }
        if (archive.getOptions().isSaveLibrariesAsFiles() && archive.getLoadingContainer() != null) {
            if (archive.isIndexed()) {
                EList eList = archive.getFiles();
                com.ibm.etools.commonarchive.File file = null;
                Container container = null;
                Container container2 = null;
                int n = 0;
                while (n < eList.size()) {
                    file = (com.ibm.etools.commonarchive.File)eList.get(n);
                    if (n == 0 && (container = file.getLoadingContainer()).getLoadStrategy().isDirectory()) {
                        return true;
                    }
                    container2 = file.getLoadingContainer();
                    if (container2 != container) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }
        return true;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.initializeResourceSet();
            this.resourceSet.eAdapters().add((Object)this);
        }
        return this.resourceSet;
    }

    public void notifyChanged(Notification notification) {
        block10: {
            block9: {
                if (notification.getNotifier() != this.resourceSet) break block9;
                switch (notification.getEventType()) {
                    case 3: {
                        this.resourceAdded((Resource)notification.getNewValue());
                        break;
                    }
                    case 5: {
                        List list = (List)notification.getNewValue();
                        int n = 0;
                        while (n < list.size()) {
                            this.resourceAdded((Resource)list.get(n));
                            ++n;
                        }
                        break block10;
                    }
                    case 4: {
                        this.resourceRemoved((Resource)notification.getOldValue());
                        break;
                    }
                    case 6: {
                        List list = (List)notification.getOldValue();
                        int n = 0;
                        while (n < list.size()) {
                            this.resourceRemoved((Resource)list.get(n));
                            ++n;
                        }
                        break block10;
                    }
                }
                break block10;
            }
            if (notification.getFeatureID(null) == 4) {
                Resource resource = (Resource)notification.getNotifier();
                this.resourceLoaded(resource);
                resource.eAdapters().remove((Object)this);
            }
        }
    }

    protected void resourceAdded(Resource resource) {
        this.updateModificationTracking(resource);
        if (!WorkbenchUtil.workbenchIsRunning()) {
            resource.eAdapters().add((Object)this);
        }
    }

    protected void resourceRemoved(Resource resource) {
        if (!WorkbenchUtil.workbenchIsRunning()) {
            resource.eAdapters().remove((Object)this);
        }
    }

    protected void resourceLoaded(Resource resource) {
        InternalModuleHelper.fixupBndOrExtRootsIfNecessary(resource);
        ResourceProxyValidator.checkForUnresolvableProxies(resource);
    }

    public FileIterator getFileIterator() throws IOException {
        return new FileIteratorImpl((List)this.getContainer().getFiles());
    }

    public abstract List getFiles();

    public List collectFiles() {
        this.collectFilesFromLooseArchives();
        List list = this.getFiles();
        list.addAll(this.collectedLooseArchiveFiles.values());
        this.collectedLooseArchiveFiles = null;
        return list;
    }

    protected void collectFilesFromLooseArchives() {
        if (!this.canHaveLooseChildren() || this.getLooseArchive() == null) {
            this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
            return;
        }
        this.collectedLooseArchiveFiles = new HashMap();
        List list = LooseConfigRegister.singleton().getLooseChildren(this.getLooseArchive());
        int n = 0;
        while (n < list.size()) {
            Archive archive;
            LooseArchive looseArchive = (LooseArchive)list.get(n);
            String string = looseArchive.getUri();
            if (!this.collectedLooseArchiveFiles.containsKey(string) && (archive = this.openNestedArchive(looseArchive)) != null) {
                this.collectedLooseArchiveFiles.put(string, archive);
            }
            ++n;
        }
    }

    public abstract InputStream getInputStream(String var1) throws IOException, FileNotFoundException;

    public InputStream getResourceInputStream(String string) throws IOException {
        return this.getResourceSet().getURIConverter().createInputStream(URI.createURI((String)string));
    }

    public Collection getLoadedMofResources() {
        EList eList = this.getResourceSet().getResources();
        if (eList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>(eList.size());
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.isLoaded()) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    public Resource getMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        try {
            return this.getResourceSet().getResource(URI.createURI((String)string), true);
        }
        catch (WrappedException wrappedException) {
            FileNotFoundException fileNotFoundException;
            String string2;
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrappedException) && (string2 = (fileNotFoundException = ExtendedEcoreUtil.getInnerFileNotFoundException((WrappedException)wrappedException)).getMessage()) != null && (string2 = string2.replace(File.separatorChar, '/')).indexOf(string.toString()) >= 0) {
                throw fileNotFoundException;
            }
            this.throwResourceLoadException(string, (Exception)((Object)wrappedException));
            return null;
        }
    }

    protected void initializeResourceSet() {
        Archive archive = (Archive)this.getContainer();
        ArchiveURIConverterImpl archiveURIConverterImpl = new ArchiveURIConverterImpl(archive, this.primGetResourcesPath());
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        resourceSetImpl.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        this.setResourceSet((ResourceSet)resourceSetImpl);
        resourceSetImpl.setURIConverter((URIConverter)archiveURIConverterImpl);
        if (archive.shouldUseJavaReflection()) {
            resourceSetImpl.getAdapterFactories().add((Object)new JavaJDKAdapterFactory());
            archive.initializeClassLoader();
        }
    }

    protected boolean isArchive(String string) {
        return ((Archive)this.getContainer()).isNestedArchive(string);
    }

    public boolean isClassLoaderNeeded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public Resource getExistingMofResource(String string) {
        return this.getResourceSet().getResource(URI.createURI((String)string), false);
    }

    public boolean isMofResourceLoaded(String string) {
        Resource resource = this.getExistingMofResource(string);
        return resource != null && resource.isLoaded();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUsing(File file) {
        return false;
    }

    public Resource makeMofResource(String string, EList eList) {
        Resource resource = this.getExistingMofResource(string);
        if (resource != null) {
            return resource;
        }
        return this.getResourceSet().createResource(URI.createURI((String)string));
    }

    protected Archive openNestedArchive(String string) {
        try {
            return ((Archive)this.getContainer()).openNestedArchive(string);
        }
        catch (OpenFailureException openFailureException) {
            Logger.getLogger().logError((Throwable)((Object)openFailureException));
            return null;
        }
    }

    protected Archive openNestedArchive(LooseArchive looseArchive) {
        try {
            return ((Archive)this.getContainer()).openNestedArchive(looseArchive);
        }
        catch (OpenFailureException openFailureException) {
            Logger.getLogger().logError((Throwable)((Object)openFailureException));
            return null;
        }
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    protected void setIsOpen(boolean bl) {
        this.isOpen = bl;
    }

    protected void throwResourceLoadException(String string, Exception exception) throws ResourceLoadException {
        throw new ResourceLoadException(ResourceHandler.getString("load_resource_EXC_", new Object[]{string, this.getContainer().getURI()}), exception);
    }

    public LooseArchive getLooseArchive() {
        return this.looseArchive;
    }

    public void setLooseArchive(LooseArchive looseArchive) {
        this.looseArchive = looseArchive;
        this.checkLoosePathsValid();
    }

    protected void checkLoosePathsValid() {
        File file;
        if (this.looseArchive == null) {
            return;
        }
        String string = this.looseArchive.getBinariesPath();
        if (string != null && !(file = new File(string)).exists()) {
            throw new ArchiveRuntimeException("Invalid binaries path: " + string);
        }
        string = this.looseArchive.getResourcesPath();
        if (string != null && !(file = new File(string)).exists()) {
            throw new ArchiveRuntimeException("Invalid resources path: " + string);
        }
    }

    protected boolean canHaveLooseChildren() {
        return this.container.isEARFile() || this.container.isWARFile();
    }
}

