/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.impl.FileIteratorImpl;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.commonarchive.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class NestedArchiveIterator
extends FileIteratorImpl {
    protected ZipInputStream zipInputStream;
    protected ZipEntry currentEntry;

    public NestedArchiveIterator(List list, ZipInputStream zipInputStream) {
        super(list);
        this.zipInputStream = zipInputStream;
    }

    public InputStream getInputStream(File file) throws IOException, FileNotFoundException {
        if (!file.getURI().equals(this.currentEntry.getName())) {
            throw new IOException(ResourceHandler.getString("Internal_Error__Iterator_o_EXC_"));
        }
        return this.zipInputStream;
    }

    public File next() {
        File file = super.next();
        try {
            do {
                this.currentEntry = this.zipInputStream.getNextEntry();
            } while (this.currentEntry.isDirectory());
        }
        catch (IOException iOException) {
            throw new ArchiveRuntimeException(ResourceHandler.getString("Error_iterating_the_archiv_EXC_"), iOException);
        }
        return file;
    }
}

