/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.FileIterator;
import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.archive.exception.NestedJarException;
import com.ibm.etools.archive.impl.LoadStrategyImpl;
import com.ibm.etools.archive.impl.NestedArchiveIterator;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.File;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class NestedArchiveLoadStrategyImpl
extends LoadStrategyImpl {
    protected Map urisToPositions;
    protected LoadStrategy parent;

    public NestedArchiveLoadStrategyImpl(LoadStrategy loadStrategy) {
        this.setParent(loadStrategy);
    }

    protected void buildIndex() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            ZipInputStream zipInputStream = this.getZipInputStream();
            ZipEntry zipEntry = null;
            long l = 0L;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                hashMap.put(zipEntry.getName(), new Long(++l));
            }
        }
        catch (IOException iOException) {
            this.throwNestedJarException(iOException);
        }
        this.setUrisToPositions(hashMap);
    }

    protected boolean primContains(String string) {
        if (this.usingIndex()) {
            return this.containsUsingIndex(string);
        }
        return this.containsSequentially(string);
    }

    protected boolean containsSequentially(String string) {
        try {
            return this.getZipInputStreamSkippedTo(string) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected boolean containsUsingIndex(String string) {
        return this.getUrisToPositions().containsKey(string);
    }

    public FileIterator getFileIterator() throws IOException {
        if (((Archive)this.getContainer()).getOptions().isReadOnly()) {
            return new NestedArchiveIterator((List)this.getContainer().getFiles(), this.getZipInputStream());
        }
        return super.getFileIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>(500);
        ZipInputStream zipInputStream = null;
        zipInputStream = this.getZipInputStream();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (!zipEntry.isDirectory()) {
                File file = this.createFile(zipEntry.getName());
                file.setSize(zipEntry.getSize());
                file.setLastModified(zipEntry.getTime());
                arrayList.add(file);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        Object var6_6 = null;
        if (zipInputStream == null) return arrayList;
        try {
            zipInputStream.close();
            return arrayList;
        }
        catch (IOException iOException) {}
        return arrayList;
        {
            catch (IOException iOException) {
                this.throwNestedJarException(iOException);
                Object var6_7 = null;
                if (zipInputStream == null) return arrayList;
                try {
                    zipInputStream.close();
                    return arrayList;
                }
                catch (IOException iOException2) {}
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        if (this.usingIndex()) {
            return this.getInputStreamUsingIndex(string);
        }
        return this.getInputStreamSequentially(string);
    }

    protected InputStream getInputStreamSequentially(String string) throws IOException, FileNotFoundException {
        return new BufferedInputStream(this.getZipInputStreamSkippedTo(string));
    }

    protected InputStream getInputStreamUsingIndex(String string) throws IOException, FileNotFoundException {
        Long l = (Long)this.getUrisToPositions().get(string);
        if (l == null) {
            throw new FileNotFoundException();
        }
        ZipInputStream zipInputStream = this.getZipInputStream();
        long l2 = l;
        long l3 = 0L;
        while (l3 < l2) {
            zipInputStream.getNextEntry();
            ++l3;
        }
        return new BufferedInputStream(zipInputStream);
    }

    public LoadStrategy getParent() {
        return this.parent;
    }

    public Map getUrisToPositions() {
        if (this.usingIndex() && this.urisToPositions == null) {
            this.buildIndex();
        }
        return this.urisToPositions;
    }

    protected ZipInputStream getZipInputStream() throws IOException, FileNotFoundException {
        String string = this.getContainer().getURI();
        InputStream inputStream = this.getParent().getInputStream(string);
        return new ZipInputStream(inputStream);
    }

    protected ZipInputStream getZipInputStreamSkippedTo(String string) throws IOException, FileNotFoundException {
        if (string == null) {
            throw new NullPointerException(ResourceHandler.getString("Null_uri_EXC_"));
        }
        ZipInputStream zipInputStream = this.getZipInputStream();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (string.equals(zipEntry.getName())) {
                return zipInputStream;
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        throw new FileNotFoundException(string);
    }

    public void setParent(LoadStrategy loadStrategy) {
        this.parent = loadStrategy;
    }

    public void setUrisToPositions(Map map) {
        this.urisToPositions = map;
    }

    protected void throwNestedJarException(Exception exception) {
        throw new NestedJarException(ResourceHandler.getString("nested_jar_EXC_", new Object[]{this.getContainer().getURI(), this.getParent().getContainer().getURI()}), exception);
    }

    public boolean usingIndex() {
        return false;
    }
}

