/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.impl.DirectoryLoadStrategyImpl;
import com.ibm.etools.commonarchive.ReadOnlyDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public class ReadOnlyDirectoryLoadStrategyImpl
extends DirectoryLoadStrategyImpl {
    protected File subdirectory;

    public ReadOnlyDirectoryLoadStrategyImpl(String string) {
        super(string);
    }

    public ReadOnlyDirectoryLoadStrategyImpl(String string, File file) {
        super(string);
        this.setSubdirectory(file);
    }

    protected void addDirectory(File file, List list) {
        ReadOnlyDirectory readOnlyDirectory = this.getArchiveFactory().createReadOnlyDirectory();
        readOnlyDirectory.setLastModified(file.lastModified());
        readOnlyDirectory.setURI(this.getURIFrom(file));
        readOnlyDirectory.setLoadingContainer(this.getContainer());
        readOnlyDirectory.setLoadStrategy(new ReadOnlyDirectoryLoadStrategyImpl(this.getDirectoryUri(), file));
        list.add(readOnlyDirectory);
    }

    public boolean contains(String string) {
        return super.contains(string) && (this.getSubdirectory() == null || this.subdirectoryContains(string));
    }

    public String getAbsolutePath() throws FileNotFoundException {
        File file = this.getSubdirectory();
        if (file == null) {
            return super.getAbsolutePath();
        }
        return file.getAbsolutePath();
    }

    protected File getDirectoryForList() {
        if (this.getSubdirectory() != null) {
            return this.getSubdirectory();
        }
        return new File(this.getDirectoryUri());
    }

    protected File getSubdirectory() {
        return this.subdirectory;
    }

    protected boolean isArchive(String string) {
        return false;
    }

    protected void setSubdirectory(File file) {
        this.subdirectory = file;
    }

    protected boolean subdirectoryContains(String string) {
        if (this.getSubdirectory() == null) {
            return false;
        }
        File file = new File(this.getFileNameFrom(string)).getParentFile();
        boolean bl = false;
        while (file != null && !bl) {
            if (this.getSubdirectory().equals(file)) {
                bl = true;
                continue;
            }
            file = file.getParentFile();
        }
        return bl;
    }
}

