/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.FileIterator;
import com.ibm.etools.archive.SaveFilter;
import com.ibm.etools.archive.SaveStrategy;
import com.ibm.etools.archive.exception.SaveFailureException;
import com.ibm.etools.archive.impl.ArchiveStrategyImpl;
import com.ibm.etools.archive.impl.SaveFilterImpl;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.wft.util.Revisit;
import com.ibm.etools.xmi.helpers.CompatibilityXMIResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public abstract class SaveStrategyImpl
extends ArchiveStrategyImpl
implements SaveStrategy {
    protected SaveFilter filter;

    public void close() throws IOException {
    }

    protected abstract SaveStrategy createNestedSaveStrategy(Archive var1) throws IOException;

    public void finish() throws IOException {
    }

    public SaveFilter getFilter() {
        if (this.filter == null) {
            this.filter = new SaveFilterImpl();
        }
        return this.filter;
    }

    protected abstract OutputStream getOutputStreamForResource(Resource var1) throws IOException;

    public boolean isDirectory() {
        return false;
    }

    protected boolean isLoadedResourceOrManifest(File file) {
        return this.getArchive().isMofResourceLoaded(file.getURI()) || file.getURI().equals("META-INF/MANIFEST.MF");
    }

    public void save() throws SaveFailureException {
        this.saveFiles();
        this.saveManifest();
        this.saveMofResources();
    }

    public void save(Archive archive) throws SaveFailureException {
        SaveStrategy saveStrategy = null;
        try {
            saveStrategy = this.createNestedSaveStrategy(archive);
        }
        catch (IOException iOException) {
            throw new SaveFailureException(archive.getURI(), iOException);
        }
        archive.save(saveStrategy);
    }

    public void save(File file, FileIterator fileIterator) throws SaveFailureException {
        if (file.isArchive() && this.shouldIterateOver((Archive)file)) {
            this.save((Archive)file);
        } else {
            InputStream inputStream = null;
            if (!file.isDirectoryEntry()) {
                try {
                    inputStream = fileIterator.getInputStream(file);
                }
                catch (IOException iOException) {
                    throw new SaveFailureException(file.getURI(), iOException);
                }
            }
            this.save(file, inputStream);
        }
    }

    public abstract void save(File var1, InputStream var2) throws SaveFailureException;

    protected void saveFiles() throws SaveFailureException {
        try {
            FileIterator fileIterator = this.getArchive().getFilesForSave();
            while (fileIterator.hasNext()) {
                File file = fileIterator.next();
                if (!this.shouldSave(file)) continue;
                this.save(file, fileIterator);
            }
        }
        catch (IOException iOException) {
            throw new SaveFailureException(ResourceHandler.getString("Error_occurred_iterating_f_EXC_"), iOException);
        }
    }

    protected void saveManifest() throws SaveFailureException {
        if (!this.shouldSave("META-INF/MANIFEST.MF")) {
            return;
        }
        ArchiveManifest archiveManifest = this.getArchive().getManifest();
        if (archiveManifest.getManifestVersion() == null || archiveManifest.getManifestVersion().equals("")) {
            archiveManifest.setManifestVersion("1.0");
        }
        this.save(archiveManifest);
    }

    public void saveMofResource(Resource resource) throws SaveFailureException {
        if (!this.shouldSave(resource)) {
            return;
        }
        this.setEncoding(resource);
        try {
            boolean bl = resource.isModified();
            OutputStream outputStream = this.getOutputStreamForResource(resource);
            this.saveMofResource(resource, outputStream);
            resource.setModified(bl);
        }
        catch (Exception exception) {
            throw new SaveFailureException(resource.getURI().toString(), exception);
        }
    }

    protected void saveMofResource(Resource resource, OutputStream outputStream) throws IOException {
        resource.save(outputStream, Collections.EMPTY_MAP);
    }

    protected void saveMofResources() throws SaveFailureException {
        Iterator iterator = this.getArchive().getLoadedMofResources().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        int n = 0;
        while (n < arrayList.size()) {
            Resource resource = (Resource)arrayList.get(n);
            if (!ArchiveUtil.isJavaResource(resource) && !ArchiveUtil.isRegisteredURIMapping(resource)) {
                Revisit.revisit();
                if (resource instanceof CompatibilityXMIResource) {
                    ((CompatibilityXMIResource)resource).setFormat(1);
                }
                this.saveMofResource(resource);
            }
            ++n;
        }
    }

    protected void setEncoding(Resource resource) {
        Revisit.revisit();
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).setEncoding(this.archive.getXmlEncoding());
        } else if (resource instanceof XMLResource) {
            ((XMLResource)resource).setEncoding(this.archive.getXmlEncoding());
        }
    }

    public void setFilter(SaveFilter saveFilter) {
        this.filter = saveFilter;
    }

    protected boolean shouldIterateOver(Archive archive) {
        return archive.getLoadStrategy().requiresIterationOnSave();
    }

    protected boolean shouldSave(File file) {
        ModuleFile moduleFile;
        boolean bl = this.isLoadedResourceOrManifest(file);
        if (bl) {
            Resource resource = this.archive.getLoadStrategy().getExistingMofResource(file.getURI());
            if (resource == null) {
                return false;
            }
            return !this.shouldSave(resource);
        }
        Archive archive = this.getArchive();
        if (archive.isModuleFile() && (moduleFile = (ModuleFile)archive).getExportStrategy() != null && moduleFile.getExportStrategy().hasSaved(file.getURI())) {
            return false;
        }
        return this.shouldSave(file.getURI());
    }

    protected boolean shouldSave(Resource resource) {
        if (!(resource instanceof XMLResource) && !resource.isModified() && this.getArchive().getOptions().saveOnlyDirtyMofResources()) {
            return false;
        }
        return this.shouldSave(resource.getURI().toString());
    }

    protected boolean shouldSave(String string) {
        return this.getFilter().shouldSave(string, this.getArchive());
    }
}

