/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.impl.LoadStrategyImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileLoadStrategyImpl
extends LoadStrategyImpl {
    protected File file;
    protected ZipFile zipFile;

    public ZipFileLoadStrategyImpl() {
    }

    public ZipFileLoadStrategyImpl(File file) throws IOException {
        this.setFile(file);
        this.setZipFile(new ZipFile(file));
    }

    public void close() {
        super.close();
        try {
            this.getZipFile().close();
        }
        catch (Throwable throwable) {}
    }

    protected boolean primContains(String string) {
        return this.getZipFile().getEntry(string) != null;
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getFile().getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }

    public List getFiles() {
        ArrayList<com.ibm.etools.commonarchive.File> arrayList = new ArrayList<com.ibm.etools.commonarchive.File>();
        Enumeration<? extends ZipEntry> enumeration = this.getZipFile().entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || this.collectedLooseArchiveFiles.containsKey(zipEntry.getName())) continue;
            com.ibm.etools.commonarchive.File file = this.createFile(zipEntry.getName());
            file.setSize(zipEntry.getSize());
            file.setLastModified(zipEntry.getTime());
            arrayList.add(file);
        }
        return arrayList;
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        try {
            ZipEntry zipEntry = this.getZipFile().getEntry(string);
            if (zipEntry == null) {
                throw new FileNotFoundException(string);
            }
            return new BufferedInputStream(this.getZipFile().getInputStream(zipEntry));
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException(illegalStateException.toString());
        }
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public boolean isUsing(File file) {
        return this.getFile() != null && this.getFile().equals(file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }
}

