/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.impl;

import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.SaveStrategy;
import com.ibm.etools.archive.exception.SaveFailureException;
import com.ibm.etools.archive.impl.SaveStrategyImpl;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.wft.util.Revisit;
import com.ibm.etools.xmi.helpers.CompatibilityURIConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;

public class ZipStreamSaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    protected OutputStream destinationStream;
    protected ZipOutputStream zipOutputStream;

    public ZipStreamSaveStrategyImpl(OutputStream outputStream) {
        this.setDestinationStream(outputStream);
        this.setZipOutputStream(new ZipOutputStream(outputStream));
    }

    public void close() throws IOException {
        this.getDestinationStream().close();
    }

    protected SaveStrategy createNestedSaveStrategy(Archive archive) {
        return new ZipStreamSaveStrategyImpl(this.getZipOutputStream());
    }

    public void finish() throws IOException {
        this.getZipOutputStream().finish();
        if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
            this.getDestinationStream().close();
        }
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    protected OutputStream getOutputStreamForResource(Resource resource) throws IOException {
        return this.getZipOutputStream();
    }

    public void saveMofResource(Resource resource, OutputStream outputStream) throws IOException {
        Revisit.revisit();
        URI uRI = resource.getURI();
        URIConverter uRIConverter = this.getArchive().getResourceSet().getURIConverter();
        if (uRIConverter instanceof CompatibilityURIConverter) {
            uRI = ((CompatibilityURIConverter)uRIConverter).deNormalize(uRI);
        }
        ZipEntry zipEntry = new ZipEntry(uRI.toString());
        this.zipOutputStream.putNextEntry(zipEntry);
        super.saveMofResource(resource, outputStream);
        this.zipOutputStream.closeEntry();
    }

    protected ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    public void save(ArchiveManifest archiveManifest) throws SaveFailureException {
        try {
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            this.getZipOutputStream().putNextEntry(zipEntry);
            archiveManifest.write(this.getZipOutputStream());
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException iOException) {
            throw new SaveFailureException("META-INF/MANIFEST.MF", iOException);
        }
    }

    public void save(Archive archive) throws SaveFailureException {
        try {
            ZipEntry zipEntry = new ZipEntry(archive.getURI());
            this.getZipOutputStream().putNextEntry(zipEntry);
            super.save(archive);
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException iOException) {
            throw new SaveFailureException(archive.getURI(), iOException);
        }
    }

    public void save(File file, InputStream inputStream) throws SaveFailureException {
        try {
            String string = file.getURI();
            if (file.isDirectoryEntry() && !string.endsWith("/")) {
                string = string + '/';
            }
            ZipEntry zipEntry = new ZipEntry(string);
            if (file.getLastModified() > 0L) {
                zipEntry.setTime(file.getLastModified());
            }
            this.getZipOutputStream().putNextEntry(zipEntry);
            if (!file.isDirectoryEntry()) {
                ArchiveUtil.copy(inputStream, this.getZipOutputStream());
            }
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException iOException) {
            throw new SaveFailureException(file.getURI(), iOException);
        }
    }

    public void setDestinationStream(OutputStream outputStream) {
        this.destinationStream = outputStream;
    }

    protected void setZipOutputStream(ZipOutputStream zipOutputStream) {
        this.zipOutputStream = zipOutputStream;
    }
}

