/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.util;

import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class ArchiveFileDynamicClassLoader
extends ClassLoader {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Archive archive = null;
    protected ClassLoader extraClassLoader;
    protected boolean inEARFile;

    public ArchiveFileDynamicClassLoader(Archive archive, ClassLoader classLoader, ClassLoader classLoader2) {
        super(classLoader);
        this.setArchive(archive);
        this.setExtraClassLoader(classLoader2);
        this.inEARFile = archive.getContainer() != null && archive.getContainer().isEARFile();
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        byte[] byArray = this.getClassBytesFor(string);
        if (byArray != null) {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
        } else {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected byte[] getClassBytesFor(String string) {
        if (string == null) {
            return null;
        }
        String string2 = ArchiveUtil.classNameToUri(string);
        try {
            InputStream inputStream = this.getArchive().getInputStream(string2);
            return ArchiveUtil.inputStreamToBytes(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            throw new ArchiveRuntimeException(ResourceHandler.getString("io_ex_loading_EXC_", new Object[]{string}), iOException);
        }
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive().getContainer();
    }

    public ClassLoader getExtraClassLoader() {
        return this.extraClassLoader;
    }

    protected synchronized Class loadClass(String string, Set set) throws ClassNotFoundException {
        if (set.contains(this.getArchive())) {
            throw new ClassNotFoundException(string);
        }
        set.add(this.getArchive());
        try {
            return super.loadClass(string, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadClassInDependentJarInEAR(string, set);
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            return super.loadClass(string, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = this.loadClassInDependentJar(string);
            if (clazz != null && bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    protected Class loadClassInDependentJar(String string) throws ClassNotFoundException {
        if (this.inEARFile) {
            return this.loadClassInDependentJarInEAR(string);
        }
        if (this.getExtraClassLoader() != null) {
            return this.getExtraClassLoader().loadClass(string);
        }
        throw new ClassNotFoundException(string);
    }

    protected Class loadClassInDependentJarInEAR(String string) throws ClassNotFoundException {
        HashSet<Archive> hashSet = new HashSet<Archive>(5);
        hashSet.add(this.getArchive());
        return this.loadClassInDependentJarInEAR(string, hashSet);
    }

    protected Class loadClassInDependentJarInEAR(String string, Set set) throws ClassNotFoundException {
        String[] stringArray = this.archive.getManifest().getClassPathTokenized();
        int n = 0;
        while (n < stringArray.length) {
            try {
                File file;
                String string2 = ArchiveUtil.deriveEARRelativeURI(stringArray[n], this.archive);
                if (string2 != null && (file = this.getEARFile().getFile(string2)).isArchive()) {
                    Archive archive = (Archive)file;
                    try {
                        return ((ArchiveFileDynamicClassLoader)archive.getArchiveClassLoader()).loadClass(string, set);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            ++n;
        }
        throw new ClassNotFoundException(string);
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public void setExtraClassLoader(ClassLoader classLoader) {
        this.extraClassLoader = classLoader;
    }
}

