/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.util;

import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.etools.application.Module;
import com.ibm.etools.archive.exception.ArchiveException;
import com.ibm.etools.archive.exception.EmptyResourceException;
import com.ibm.etools.archive.impl.ArchiveURIConverterImpl;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.xml.bridge.XmlDocumentReader;
import com.ibm.etools.java.JavaURL;
import com.ibm.etools.logger.proxy.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.w3c.dom.DocumentType;

public class ArchiveUtil {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String DOT_CLASS = ".class";
    public static final String DOT_JAVA = ".java";
    protected static boolean isRuntime = false;
    protected static boolean shouldUseTempDirectoryForRead = true;
    protected static String tempDirectoryName;
    protected static File tempDirectory;

    public static String classNameToJavaUri(String string) {
        return string.replace('.', '/').concat(DOT_JAVA);
    }

    public static String classNameToUri(String string) {
        return string.replace('.', '/').concat(DOT_CLASS);
    }

    public static String classUriToJavaUri(String string) {
        if (string == null || !string.endsWith(DOT_CLASS)) {
            return null;
        }
        String string2 = ArchiveUtil.truncateIgnoreCase(string, DOT_CLASS);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "$");
        return stringTokenizer.nextToken().concat(DOT_JAVA);
    }

    public static String concatUri(String string, String string2, char c) {
        String string3 = string;
        if (!string.endsWith(c + "") && !string2.startsWith(c + "")) {
            string3 = string3 + c;
        }
        return string3 + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        try {
            int n = inputStream.read(byArray);
            while (n > 0) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        finally {
            if (!(inputStream instanceof ZipInputStream)) {
                inputStream.close();
            }
            if (!(outputStream instanceof ZipOutputStream)) {
                outputStream.close();
            }
        }
    }

    public static File createTempDirectory(String string, File file) throws IOException {
        File file2 = ArchiveUtil.createTempFile(string, file);
        file2.delete();
        file2.mkdir();
        return file2;
    }

    public static File createTempFile(String string) throws IOException {
        return ArchiveUtil.createTempFile(string, ArchiveUtil.getTempDirectory());
    }

    public static File createTempFile(String string, File file) throws IOException {
        String string2 = ArchiveUtil.getFileNameTail(string);
        if (string2.length() < 3) {
            string2 = "WSTMP" + string2;
        }
        File file2 = File.createTempFile(string2, null, file);
        return file2;
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (!ArchiveUtil.delete(fileArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return file.delete();
    }

    public static List getWriteProtectedFiles(File file, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<File>();
        }
        if (file.exists() && !file.canWrite()) {
            arrayList.add(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                ArchiveUtil.getWriteProtectedFiles(fileArray[n], arrayList);
                ++n;
            }
        }
        return arrayList;
    }

    public static String deriveEARRelativeURI(String string, Archive archive) {
        return ArchiveUtil.deriveEARRelativeURI(string, archive.getURI());
    }

    public static String deriveEARRelativeURI(String string, String string2) {
        try {
            String string3 = ArchiveUtil.getFileNameParent(string2);
            if (string3 == null || string3.equals("")) {
                string3 = ".";
            }
            String string4 = new File(".").getCanonicalPath();
            String string5 = new File(string3, string).getCanonicalPath();
            if (!string5.startsWith(string4)) {
                return null;
            }
            if (string5.equals(string4)) {
                return null;
            }
            int n = string4.endsWith(File.separator) ? string4.length() : string4.length() + 1;
            return string5.substring(n, string5.length()).replace(File.separatorChar, '/');
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getDefaultAltBindingsUri(ModuleExtension moduleExtension, EARFile eARFile) {
        String string = ArchiveUtil.getOrCreateAltRoot(moduleExtension, eARFile);
        return ArchiveUtil.concatUri(string, moduleExtension.getDefaultBindingsShortName(), '/');
    }

    public static String getOrCreateAltRoot(ModuleExtension moduleExtension, EARFile eARFile) {
        if (!ArchiveUtil.isNullOrEmpty(moduleExtension.getAltRoot())) {
            return moduleExtension.getAltRoot();
        }
        String string = null;
        int n = 0;
        do {
            string = ArchiveUtil.concatUri("ALT-INF", moduleExtension.getModule().getUri(), '/');
            if (n > 0) {
                string = string + n;
            }
            ++n;
        } while (ArchiveUtil.altRootCollides(string, moduleExtension, eARFile));
        moduleExtension.setAltRoot(string);
        return string;
    }

    protected static boolean altRootCollides(String string, ModuleExtension moduleExtension, EARFile eARFile) {
        String string2 = moduleExtension.getAltBindings();
        String string3 = moduleExtension.getAltExtensions();
        String string4 = moduleExtension.getModule().getAltDD();
        if (ArchiveUtil.isNullOrEmpty(string2) && ArchiveUtil.isNullOrEmpty(string3) && ArchiveUtil.isNullOrEmpty(string4)) {
            string2 = ArchiveUtil.concatUri(string, moduleExtension.getDefaultBindingsShortName(), '/');
            string3 = ArchiveUtil.concatUri(string, moduleExtension.getDefaultExtensionsShortName(), '/');
            string4 = ArchiveUtil.concatUri(string, moduleExtension.getDeploymentDescriptorShortName(), '/');
            return eARFile.isDuplicate(string2) || eARFile.isDuplicate(string3) || eARFile.isDuplicate(string4);
        }
        return !ArchiveUtil.isNullOrEmpty(string2) && string2.startsWith(string) || !ArchiveUtil.isNullOrEmpty(string3) && string3.startsWith(string) || !ArchiveUtil.isNullOrEmpty(string4) && string4.startsWith(string);
    }

    public static String getDefaultAltDDUri(ModuleExtension moduleExtension, EARFile eARFile) {
        String string = ArchiveUtil.getOrCreateAltRoot(moduleExtension, eARFile);
        return ArchiveUtil.concatUri(string, moduleExtension.getDeploymentDescriptorShortName(), '/');
    }

    public static String getDefaultAltExtensionsUri(ModuleExtension moduleExtension, EARFile eARFile) {
        String string = ArchiveUtil.getOrCreateAltRoot(moduleExtension, eARFile);
        return ArchiveUtil.concatUri(string, moduleExtension.getDefaultExtensionsShortName(), '/');
    }

    public static String getFileNameExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) != -1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String getFileNameParent(String string) {
        String string2 = string.replace('\\', '/');
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        if (n == 0) {
            return "/";
        }
        return string.substring(0, n);
    }

    public static String getFileNameTail(String string) {
        String string2 = string.replace('\\', '/');
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string2.length());
    }

    public static ModuleFile getModuleFile(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        Archive archive = ArchiveUtil.getArchive(resource);
        if (archive == null || !archive.isModuleFile()) {
            return null;
        }
        if (!(resource instanceof XMLResource)) {
            return null;
        }
        XMLResource xMLResource = (XMLResource)resource;
        if (xMLResource.isAlt()) {
            return ArchiveUtil.getModuleFileUsingAltDD((EARFile)archive, resource);
        }
        return (ModuleFile)archive;
    }

    protected static ModuleFile getModuleFileUsingAltDD(EARFile eARFile, Resource resource) {
        if (resource == null) {
            return null;
        }
        String string = resource.getURI().toString();
        Module module = eARFile.getDeploymentDescriptor().getModuleHavingAltDD(string);
        if (module == null) {
            return null;
        }
        ModuleRef moduleRef = eARFile.getModuleRef(module);
        if (moduleRef == null) {
            return null;
        }
        return moduleRef.getModuleFile();
    }

    public static Archive getArchive(Resource resource) {
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        URIConverter uRIConverter = resourceSet.getURIConverter();
        if (uRIConverter == null || !(uRIConverter instanceof ArchiveURIConverterImpl)) {
            return null;
        }
        return ((ArchiveURIConverterImpl)uRIConverter).getArchive();
    }

    public static String getOSUri(String string) {
        char c = File.separatorChar;
        if (c != '/') {
            return string.replace('/', c);
        }
        return string.replace('\\', c);
    }

    public static String getOSUri(String string, String string2) {
        String string3 = ArchiveUtil.getOSUri(string);
        String string4 = ArchiveUtil.getOSUri(string2);
        return ArchiveUtil.concatUri(string3, string4, File.separatorChar);
    }

    public static EObject getRoot(Resource resource) throws EmptyResourceException {
        EList eList = resource.getContents();
        if (eList.size() < 1) {
            throw new EmptyResourceException(resource.getURI().toString());
        }
        return (EObject)eList.get(0);
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryName() {
        return tempDirectoryName;
    }

    public static String[] getTokens(String string) {
        return ArchiveUtil.getTokens(string, null);
    }

    public static String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n && stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public static String getValueIgnoreKeyCase(String string, Attributes attributes) {
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = entry.getKey().toString();
            if (!string2.equalsIgnoreCase(string)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    public static void inform(String string) {
        Logger.getLogger().logInfo(string);
    }

    public static byte[] inputStreamToBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArchiveUtil.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isJavaResource(Resource resource) {
        return JavaURL.isJavaURL((String)resource.getURI().toString());
    }

    public static boolean isRegisteredURIMapping(Resource resource) {
        return URIMappingRegistryImpl.INSTANCE.getURI(resource.getURI()) != resource.getURI();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isRuntime() {
        return isRuntime;
    }

    public static boolean isValidDependency(Archive archive, Archive archive2) {
        if (archive.isWARFile()) {
            return false;
        }
        if (archive == archive2) {
            return false;
        }
        return archive2.isApplicationClientFile() || !archive.isApplicationClientFile();
    }

    public static Properties loadProperties(Archive archive, String string) throws FileNotFoundException, IOException {
        InputStream inputStream = archive.getInputStream(string);
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    public static void setIsRuntime(boolean bl) {
        isRuntime = bl;
    }

    public static void setShouldUseTempDirectoryForRead(boolean bl) {
        shouldUseTempDirectoryForRead = bl;
    }

    public static void setTempDirectory(File file) {
        tempDirectory = file;
        tempDirectoryName = file.getAbsolutePath();
    }

    public static void setTempDirectoryName(String string) throws ArchiveException {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
            if (!file.exists()) {
                throw new ArchiveException(ResourceHandler.getString("make_temp_dir_EXC_", new Object[]{string}));
            }
            file.deleteOnExit();
        }
        ArchiveUtil.setTempDirectory(file);
    }

    public static boolean shouldUseTempDirectoryForRead() {
        return shouldUseTempDirectoryForRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static URL[] toLocalURLs(List var0, String var1_1) {
        var2_2 = new ArrayList<Object>();
        var3_3 = 0;
        while (var3_3 < var0.size()) {
            block20: {
                var4_4 = (String)var0.get(var3_3);
                var5_5 = new File((String)var4_4);
                if (!var5_5.isAbsolute()) {
                    var4_4 = ArchiveUtil.getOSUri(var1_1, (String)var4_4);
                    var5_5 = new File((String)var4_4);
                }
                if (var5_5.exists()) {
                    block19: {
                        if (var5_5.isDirectory()) {
                            if (!var4_4.endsWith(File.separator)) {
                                var4_4 = (String)var4_4 + File.separatorChar;
                            }
                        } else {
                            var6_6 = null;
                            try {
                                var6_6 = new ZipFile(var5_5);
                                var9_9 = null;
                                ** if (var6_6 == null) goto lbl-1000
                            }
                            catch (Throwable var8_11) {
                                var9_9 = null;
                                if (var6_6 != null) {
                                    try {
                                        var6_6.close();
                                    }
                                    catch (IOException var10_10) {
                                        // empty catch block
                                    }
                                }
                                throw var8_11;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    var6_6.close();
                                }
                                catch (IOException var10_10) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block19;
                                catch (Exception var7_8) {
                                    ArchiveUtil.inform(ResourceHandler.getString("invalid_classpath_WARN_", new Object[]{var4_4}));
                                    var9_9 = null;
                                    if (var6_6 != null) {
                                        try {
                                            var6_6.close();
                                        }
                                        catch (IOException var10_10) {}
                                    }
                                    break block20;
                                }
                            }
                        }
                    }
                    try {
                        var5_5 = new File((String)var4_4);
                        var6_6 = var5_5.toURL();
                        var2_2.add(var6_6);
                    }
                    catch (MalformedURLException var6_7) {
                        ArchiveUtil.inform(ResourceHandler.getString("invalid_cp_file_WARN_", new Object[]{var4_4}));
                    }
                }
            }
            ++var3_3;
        }
        var4_4 = new URL[var2_2.size()];
        return var2_2.toArray((T[])var4_4);
    }

    public static String truncateFromFrontIgnoreCase(String string, String string2) {
        if (!string.toLowerCase().startsWith(string2.toLowerCase())) {
            return string;
        }
        return string.substring(string2.length(), string.length());
    }

    public static String truncateIgnoreCase(String string, String string2) {
        int n = string.toLowerCase().lastIndexOf(string2.toLowerCase());
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String uriToClassName(String string) {
        return ArchiveUtil.truncateIgnoreCase(string.replace('/', '.'), DOT_CLASS);
    }

    public static boolean isJ2EE13FastCheck(ModuleFile moduleFile) {
        if (moduleFile == null) {
            return false;
        }
        if (moduleFile.isRARFile()) {
            return true;
        }
        InputStream inputStream = null;
        String string = moduleFile.getDeploymentDescriptorUri();
        try {
            inputStream = moduleFile.getInputStream(string);
        }
        catch (IOException iOException) {
            return false;
        }
        DocumentType documentType = XmlDocumentReader.readDocumentType((InputStream)inputStream, (String)string);
        if (documentType == null) {
            return false;
        }
        String[] stringArray = ArchiveUtil.getJ2EE13PublicAndSystemIdFor(moduleFile);
        if (stringArray == null) {
            return false;
        }
        return stringArray[0].equals(documentType.getPublicId()) && stringArray[1].equals(documentType.getSystemId());
    }

    protected static String[] getJ2EE13PublicAndSystemIdFor(ModuleFile moduleFile) {
        if (moduleFile.isEARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd"};
        }
        if (moduleFile.isEJBJarFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"};
        }
        if (moduleFile.isApplicationClientFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd"};
        }
        if (moduleFile.isWARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"};
        }
        if (moduleFile.isRARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "http://java.sun.com/dtd/connector_1_0.dtd"};
        }
        return null;
    }
}

