/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.util;

import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;

public class BackendUtil {
    protected static final String EXCEPTION_LOADING_PROPERTIES = "Exception occurred loading properties: ";

    public static String getBABName(String string, ContainerManagedEntity containerManagedEntity) {
        return BackendUtil.getBABName(string, containerManagedEntity.getEjbJar(), containerManagedEntity.getAbstractSchemaName());
    }

    public static String getBABName(String string, EJBJar eJBJar, String string2) {
        if (string == null || eJBJar == null || string2 == null) {
            return null;
        }
        ModuleFile moduleFile = ArchiveUtil.getModuleFile((EObject)eJBJar);
        if (moduleFile == null || !moduleFile.isEJBJarFile()) {
            return null;
        }
        Properties properties = BackendUtil.getBackendProperties(string, (EJBJarFile)moduleFile);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(string2);
    }

    public static Properties getBackendProperties(String string, EJBJarFile eJBJarFile) {
        if (string == null || eJBJarFile == null) {
            return null;
        }
        String string2 = ArchiveUtil.concatUri("META-INF/backends", string, '/');
        String string3 = ArchiveUtil.concatUri(string2, "ibm_pmbab.properties", '/');
        try {
            return ArchiveUtil.loadProperties(eJBJarFile, string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            throw new ArchiveRuntimeException(EXCEPTION_LOADING_PROPERTIES + string3, iOException);
        }
    }

    public static List getAllBackendIDs(EJBJarFile eJBJarFile, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = eJBJarFile.filterFilesByPrefix("META-INF/backends").iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.getURI().endsWith("dbxmi")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(file.getURI(), "/");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            arrayList.add(stringTokenizer.nextToken());
        }
        if (bl) {
            eJBJarFile.clearFiles();
        }
        return arrayList;
    }
}

