/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.util;

import com.ibm.etools.archive.RuntimeClasspathEntry;
import com.ibm.etools.archive.impl.RuntimeClasspathEntryImpl;
import com.ibm.etools.logger.proxy.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ClasspathUtil {
    public static void processManifest(String string, List list, Set set) {
        ArrayList arrayList = ClasspathUtil.getManifestPaths(string);
        int n = 0;
        while (n < arrayList.size()) {
            RuntimeClasspathEntry runtimeClasspathEntry = (RuntimeClasspathEntry)arrayList.get(n);
            if (!set.contains(runtimeClasspathEntry)) {
                set.add(runtimeClasspathEntry);
                list.add(runtimeClasspathEntry);
                ClasspathUtil.processManifest(runtimeClasspathEntry.getAbsolutePath(), list, set);
            }
            ++n;
        }
    }

    protected static RuntimeClasspathEntry createRuntimeClasspathEntry(String string, String string2) {
        RuntimeClasspathEntryImpl runtimeClasspathEntryImpl = new RuntimeClasspathEntryImpl();
        runtimeClasspathEntryImpl.setAbsolutePath(string);
        runtimeClasspathEntryImpl.setManifestValue(string2);
        return runtimeClasspathEntryImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ArrayList getManifestPaths(String string) {
        JarFile jarFile;
        ArrayList arrayList;
        block21: {
            arrayList = new ArrayList();
            File file = new File(string);
            if (!file.exists()) return arrayList;
            if (file.isDirectory()) {
                File file2 = new File(string + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
                if (!file2.exists()) return arrayList;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file2);
                    Manifest manifest = new Manifest(fileInputStream);
                    arrayList = ClasspathUtil.getManifestClassPaths(manifest, file.getParent());
                    return arrayList;
                }
                catch (IOException iOException) {
                    return arrayList;
                }
                finally {
                    if (null != fileInputStream) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger().logError((Throwable)iOException);
                        }
                    }
                }
            }
            jarFile = null;
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) break block21;
            arrayList = ClasspathUtil.getManifestClassPaths(manifest, file.getParent());
        }
        Object var10_14 = null;
        if (jarFile == null) return arrayList;
        try {
            jarFile.close();
            return arrayList;
        }
        catch (IOException iOException) {}
        return arrayList;
        {
            catch (IOException iOException) {
                Object var10_15 = null;
                if (jarFile == null) return arrayList;
                try {
                    jarFile.close();
                    return arrayList;
                }
                catch (IOException iOException2) {}
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected static ArrayList getManifestClassPaths(Manifest manifest, String string) {
        ArrayList<RuntimeClasspathEntry> arrayList = new ArrayList<RuntimeClasspathEntry>();
        Attributes attributes = manifest.getMainAttributes();
        String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string + File.separator + string3;
                if (!new File(string4 = ClasspathUtil.normalizePath(string4)).exists()) continue;
                arrayList.add(ClasspathUtil.createRuntimeClasspathEntry(string4, string3));
            }
        }
        return arrayList;
    }

    public static String normalizePath(String string) {
        File file = new File(string);
        try {
            file = file.getCanonicalFile();
        }
        catch (Exception exception) {}
        return file.getPath();
    }
}

