/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.util;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.UserFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.WhereClauseFinderDescriptor;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.MethodElementKind;
import com.ibm.etools.java.Block;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.Method;
import com.ibm.etools.java.adapters.JavaReflectionAdaptor;
import com.ibm.etools.java.impl.JavaClassImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class FinderHelperMetaDataConverter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String FIND = "find";
    public static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    public static final String FINDER_HELPER = "FinderHelper";
    public static final String WHERE_CLAUSE = "WhereClause";
    public static final String QUERY_STRING = "QueryString";
    protected EJBJarFile ejbJarFile;
    protected ContainerManagedEntity currentCMP;
    protected JavaClass currentInterface;

    public FinderHelperMetaDataConverter(EJBJarFile eJBJarFile) {
        this.ejbJarFile = eJBJarFile;
    }

    protected void addFinderDescriptor(FinderDescriptor finderDescriptor, MethodElement methodElement) {
        finderDescriptor.getFinderMethodElements().add((Object)methodElement);
        this.getCurrentExtension().getFinderDescriptors().add((Object)finderDescriptor);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Field field) {
        WhereClauseFinderDescriptor whereClauseFinderDescriptor = null;
        Block block = field.getInitializer();
        String string = null;
        if (block == null || (string = block.getSource()) == null) {
            return;
        }
        String string2 = string.substring(1, string.length() - 1);
        if (this.isWhereClause(field)) {
            whereClauseFinderDescriptor = this.getExtensionsFactory().createWhereClauseFinderDescriptor();
            whereClauseFinderDescriptor.setWhereClause(string2);
        } else {
            whereClauseFinderDescriptor = this.getExtensionsFactory().createFullSelectFinderDescriptor();
            ((FullSelectFinderDescriptor)whereClauseFinderDescriptor).setSelectStatement(string2);
        }
        this.addFinderDescriptor((FinderDescriptor)whereClauseFinderDescriptor, methodElement);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Method method) {
        UserFinderDescriptor userFinderDescriptor = this.getExtensionsFactory().createUserFinderDescriptor();
        this.addFinderDescriptor((FinderDescriptor)userFinderDescriptor, methodElement);
    }

    protected MethodElement createMethodElement(Method method) {
        MethodElement methodElement = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createMethodElementFrom(method);
        methodElement.setEnterpriseBean((EnterpriseBean)this.currentCMP);
        methodElement.setType(MethodElementKind.HOME_LITERAL);
        if (!methodElement.hasMethodParams()) {
            methodElement.applyZeroParams();
        }
        return methodElement;
    }

    protected Field detectFinderFieldFor(Method method) {
        List list = this.currentInterface.getFieldsExtended();
        int n = 0;
        while (n < list.size()) {
            Field field = (Field)list.get(n);
            String string = field.getName();
            if (string.equals(method.getName().concat(WHERE_CLAUSE)) || string.equals(method.getName().concat(QUERY_STRING))) {
                return field;
            }
            ++n;
        }
        return null;
    }

    protected Method detectFinderMethodFor(MethodElement methodElement) {
        List list = this.currentInterface.getMethodsExtended();
        int n = 0;
        while (n < list.size()) {
            Method method = (Method)list.get(n);
            if (methodElement.nameAndParamsEquals(method)) {
                return method;
            }
            ++n;
        }
        return null;
    }

    protected ContainerManagedEntityExtension getCurrentExtension() {
        return (ContainerManagedEntityExtension)EjbExtensionsHelper.getEjbExtension((EnterpriseBean)this.currentCMP);
    }

    public EjbextFactory getExtensionsFactory() {
        return ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
    }

    protected List getFindMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        if (this.currentCMP.getHomeInterface() != null) {
            List list = this.currentCMP.getHomeInterface().getMethodsExtended();
            int n = 0;
            while (n < list.size()) {
                Method method = (Method)list.get(n);
                if (method.getName().startsWith(FIND) && !method.getName().equals(FIND_BY_PRIMARY_KEY)) {
                    arrayList.add(method);
                }
                ++n;
            }
        }
        return arrayList;
    }

    protected boolean isWhereClause(Field field) {
        return field.getName().endsWith(WHERE_CLAUSE);
    }

    protected void primReflectCurrentCMP() {
        this.setCurrentInterface();
        if (this.currentInterface == null) {
            return;
        }
        List list = this.getFindMethods();
        int n = 0;
        while (n < list.size()) {
            Method method = (Method)list.get(n);
            MethodElement methodElement = this.createMethodElement(method);
            Field field = this.detectFinderFieldFor(method);
            if (field != null) {
                this.addFinderDescriptor(methodElement, field);
            } else {
                Method method2 = this.detectFinderMethodFor(methodElement);
                if (method2 != null) {
                    this.addFinderDescriptor(methodElement, method2);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectCurrentCMP() {
        try {
            this.primReflectCurrentCMP();
        }
        finally {
            if (this.currentInterface != null) {
                JavaReflectionAdaptor.releaseSourceType((JavaClass)this.currentInterface);
            }
            if (this.currentCMP != null && this.currentCMP.getHomeInterface() != null) {
                JavaReflectionAdaptor.releaseSourceType((JavaClass)this.currentCMP.getHomeInterface());
            }
        }
    }

    public void reflectMetaData() {
        EList eList = this.ejbJarFile.getDeploymentDescriptor().getEnterpriseBeans();
        int n = 0;
        while (n < eList.size()) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(n);
            if (enterpriseBean.isContainerManagedEntity()) {
                this.currentCMP = (ContainerManagedEntity)enterpriseBean;
                this.reflectCurrentCMP();
            }
            ++n;
        }
    }

    protected JavaClass setCurrentInterface() {
        String string = this.currentCMP.getEjbClassName().concat(FINDER_HELPER);
        if (!this.ejbJarFile.containsFile(ArchiveUtil.classNameToUri(string))) {
            this.currentInterface = null;
        }
        this.currentInterface = (JavaClass)JavaClassImpl.reflect((String)string, (ResourceSet)this.ejbJarFile.getResourceSet());
        return this.currentInterface;
    }
}

