/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.impl;

import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.impl.ArchiveManifestImpl;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.ArchiveCopySessionUtility;
import com.ibm.etools.emf.ecore.utilities.copy.CopyGroup;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import com.ibm.etools.j2ee.common.util.Defaultable;
import com.ibm.etools.webapplication.FilterMapping;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;

public class ArchiveCopyUtility
extends EtoolsCopyUtility {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    protected void addDeferredSingleReferenceCopy(EReference eReference, EObject eObject, String string, EObject eObject2) {
        if ((eReference == this.getCommonarchivePackage().getEJBComponent_Bindings() || eReference == this.getCommonarchivePackage().getEJBComponent_Extensions() || eReference == this.getCommonarchivePackage().getServletComponent_Extensions()) && ((Defaultable)eObject).isDefault()) {
            return;
        }
        super.addDeferredSingleReferenceCopy(eReference, eObject, string, eObject2);
    }

    public ArchiveManifest copy(ArchiveManifest archiveManifest) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            archiveManifest.write(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return new ArchiveManifestImpl(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new ArchiveRuntimeException(ResourceHandler.getString("IOException_occurred_while_EXC_"), iOException);
        }
    }

    public Archive copy(Archive archive) {
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(true);
        this.prepareResourcesForCopy(archive, copyGroup);
        copyGroup.add((EObject)archive);
        this.copy(copyGroup);
        Archive archive2 = (Archive)this.getCopy(archive);
        this.finishCopy(archive, archive2, copyGroup);
        return archive2;
    }

    public ModuleFile copy(ModuleFile moduleFile) {
        Object object;
        moduleFile.getStandardDeploymentDescriptor();
        moduleFile.getStandardBindings();
        moduleFile.getStandardExtensions();
        if (moduleFile.isWARFile()) {
            object = ((WARFile)moduleFile).getDeploymentDescriptor().getFilterMappings();
            int n = 0;
            while (n < object.size()) {
                ((FilterMapping)object.get(n)).getServlet();
                ++n;
            }
        }
        object = (ModuleFile)this.copy((Archive)moduleFile);
        return object;
    }

    public void copy(CopyGroup copyGroup) {
        if (copyGroup != null) {
            ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
            archiveCopySessionUtility.setPreserveIds(copyGroup.getPreserveIds());
            archiveCopySessionUtility.copy(copyGroup);
            archiveCopySessionUtility.flush();
        }
    }

    public EObject copy(EObject eObject, String string) {
        ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
        EObject eObject2 = archiveCopySessionUtility.copy(eObject, string);
        archiveCopySessionUtility.flush();
        return eObject2;
    }

    public Resource copy(Resource resource, String string) {
        ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
        Resource resource2 = archiveCopySessionUtility.copy(resource, string);
        archiveCopySessionUtility.flush();
        return resource2;
    }

    protected void copyImportStrategyIfNecessary(ModuleFile moduleFile, ModuleFile moduleFile2) {
        if (!moduleFile.isDeploymentDescriptorSet()) {
            moduleFile2.setImportStrategy(moduleFile.getImportStrategy().createImportStrategy(moduleFile, moduleFile2));
        }
    }

    public EObject copyObject(EObject eObject, String string) {
        ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
        EObject eObject2 = archiveCopySessionUtility.copyObject(eObject, string);
        archiveCopySessionUtility.flush();
        return eObject2;
    }

    public static void createCopy(CopyGroup copyGroup) {
        ArchiveCopyUtility archiveCopyUtility = new ArchiveCopyUtility();
        archiveCopyUtility.copy(copyGroup);
    }

    protected void finishCopy(Archive archive, Archive archive2, CopyGroup copyGroup) {
        archive2.setLoadStrategy(((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory().createEmptyLoadStrategy());
        archive2.setExtraClasspath(archive.getExtraClasspath());
        archive2.setXmlEncoding(archive.getXmlEncoding());
        if (archive.isManifestSet()) {
            archive2.setManifest(this.copy(archive.getManifest()));
        }
        this.retrieveResourcesFromCopy(archive2, copyGroup);
        if (archive.isModuleFile()) {
            this.copyImportStrategyIfNecessary((ModuleFile)archive, (ModuleFile)archive2);
        }
        EList eList = archive.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            File file2 = (File)this.getCopy(file);
            file2.setLoadingContainer(file.getLoadingContainer());
            if (file.isArchive()) {
                this.finishNestedCopy((Archive)file, (Archive)file2);
            }
            ++n;
        }
        archive2.rebuildFileIndex();
    }

    protected void finishNestedCopy(Archive archive, Archive archive2) {
        CopyGroup copyGroup = new CopyGroup();
        this.prepareResourcesForCopy(archive, copyGroup);
        this.copy(copyGroup);
        this.finishCopy(archive, archive2, copyGroup);
    }

    private CommonarchivePackage getCommonarchivePackage() {
        return (CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi");
    }

    protected void prepareResourcesForCopy(Archive archive, CopyGroup copyGroup) {
        Iterator iterator = archive.getLoadedMofResources().iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (ArchiveUtil.isJavaResource(resource)) continue;
            copyGroup.add(resource);
        }
    }

    protected void retrieveResourcesFromCopy(Archive archive, CopyGroup copyGroup) {
        List list = copyGroup.getCopiedResources();
        int n = 0;
        while (n < list.size()) {
            Resource resource = (Resource)list.get(n);
            archive.addOrReplaceMofResource(resource);
            ++n;
        }
    }
}

