/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.impl;

import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.FileIterator;
import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.archive.RuntimeClasspathEntry;
import com.ibm.etools.archive.SaveFilter;
import com.ibm.etools.archive.SaveStrategy;
import com.ibm.etools.archive.exception.DuplicateObjectException;
import com.ibm.etools.archive.exception.ManifestException;
import com.ibm.etools.archive.exception.OpenFailureException;
import com.ibm.etools.archive.exception.ReopenException;
import com.ibm.etools.archive.exception.ResourceLoadException;
import com.ibm.etools.archive.exception.SaveFailureException;
import com.ibm.etools.archive.impl.ArchiveManifestImpl;
import com.ibm.etools.archive.impl.ArchiveOptions;
import com.ibm.etools.archive.impl.DirectorySaveStrategyImpl;
import com.ibm.etools.archive.impl.RuntimeClasspathEntryImpl;
import com.ibm.etools.archive.impl.ZipStreamSaveStrategyImpl;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveFileDynamicClassLoader;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.archive.util.ClasspathUtil;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.ReadOnlyDirectory;
import com.ibm.etools.commonarchive.impl.ContainerImpl;
import com.ibm.etools.commonarchive.impl.FileImpl;
import com.ibm.etools.commonarchive.looseconfig.LooseArchive;
import com.ibm.etools.emf.ecore.utilities.ExtendedEcoreUtil;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import com.ibm.etools.java.adapters.jdk.JavaJDKAdapterFactory;
import com.ibm.etools.wft.util.Revisit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ArchiveImpl
extends ContainerImpl
implements Archive {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected ArchiveManifest manifest;
    protected SaveStrategy saveStrategy;
    protected SaveFilter saveFilter;
    protected String xmlEncoding = "UTF-8";
    protected ClassLoader archiveClassLoader;
    protected String extraClasspath;
    protected ArchiveOptions options;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$Container;

    public ArchiveImpl() {
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getArchive();
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 6: {
                    if (this.eContainer != null) {
                        notificationChain = this.eBasicRemoveFromContainer(notificationChain);
                    }
                    return this.eBasicSetContainer(internalEObject, 6, notificationChain);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseAdd(internalEObject, n, clazz, notificationChain);
        }
        if (this.eContainer != null) {
            notificationChain = this.eBasicRemoveFromContainer(notificationChain);
        }
        return this.eBasicSetContainer(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, notificationChain);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseRemove(internalEObject, n, clazz, notificationChain);
        }
        return this.eBasicSetContainer(null, n, notificationChain);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain notificationChain) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 6: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, class$com$ibm$etools$commonarchive$Container == null ? (class$com$ibm$etools$commonarchive$Container = ArchiveImpl.class$("com.ibm.etools.commonarchive.Container")) : class$com$ibm$etools$commonarchive$Container, notificationChain);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(notificationChain);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, notificationChain);
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (bl) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setURI((String)object);
                return;
            }
            case 1: {
                this.setLastModified((Long)object);
                return;
            }
            case 2: {
                this.setSize((Long)object);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)object);
                return;
            }
            case 4: {
                this.setOriginalURI((String)object);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)object);
                return;
            }
            case 6: {
                this.setContainer((Container)object);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setURI(FileImpl.URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(FileImpl.ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return FileImpl.URI_EDEFAULT == null ? this.uri != null : !FileImpl.URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return FileImpl.ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !FileImpl.ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public Archive addCopy(Archive archive) throws DuplicateObjectException {
        this.checkAddValid(archive);
        Archive archive2 = this.getCommonArchiveFactory().copy(archive);
        this.getFiles().add((Object)archive2);
        return archive2;
    }

    public File addCopy(File file) throws DuplicateObjectException {
        if (file.isReadOnlyDirectory()) {
            this.addCopy((ReadOnlyDirectory)file);
            return null;
        }
        this.checkAddValid(file);
        File file2 = this.copy(file);
        this.getFiles().add((Object)file2);
        return file2;
    }

    public List addCopy(ReadOnlyDirectory readOnlyDirectory) throws DuplicateObjectException {
        return this.addCopyFiles(readOnlyDirectory.getFilesRecursive());
    }

    public List addCopyFiles(List list) throws DuplicateObjectException {
        this.getFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < list.size()) {
            File file = (File)list.get(n);
            this.checkAddValid(file);
            arrayList.add(this.copy(file));
            ++n;
        }
        this.getFiles().addAll(arrayList);
        return arrayList;
    }

    public void addOrReplaceMofResource(Resource resource) {
        this.getLoadStrategy().addOrReplaceMofResource(resource);
    }

    public boolean canClose() {
        return !this.getCommonArchiveFactory().getOpenArchivesDependingOn(this).isEmpty();
    }

    protected void checkAddValid(File file) throws DuplicateObjectException {
        this.checkAddValid(file.getURI());
    }

    protected void checkAddValid(String string) throws DuplicateObjectException {
        try {
            File file = this.getFile(string);
            if (file != null) {
                throw new DuplicateObjectException(ResourceHandler.getString("duplicate_file_EXC_", new Object[]{this.getURI(), string}), file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    protected void cleanupAfterTempSave(String string, java.io.File file, java.io.File file2) throws SaveFailureException {
        this.checkWriteable(file);
        boolean bl = false;
        if (file.isDirectory() && !this.isRenameable(file)) {
            throw new SaveFailureException(ResourceHandler.getString("unable_replace_EXC_", new Object[]{file.getAbsolutePath()}));
        }
        int n = 0;
        while (n < 10) {
            if (ArchiveUtil.delete(file)) {
                bl = true;
                break;
            }
            try {
                Revisit.revisit();
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < 10) {
                if (file2.renameTo(file)) {
                    return;
                }
                try {
                    Revisit.revisit();
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        throw new SaveFailureException(ResourceHandler.getString("unable_replace_EXC_", new Object[]{file.getAbsolutePath()}));
    }

    public void close() {
        this.getLoadStrategy().close();
        this.releaseClassLoader();
        this.getCommonArchiveFactory().archiveClosed(this);
        if (this.isIndexed()) {
            List list = this.getArchiveFiles();
            int n = 0;
            while (n < list.size()) {
                ((Archive)list.get(n)).close();
                ++n;
            }
        }
    }

    protected File copy(File file) {
        File file2 = null;
        file2 = file.isArchive() ? this.getCommonArchiveFactory().copy((Archive)file) : (File)EtoolsCopyUtility.createCopy((EObject)file);
        return file2;
    }

    protected LoadStrategy createLoadStrategyForReopen(Archive archive) throws IOException {
        LoadStrategy loadStrategy = null;
        LooseArchive looseArchive = this.getLoadStrategy().getLooseArchive();
        if (looseArchive != null) {
            loadStrategy = this.getCommonArchiveFactory().createLoadStrategy(looseArchive.getBinariesPath());
            loadStrategy.setLooseArchive(looseArchive);
        } else {
            loadStrategy = archive == null ? this.getCommonArchiveFactory().createLoadStrategy(this.getURI()) : this.getCommonArchiveFactory().createChildLoadStrategy(this.getURI(), archive.getLoadStrategy());
        }
        return loadStrategy;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String string) {
        RuntimeClasspathEntryImpl runtimeClasspathEntryImpl = new RuntimeClasspathEntryImpl();
        runtimeClasspathEntryImpl.setAbsolutePath(string);
        return runtimeClasspathEntryImpl;
    }

    protected List createRuntimeClasspathEntries(String[] stringArray, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                Object object;
                String string2 = stringArray[n];
                Archive archive = this.resolveClasspathEntryInEAR(string2);
                if (archive != null) {
                    try {
                        object = this.createRuntimeClasspathEntry(archive.getBinariesPath(), string2);
                        object.setReferencedArchive(archive);
                        arrayList.add(object);
                        break block6;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                object = new java.io.File(string2);
                String string3 = null;
                if (((java.io.File)object).isAbsolute()) {
                    string3 = ((java.io.File)object).getAbsolutePath();
                } else {
                    string3 = ArchiveUtil.getOSUri(string, string2);
                    string3 = ClasspathUtil.normalizePath(string3);
                }
                arrayList.add(this.createRuntimeClasspathEntry(string3, string2));
            }
            ++n;
        }
        return arrayList;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String string, String string2) {
        RuntimeClasspathEntry runtimeClasspathEntry = this.createRuntimeClasspathEntry(string);
        runtimeClasspathEntry.setManifestValue(string2);
        return runtimeClasspathEntry;
    }

    protected SaveStrategy createSaveStrategyForDirectory(java.io.File file, int n) {
        return new DirectorySaveStrategyImpl(file.getAbsolutePath(), n);
    }

    protected SaveStrategy createSaveStrategyForDirectory(String string, int n) {
        return new DirectorySaveStrategyImpl(string, n);
    }

    protected SaveStrategy createSaveStrategyForJar(java.io.File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            throw new IOException(ResourceHandler.getString("file_exist_as_dir_EXC_", new Object[]{file.getAbsolutePath()}));
        }
        java.io.File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return new ZipStreamSaveStrategyImpl(fileOutputStream);
    }

    public void extract(int n) throws SaveFailureException, ReopenException {
        this.extractNoReopen(n);
        this.reopen();
    }

    public void extractNoReopen(int n) throws SaveFailureException {
        String string = this.getURI();
        java.io.File file = new java.io.File(string);
        boolean bl = this.getLoadStrategy().isUsing(file);
        try {
            java.io.File file2 = bl ? ArchiveUtil.createTempDirectory(string, file.getCanonicalFile().getParentFile()) : file;
            SaveStrategy saveStrategy = this.createSaveStrategyForDirectory(file2, n);
            this.save(saveStrategy);
            saveStrategy.close();
            this.close();
            if (bl) {
                this.cleanupAfterTempSave(string, file, file2);
            }
        }
        catch (IOException iOException) {
            throw new SaveFailureException(ResourceHandler.getString("error_saving_EXC_", new Object[]{string}), iOException);
        }
    }

    public void extractTo(String string, int n) throws SaveFailureException {
        java.io.File file = new java.io.File(string);
        if (this.getLoadStrategy().isUsing(file)) {
            throw new SaveFailureException(ResourceHandler.getString("Extract_destination_is_the_EXC_"));
        }
        try {
            SaveStrategy saveStrategy = this.createSaveStrategyForDirectory(file, n);
            this.save(saveStrategy);
            saveStrategy.close();
        }
        catch (IOException iOException) {
            throw new SaveFailureException(ResourceHandler.getString("error_saving_EXC_", new Object[]{string}), iOException);
        }
    }

    public List filterFilesByPrefix(String string) {
        return this.filterFiles(string, null);
    }

    public List filterFiles(String string, String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (!file.isDirectoryEntry() && file.getURI().startsWith(string) && (stringArray == null || this.hasSuffix(file.getURI(), stringArray))) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    private boolean hasSuffix(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.endsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public List filterFilesWithoutPrefix(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (!file.isDirectoryEntry()) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (file.getURI().startsWith(stringArray[n2])) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    arrayList.add(file);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public ClassLoader getArchiveClassLoader() {
        if (this.archiveClassLoader == null) {
            this.initializeClassLoader();
        }
        return this.archiveClassLoader;
    }

    public List getArchiveFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.isArchive()) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    protected ClassLoader getClassPathClassLoader(ClassLoader classLoader) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getManifest() != null) {
            arrayList.addAll(Arrays.asList(this.getManifest().getClassPathTokenized()));
        }
        if ((string = this.getExtraClasspath()) != null) {
            arrayList.addAll(Arrays.asList(ArchiveUtil.getTokens(string, ";")));
        }
        URL[] uRLArray = ArchiveUtil.toLocalURLs(arrayList, this.getRootForRelativeDependentJars());
        return new URLClassLoader(uRLArray, classLoader);
    }

    public ResourceSet getResourceSet() {
        return this.getLoadStrategy().getResourceSet();
    }

    protected ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    public Set getDependentOpenArchives() {
        return this.getCommonArchiveFactory().getOpenArchivesDependingOn(this);
    }

    protected List getEntriesAsAbsolutePaths(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                java.io.File file;
                String string2 = stringArray[n];
                Archive archive = this.resolveClasspathEntryInEAR(string2);
                if (archive != null) {
                    try {
                        arrayList.add(archive.getAbsolutePath());
                        break block6;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if ((file = new java.io.File(string2)).isAbsolute()) {
                    arrayList.add(file.getAbsolutePath());
                } else {
                    arrayList.add(ArchiveUtil.getOSUri(string, string2));
                }
            }
            ++n;
        }
        return arrayList;
    }

    public String getExtraClasspath() {
        return this.extraClasspath;
    }

    public FileIterator getFilesForSave() throws IOException {
        return this.getLoadStrategy().getFileIterator();
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (this.getLoadingContainer() != null || this.getLoadStrategy() == null || this.getLoadStrategy().isDirectory()) {
            return super.getInputStream();
        }
        if (this.isModuleFile() || !this.getOptions().isSaveLibrariesAsFiles()) {
            throw new IOException("Undefined state of nested archive");
        }
        EList eList = this.getFiles();
        String string = null;
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (!file.isArchive()) {
                string = file.getLoadingContainer().getAbsolutePath();
            }
            ++n;
        }
        return new FileInputStream(string);
    }

    public InputStream getResourceInputStream(String string) throws IOException {
        return this.getLoadStrategy().getResourceInputStream(string);
    }

    protected JavaJDKAdapterFactory getJavaAdapterFactory() {
        return (JavaJDKAdapterFactory)EcoreUtil.getAdapterFactory((List)this.getLoadStrategy().getResourceSet().getAdapterFactories(), (Object)"JavaReflection");
    }

    public Collection getLoadedMofResources() {
        return this.getLoadStrategy().getLoadedMofResources();
    }

    /*
     * Unable to fully structure code
     */
    public ArchiveManifest getManifest() {
        block18: {
            if (this.manifest == null) {
                var1_1 = null;
                try {
                    var1_1 = this.getInputStream("META-INF/MANIFEST.MF");
                    this.makeManifest(var1_1);
                    var6_2 = null;
                    ** if (var1_1 == null) goto lbl-1000
                }
                catch (Throwable var5_14) {
                    var6_5 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (IOException var7_9) {
                            // empty catch block
                        }
                    }
                    throw var5_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var7_6) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (FileNotFoundException var2_10) {
                        this.makeManifest();
                        var6_3 = null;
                        if (var1_1 != null) {
                            try {
                                var1_1.close();
                            }
                            catch (IOException var7_7) {}
                        }
                        break block18;
                    }
                    catch (Resource.IOWrappedException var3_11) {
                        var4_12 = new WrappedException(var3_11.getWrappedException());
                        if (!ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(var4_12)) {
                            throw new ManifestException(ResourceHandler.getString("io_ex_manifest_EXC_", new Object[]{this.getURI()}), (Exception)var3_11);
                        }
                        this.makeManifest();
                        var6_4 = null;
                        if (var1_1 != null) {
                            try {
                                var1_1.close();
                            }
                            catch (IOException var7_8) {}
                        }
                        break block18;
                    }
                    catch (IOException var4_13) {
                        throw new ManifestException(ResourceHandler.getString("io_ex_manifest_EXC_", new Object[]{this.getURI()}), var4_13);
                    }
                }
            }
        }
        if (this.manifest.getManifestVersion() == null || this.manifest.getManifestVersion().equals("")) {
            this.manifest.setManifestVersion("1.0");
        }
        return this.manifest;
    }

    public Resource getMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        return this.getLoadStrategy().getMofResource(string);
    }

    protected Resource getMofResourceMakeIfNecessary(String string) {
        if (this.getLoadStrategy() == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this.getMofResource(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                resource = this.makeMofResource(string);
            }
            catch (DuplicateObjectException duplicateObjectException) {}
        }
        return resource;
    }

    public ArchiveOptions getOptions() {
        if (this.options == null) {
            this.options = new ArchiveOptions();
        }
        return this.options;
    }

    public String getRootForRelativeDependentJars() {
        String string = null;
        Container container = this;
        while (container != null && string == null) {
            try {
                string = container.getAbsolutePath();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            container = container.getLoadingContainer();
        }
        if (string == null) {
            string = System.getProperty("user.dir");
            if (string == null) {
                return "";
            }
            return new java.io.File(string).getAbsolutePath();
        }
        return new java.io.File(string).getParentFile().getAbsolutePath();
    }

    public String[] getRuntimeClassPath() {
        String string;
        try {
            string = this.getBinariesPath();
        }
        catch (IOException iOException) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        String string2 = new java.io.File(string).getParentFile().getAbsolutePath();
        String[] stringArray = this.getManifest().getClassPathTokenized();
        arrayList.addAll(this.getEntriesAsAbsolutePaths(stringArray, string2));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public SaveFilter getSaveFilter() {
        return this.saveFilter;
    }

    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public void initializeAfterOpen() {
    }

    public void initializeClassLoader() {
        if (!this.shouldUseJavaReflection()) {
            return;
        }
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = this.getDefaultClassLoader();
        if (this.getContainer() == null || !this.getContainer().isEARFile()) {
            classLoader = this.getClassPathClassLoader(classLoader2);
        }
        ClassLoader classLoader3 = this.createDynamicClassLoader(classLoader2, classLoader);
        this.setArchiveClassLoader(classLoader3);
        JavaJDKAdapterFactory javaJDKAdapterFactory = this.getJavaAdapterFactory();
        javaJDKAdapterFactory.setContextClassLoader(classLoader3);
        javaJDKAdapterFactory.flushAll();
    }

    public ClassLoader createDynamicClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        return new ArchiveFileDynamicClassLoader(this, classLoader, classLoader2);
    }

    public boolean isArchive() {
        return true;
    }

    public boolean isDuplicate(String string) {
        return this.containsFile(string) || this.isMofResourceLoaded(string) || "META-INF/MANIFEST.MF".equals(string);
    }

    public boolean isManifestSet() {
        return this.manifest != null;
    }

    public boolean isMofResourceLoaded(String string) {
        return this.getLoadStrategy().isMofResourceLoaded(string);
    }

    public boolean isNestedArchive(String string) {
        String string2;
        if (this.getLoadStrategy().isDirectory()) {
            try {
                string2 = ArchiveUtil.getOSUri(this.getAbsolutePath(), string);
                java.io.File file = new java.io.File(string2);
                if (!file.exists() || file.isDirectory() && string.startsWith("ALT-INF")) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return (string2 = string.toLowerCase()).endsWith(".ear") || string2.endsWith(".war") || string2.endsWith(".jar") || string2.endsWith(".zip") || string2.endsWith(".far");
    }

    public boolean isOpen() {
        return this.getLoadStrategy() != null && this.getLoadStrategy().isOpen();
    }

    public ArchiveManifest makeManifest() {
        ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl();
        this.setManifest(archiveManifestImpl);
        return archiveManifestImpl;
    }

    public ArchiveManifest makeManifest(InputStream inputStream) throws IOException {
        ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl(inputStream);
        this.setManifest(archiveManifestImpl);
        return archiveManifestImpl;
    }

    public Resource makeMofResource(String string) throws DuplicateObjectException {
        return this.makeMofResource(string, null);
    }

    public Resource makeMofResource(String string, EList eList) throws DuplicateObjectException {
        if (this.isDuplicate(string)) {
            throw new DuplicateObjectException(ResourceHandler.getString("duplicate_entry_EXC_", new Object[]{string, this.getURI()}));
        }
        return this.getLoadStrategy().makeMofResource(string, eList);
    }

    public Archive openNestedArchive(String string) throws OpenFailureException {
        return this.getCommonArchiveFactory().openNestedArchive(string, (Archive)this);
    }

    public Archive openNestedArchive(LooseArchive looseArchive) throws OpenFailureException {
        return this.getCommonArchiveFactory().openNestedArchive(looseArchive, (Archive)this);
    }

    public void primSetExtraClasspath(String string) {
        this.extraClasspath = string;
    }

    public void releaseClassLoader() {
        if (this.archiveClassLoader != null) {
            this.setArchiveClassLoader(null);
            this.getJavaAdapterFactory().setContextClassLoader(null);
        }
    }

    public void remove(File file) {
        this.getFiles().remove((Object)file);
    }

    public void reopen() throws ReopenException {
        this.reopen(null);
    }

    public void reopen(Archive archive) throws ReopenException {
        LoadStrategy loadStrategy = null;
        try {
            loadStrategy = this.createLoadStrategyForReopen(archive);
        }
        catch (IOException iOException) {
            throw new ReopenException(ResourceHandler.getString("io_ex_reopen_EXC_", new Object[]{this.getURI()}), iOException);
        }
        LoadStrategy loadStrategy2 = this.getLoadStrategy();
        if (loadStrategy2 != null) {
            loadStrategy.setResourceSet(loadStrategy2.primGetResourceSet());
        }
        this.setLoadStrategy(loadStrategy);
        this.initializeClassLoader();
        if (!this.isIndexed()) {
            return;
        }
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            file.setOriginalURI(file.getURI());
            file.setLoadingContainer(this);
            if (file.isArchive()) {
                ((Archive)file).reopen(this);
            }
            ++n;
        }
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected void replaceRoot(Resource resource, EObject eObject) {
        if (resource == null) {
            return;
        }
        EList eList = resource.getContents();
        EObject eObject2 = null;
        if (!eList.isEmpty()) {
            eObject2 = (EObject)eList.get(0);
            if (eObject2 == eObject) {
                return;
            }
            eList.remove(0);
        }
        if (eObject != null) {
            eList.add(0, (Object)eObject);
        }
    }

    protected Archive resolveClasspathEntryInEAR(String string) {
        Container container = this.getContainer();
        if (container == null || !container.isEARFile()) {
            return null;
        }
        String string2 = ArchiveUtil.deriveEARRelativeURI(string, this);
        if (string2 == null) {
            return null;
        }
        File file = null;
        try {
            file = container.getFile(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return file.isArchive() ? (Archive)file : null;
    }

    public void save() throws SaveFailureException, ReopenException {
        this.saveAs(this.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(SaveStrategy saveStrategy) throws SaveFailureException {
        this.setSaveStrategy(saveStrategy);
        SaveFilter saveFilter = saveStrategy.getFilter();
        boolean bl = this.eDeliver();
        try {
            if (this.getOptions().isReadOnly()) {
                this.eSetDeliver(false);
            }
            saveStrategy.setFilter(this.getSaveFilter());
            saveStrategy.save();
            try {
                saveStrategy.finish();
            }
            catch (IOException iOException) {
                throw new SaveFailureException(this.getURI(), iOException);
            }
        }
        finally {
            if (this.getOptions().isReadOnly() && !this.getLoadStrategy().isDirectory()) {
                this.files.clear();
                this.eSetDeliver(bl);
                this.eAdapters().remove((Object)this.getFileIndexAdapter());
                this.fileIndexAdapter = null;
                this.fileIndex = null;
            }
            this.setSaveStrategy(null);
            saveStrategy.setFilter(saveFilter);
        }
    }

    public void saveAs(String string) throws SaveFailureException, ReopenException {
        this.saveAsNoReopen(string);
        this.reopen();
    }

    protected boolean isRenameable(java.io.File file) {
        java.io.File file2 = null;
        java.io.File file3 = null;
        try {
            file2 = file.getCanonicalFile();
            file3 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        String string = null;
        String string2 = "save.tmp";
        try {
            if (file.getParent() != null) {
                string2 = new java.io.File(file.getParent(), string2).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        java.io.File file4 = null;
        int n = 0;
        do {
            string = string2 + n;
            file4 = new java.io.File(string);
            ++n;
        } while (file4.exists());
        return file2.renameTo(file4) && file4.renameTo(file3);
    }

    protected void checkWriteable(java.io.File file) throws SaveFailureException {
        List list = ArchiveUtil.getWriteProtectedFiles(file, null);
        if (list.isEmpty()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cannot write to file: ");
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append('\n');
        stringBuffer.append("One or more files is write protected or locked:");
        stringBuffer.append('\n');
        int n = 0;
        while (n < list.size()) {
            java.io.File file2 = (java.io.File)list.get(n);
            stringBuffer.append(file2.getAbsolutePath());
            stringBuffer.append('\n');
            ++n;
        }
        throw new SaveFailureException(stringBuffer.toString());
    }

    public void saveAsNoReopen(String string) throws SaveFailureException {
        java.io.File file = new java.io.File(string);
        this.checkWriteable(file);
        boolean bl = file.exists();
        SaveStrategy saveStrategy = null;
        try {
            try {
                java.io.File file2 = bl ? ArchiveUtil.createTempFile(string, file.getCanonicalFile().getParentFile()) : file;
                saveStrategy = this.createSaveStrategyForJar(file2);
                this.save(saveStrategy);
                saveStrategy.close();
                this.close();
                if (bl) {
                    this.cleanupAfterTempSave(string, file, file2);
                }
            }
            catch (IOException iOException) {
                throw new SaveFailureException(ResourceHandler.getString("error_saving_EXC_", new Object[]{string}), iOException);
            }
        }
        catch (SaveFailureException saveFailureException) {
            try {
                if (saveStrategy != null) {
                    saveStrategy.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                file.delete();
            }
            throw saveFailureException;
        }
        this.setURI(string);
    }

    public void saveNoReopen() throws SaveFailureException {
        this.saveAsNoReopen(this.getURI());
    }

    public void setArchiveClassLoader(ClassLoader classLoader) {
        this.archiveClassLoader = classLoader;
    }

    public void setExtraClasspath(String string) {
        this.primSetExtraClasspath(string);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setManifest(ArchiveManifest archiveManifest) {
        this.manifest = archiveManifest;
    }

    public void setManifest(Manifest manifest) {
        this.setManifest(new ArchiveManifestImpl(manifest));
    }

    public void setManifestClassPathAndRefresh(String string) {
        ArchiveManifest archiveManifest = this.getManifest();
        if (this.manifest == null) {
            this.makeManifest();
        }
        archiveManifest.setClassPath(string);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setOptions(ArchiveOptions archiveOptions) {
        this.options = archiveOptions;
    }

    public void setSaveFilter(SaveFilter saveFilter) {
        this.saveFilter = saveFilter;
    }

    public void setSaveStrategy(SaveStrategy saveStrategy) {
        this.saveStrategy = saveStrategy;
        if (saveStrategy != null) {
            saveStrategy.setArchive(this);
        }
    }

    public void setXmlEncoding(String string) {
        this.xmlEncoding = string;
    }

    public boolean shouldUseJavaReflection() {
        return this.getOptions().useJavaReflection() && this.getLoadStrategy().isClassLoaderNeeded();
    }

    protected void throwResourceLoadException(String string, Exception exception) throws ResourceLoadException {
        throw new ResourceLoadException(ResourceHandler.getString("load_resource_EXC_", new Object[]{string, this.getURI()}), exception);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLoadStrategy().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        return this.getLoadStrategy().getBinariesPath();
    }

    protected RuntimeClasspathEntry[] emptyClasspath() {
        return new RuntimeClasspathEntry[0];
    }

    protected String internalGetBinariesPath() {
        try {
            return this.getBinariesPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String string = this.internalGetBinariesPath();
        if (string == null) {
            return this.emptyClasspath();
        }
        return new RuntimeClasspathEntry[]{this.createRuntimeClasspathEntry(string)};
    }

    protected RuntimeClasspathEntry[] getDependencyClassPathAtThisLevel() {
        String string = this.internalGetBinariesPath();
        if (string == null) {
            return this.emptyClasspath();
        }
        String string2 = new java.io.File(string).getParentFile().getAbsolutePath();
        String[] stringArray = this.getManifest().getClassPathTokenized();
        if (stringArray.length == 0) {
            return this.emptyClasspath();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.createRuntimeClasspathEntries(stringArray, string2));
        return arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
    }

    public RuntimeClasspathEntry[] getFullRuntimeClassPath() {
        return this.concat(this.getLocalRuntimeClassPath(), this.getDependencyClassPath());
    }

    protected RuntimeClasspathEntry[] concat(RuntimeClasspathEntry[] runtimeClasspathEntryArray, RuntimeClasspathEntry[] runtimeClasspathEntryArray2) {
        ArrayList<RuntimeClasspathEntry> arrayList = new ArrayList<RuntimeClasspathEntry>();
        arrayList.addAll(Arrays.asList(runtimeClasspathEntryArray));
        arrayList.addAll(Arrays.asList(runtimeClasspathEntryArray2));
        return arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
    }

    public RuntimeClasspathEntry[] getDependencyClassPath() {
        ArrayList arrayList = new ArrayList();
        HashSet<ArchiveImpl> hashSet = new HashSet<ArchiveImpl>();
        HashSet hashSet2 = new HashSet();
        hashSet.add(this);
        this.getDependencyClassPath(hashSet, arrayList, hashSet2, this);
        return arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
    }

    protected void getDependencyClassPath(Set set, List list, Set set2, Archive archive) {
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = ((ArchiveImpl)archive).getDependencyClassPathAtThisLevel();
        int n = 0;
        while (n < runtimeClasspathEntryArray.length) {
            Archive archive2;
            RuntimeClasspathEntry runtimeClasspathEntry = runtimeClasspathEntryArray[n];
            if (!set2.contains(runtimeClasspathEntry)) {
                list.add(runtimeClasspathEntry);
                set2.add(runtimeClasspathEntry);
            }
            if ((archive2 = runtimeClasspathEntry.getReferencedArchive()) == null) {
                ClasspathUtil.processManifest(runtimeClasspathEntry.getAbsolutePath(), list, set2);
            } else if (!set.contains(archive2)) {
                set.add(archive2);
                this.getDependencyClassPath(set, list, set2, archive2);
            }
            ++n;
        }
    }

    protected EARFile getEARFile() {
        Container container = this.getContainer();
        if (container == null || !(container instanceof EARFile)) {
            return null;
        }
        return (EARFile)container;
    }

    protected Archive getResolvedArchive(String string, EARFile eARFile) {
        String string2 = ArchiveUtil.deriveEARRelativeURI(string, this);
        if (string2 == null) {
            return null;
        }
        try {
            return (Archive)eARFile.getFile(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public boolean hasClasspathVisibilityTo(Archive archive) {
        if (archive == null) {
            return false;
        }
        EARFile eARFile = this.getEARFile();
        if (eARFile == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        return this.hasClasspathVisibilityTo(archive, hashSet, eARFile);
    }

    public boolean hasClasspathVisibilityTo(Archive archive, Set set, EARFile eARFile) {
        if (this == archive) {
            return true;
        }
        if (set.contains(this)) {
            return false;
        }
        set.add(this);
        String[] stringArray = this.getManifest().getClassPathTokenized();
        int n = 0;
        while (n < stringArray.length) {
            Archive archive2 = this.getResolvedArchive(stringArray[n], eARFile);
            if (archive2 != null && archive2.hasClasspathVisibilityTo(archive, set, eARFile)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

