/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.impl;

import com.ibm.etools.archive.ArchiveTypeDiscriminator;
import com.ibm.etools.archive.DirectoryArchiveLoadStrategy;
import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.archive.ejb10.EJBJar10ImportStrategyImpl;
import com.ibm.etools.archive.exception.OpenFailureException;
import com.ibm.etools.archive.impl.AppClient12ImportStrategyImpl;
import com.ibm.etools.archive.impl.ArchiveOptions;
import com.ibm.etools.archive.impl.DirectoryArchiveLoadStrategyImpl;
import com.ibm.etools.archive.impl.Ear12ImportStrategyImpl;
import com.ibm.etools.archive.impl.EjbJar11ImportStrategyImpl;
import com.ibm.etools.archive.impl.FARFileDiscriminatorImpl;
import com.ibm.etools.archive.impl.NestedArchiveLoadStrategyImpl;
import com.ibm.etools.archive.impl.NullLoadStrategyImpl;
import com.ibm.etools.archive.impl.RarImportStrategyImpl;
import com.ibm.etools.archive.impl.ReadOnlyDirectoryLoadStrategyImpl;
import com.ibm.etools.archive.impl.TempZipFileLoadStrategyImpl;
import com.ibm.etools.archive.impl.War22ImportStrategyImpl;
import com.ibm.etools.archive.impl.ZipFileLoadStrategyImpl;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.ClientModuleRef;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.ConnectorModuleRef;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBClientJarFile;
import com.ibm.etools.commonarchive.EJBComponent;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.FARFile;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.ModuleComponent;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.ReadOnlyDirectory;
import com.ibm.etools.commonarchive.ServletComponent;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.etools.commonarchive.impl.ApplicationClientFileImpl;
import com.ibm.etools.commonarchive.impl.ArchiveCopyUtility;
import com.ibm.etools.commonarchive.impl.ArchiveImpl;
import com.ibm.etools.commonarchive.impl.ClientModuleRefImpl;
import com.ibm.etools.commonarchive.impl.ConnectorModuleRefImpl;
import com.ibm.etools.commonarchive.impl.EARFileImpl;
import com.ibm.etools.commonarchive.impl.EJBClientJarFileImpl;
import com.ibm.etools.commonarchive.impl.EJBComponentImpl;
import com.ibm.etools.commonarchive.impl.EJBJarFileImpl;
import com.ibm.etools.commonarchive.impl.EJBModuleRefImpl;
import com.ibm.etools.commonarchive.impl.FARFileImpl;
import com.ibm.etools.commonarchive.impl.FileImpl;
import com.ibm.etools.commonarchive.impl.ModuleComponentImpl;
import com.ibm.etools.commonarchive.impl.RARFileImpl;
import com.ibm.etools.commonarchive.impl.ReadOnlyDirectoryImpl;
import com.ibm.etools.commonarchive.impl.RootArchiveTypeDescriminatorImpl;
import com.ibm.etools.commonarchive.impl.RootEJBJarDescriminatorImpl;
import com.ibm.etools.commonarchive.impl.ServletComponentImpl;
import com.ibm.etools.commonarchive.impl.WARFileImpl;
import com.ibm.etools.commonarchive.impl.WebModuleRefImpl;
import com.ibm.etools.commonarchive.init.ArchiveInit;
import com.ibm.etools.commonarchive.looseconfig.LooseArchive;
import com.ibm.etools.j2ee.common.XMLResource;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;

public class CommonarchiveFactoryImpl
extends EFactoryImpl
implements CommonarchiveFactory {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Map openArchives;

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createFile();
            }
            case 1: {
                return this.createArchive();
            }
            case 2: {
                return this.createEJBJarFile();
            }
            case 3: {
                return this.createWARFile();
            }
            case 4: {
                return this.createEARFile();
            }
            case 5: {
                return this.createApplicationClientFile();
            }
            case 6: {
                return this.createEJBClientJarFile();
            }
            case 8: {
                return this.createServletComponent();
            }
            case 9: {
                return this.createEJBComponent();
            }
            case 10: {
                return this.createModuleComponent();
            }
            case 12: {
                return this.createReadOnlyDirectory();
            }
            case 13: {
                return this.createRARFile();
            }
            case 15: {
                return this.createEJBModuleRef();
            }
            case 16: {
                return this.createWebModuleRef();
            }
            case 17: {
                return this.createClientModuleRef();
            }
            case 18: {
                return this.createConnectorModuleRef();
            }
            case 19: {
                return this.createFARFile();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public void archiveClosed(Archive archive) {
        this.getOpenArchives().remove(archive);
    }

    public void archiveOpened(Archive archive) {
        this.getOpenArchives().put(archive, null);
    }

    public boolean canClose(Archive archive) {
        return !this.getOpenArchivesDependingOn(archive).isEmpty();
    }

    public void closeOpenArchives() {
        if (this.getOpenArchives().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.getOpenArchives().size());
        Iterator iterator = this.getOpenArchives().keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        int n = 0;
        while (n < arrayList.size()) {
            Archive archive = (Archive)arrayList.get(n);
            archive.close();
            ++n;
        }
    }

    public Archive copy(Archive archive) {
        return new ArchiveCopyUtility().copy(archive);
    }

    public EJBComponent copy(EJBComponent eJBComponent) {
        ArchiveCopyUtility archiveCopyUtility = new ArchiveCopyUtility();
        archiveCopyUtility.copy((EObject)eJBComponent.getDeploymentDescriptor());
        archiveCopyUtility.copy((EObject)eJBComponent.getBindings());
        archiveCopyUtility.copy((EObject)eJBComponent.getExtensions());
        return (EJBComponent)archiveCopyUtility.copy(eJBComponent);
    }

    public ModuleComponent copy(ModuleComponent moduleComponent) {
        if (moduleComponent.isEJB()) {
            return this.copy((EJBComponent)moduleComponent);
        }
        if (moduleComponent.isServlet()) {
            return this.copy((ServletComponent)moduleComponent);
        }
        return null;
    }

    public ModuleFile copy(ModuleFile moduleFile) {
        ModuleFile moduleFile2;
        block2: {
            moduleFile2 = new ArchiveCopyUtility().copy(moduleFile);
            if (moduleFile2 == null) break block2;
            try {
                XMLResource xMLResource = (XMLResource)moduleFile.getDeploymentDescriptorResource();
                XMLResource xMLResource2 = (XMLResource)moduleFile2.getDeploymentDescriptorResource();
                xMLResource2.setPublicId(xMLResource.getPublicId());
                xMLResource2.setSystemId(xMLResource.getSystemId());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return moduleFile2;
    }

    public ServletComponent copy(ServletComponent servletComponent) {
        ArchiveCopyUtility archiveCopyUtility = new ArchiveCopyUtility();
        archiveCopyUtility.copy((EObject)servletComponent.getDeploymentDescriptor());
        archiveCopyUtility.copy((EObject)servletComponent.getExtensions());
        return (ServletComponent)archiveCopyUtility.copy(servletComponent);
    }

    public ApplicationClientFile createApplicationClientFileInitialized(String string) {
        ApplicationClientFile applicationClientFile = this.createApplicationClientFile();
        this.initializeNewApplicationClientFile(applicationClientFile, string);
        return applicationClientFile;
    }

    public Archive createArchiveInitialized(String string) {
        Archive archive = this.createArchive();
        this.initializeNewArchive(archive, string);
        return archive;
    }

    public LoadStrategy createChildLoadStrategy(String string, LoadStrategy loadStrategy) throws IOException, FileNotFoundException {
        LoadStrategy loadStrategy2 = null;
        if (loadStrategy.isDirectory()) {
            String string2 = ((DirectoryArchiveLoadStrategy)loadStrategy).getDirectoryUri();
            String string3 = ArchiveUtil.getOSUri(string2, string);
            loadStrategy2 = this.createLoadStrategy(string3);
        } else {
            loadStrategy2 = this.createNestedLoadStrategy(string, loadStrategy);
        }
        return loadStrategy2;
    }

    public EARFile createEARFileInitialized(String string) {
        EARFile eARFile = this.createEARFile();
        this.initializeNewEARFile(eARFile, string);
        return eARFile;
    }

    public EJBJarFile createEJBJarFileInitialized(String string) {
        EJBJarFile eJBJarFile = this.createEJBJarFile();
        this.initializeNewEJBJarFile(eJBJarFile, string);
        return eJBJarFile;
    }

    public LoadStrategy createEmptyLoadStrategy() {
        return new NullLoadStrategyImpl();
    }

    public LoadStrategy createLoadStrategy(String string) throws FileNotFoundException, IOException {
        String string2 = string.replace('/', java.io.File.separatorChar);
        java.io.File file = new java.io.File(string2);
        if (!file.exists()) {
            throw new FileNotFoundException(ResourceHandler.getString("file_not_found_EXC_", new Object[]{string, file.getAbsolutePath()}));
        }
        if (file.isDirectory()) {
            return new DirectoryArchiveLoadStrategyImpl(string);
        }
        return new ZipFileLoadStrategyImpl(file);
    }

    public LoadStrategy createNestedLoadStrategy(String string, LoadStrategy loadStrategy) {
        LoadStrategy loadStrategy2 = null;
        ArchiveOptions archiveOptions = ((Archive)loadStrategy.getContainer()).getOptions();
        if (!archiveOptions.isReadOnly(string)) {
            loadStrategy2 = this.createTempZipFileStrategyIfPossible(string, loadStrategy);
        }
        if (loadStrategy2 == null) {
            return new NestedArchiveLoadStrategyImpl(loadStrategy);
        }
        return loadStrategy2;
    }

    public RARFile createRARFileInitialized(String string) {
        RARFile rARFile = this.createRARFile();
        this.initializeNewRARFile(rARFile, string);
        return rARFile;
    }

    public LoadStrategy createTempZipFileStrategyIfPossible(String string, LoadStrategy loadStrategy) {
        if (!ArchiveUtil.shouldUseTempDirectoryForRead()) {
            return null;
        }
        try {
            java.io.File file = ArchiveUtil.createTempFile(string);
            file.deleteOnExit();
            InputStream inputStream = loadStrategy.getInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ArchiveUtil.copy(inputStream, fileOutputStream);
            return new TempZipFileLoadStrategyImpl(file);
        }
        catch (IOException iOException) {
            ArchiveUtil.inform(ResourceHandler.getString("make_temp_file_WARN_", new Object[]{string}) + iOException.getLocalizedMessage());
            return null;
        }
    }

    public WARFile createWARFileInitialized(String string) {
        WARFile wARFile = this.createWARFile();
        this.initializeNewWARFile(wARFile, string);
        return wARFile;
    }

    protected ArchiveOptions defaultOptions(LoadStrategy loadStrategy) {
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setLoadStrategy(loadStrategy);
        return archiveOptions;
    }

    public static CommonarchiveFactory getActiveFactory() {
        CommonarchivePackage commonarchivePackage = CommonarchiveFactoryImpl.getPackage();
        if (commonarchivePackage != null) {
            return commonarchivePackage.getCommonarchiveFactory();
        }
        return null;
    }

    public String[] getManifestClassPathValues(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        String[] stringArray = archive.getManifest().getClassPathTokenized();
        archive.close();
        return stringArray;
    }

    public Map getOpenArchives() {
        if (this.openArchives == null) {
            this.openArchives = new WeakHashMap();
        }
        return this.openArchives;
    }

    public Set getOpenArchivesDependingOn(Archive archive) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = this.getOpenArchives().keySet().iterator();
        while (iterator.hasNext()) {
            object = (Archive)iterator.next();
            if (object == archive || !object.isIndexed()) continue;
            EList eList = object.getFiles();
            int n = 0;
            while (n < eList.size()) {
                File file = (File)eList.get(n);
                if (file.getLoadingContainer() == archive) {
                    Object object2 = object;
                    Container container = object.getContainer();
                    while (container != null && container.isArchive()) {
                        object2 = (Archive)container;
                        container = container.getContainer();
                    }
                    hashSet.add(object2);
                }
                ++n;
            }
        }
        object = archive.getArchiveFiles();
        int n = 0;
        while (n < object.size()) {
            hashSet.addAll(this.getOpenArchivesDependingOn((Archive)object.get(n)));
            ++n;
        }
        return hashSet;
    }

    protected static void initPrereqs() {
        ArchiveInit.invokePrereqInits(true);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootArchiveTypeDescriminatorImpl.singleton();
        archiveTypeDiscriminator.addChild(Ear12ImportStrategyImpl.getDiscriminator());
        archiveTypeDiscriminator.addChild(War22ImportStrategyImpl.getDiscriminator());
        archiveTypeDiscriminator.addChild(AppClient12ImportStrategyImpl.getDiscriminator());
        archiveTypeDiscriminator.addChild(RarImportStrategyImpl.getDiscriminator());
        archiveTypeDiscriminator.addChild(RootEJBJarDescriminatorImpl.singleton());
        archiveTypeDiscriminator.addChild(FARFileDiscriminatorImpl.singleton());
    }

    public void initializeNewApplicationClientFile(ApplicationClientFile applicationClientFile, String string) {
        this.initializeNewModuleFile(applicationClientFile, string);
    }

    public void initializeNewArchive(Archive archive, String string) {
        archive.setURI(string);
        archive.setSize(0L);
        archive.setLastModified(System.currentTimeMillis());
        archive.setDirectoryEntry(false);
        archive.setLoadStrategy(this.createEmptyLoadStrategy());
    }

    public void initializeNewEARFile(EARFile eARFile, String string) {
        this.initializeNewModuleFile(eARFile, string);
    }

    public void initializeNewEJBJarFile(EJBJarFile eJBJarFile, String string) {
        this.initializeNewModuleFile(eJBJarFile, string);
    }

    public void initializeNewModuleFile(ModuleFile moduleFile, String string) {
        this.initializeNewArchive(moduleFile, string);
        moduleFile.makeDeploymentDescriptorResource();
    }

    public void initializeNewRARFile(RARFile rARFile, String string) {
        this.initializeNewModuleFile(rARFile, string);
    }

    public void initializeNewWARFile(WARFile wARFile, String string) {
        this.initializeNewModuleFile(wARFile, string);
    }

    private static void initializePkg() {
        CommonarchiveFactoryImpl.initPrereqs();
    }

    public boolean isEJB10JarFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        boolean bl = !EjbJar11ImportStrategyImpl.getDiscriminator().canImport(archive) && EJBJar10ImportStrategyImpl.getDiscriminator().canImport(archive);
        archive.close();
        return bl;
    }

    public ApplicationClientFile openApplicationClientFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = AppClient12ImportStrategyImpl.getDiscriminator();
        return (ApplicationClientFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public ApplicationClientFile openApplicationClientFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = AppClient12ImportStrategyImpl.getDiscriminator();
        return (ApplicationClientFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public ApplicationClientFile openApplicationClientFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = AppClient12ImportStrategyImpl.getDiscriminator();
        return (ApplicationClientFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public Archive openArchive(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String string, String string2) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        archive.setExtraClasspath(string2);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public EARFile openEARFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = Ear12ImportStrategyImpl.getDiscriminator();
        return (EARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EARFile openEARFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = Ear12ImportStrategyImpl.getDiscriminator();
        return (EARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EARFile openEARFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = Ear12ImportStrategyImpl.getDiscriminator();
        return (EARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJB11JarFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJB11JarFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJB11JarFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJBJarFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy loadStrategy, String string, String string2) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        archive.setExtraClasspath(string2);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(String string, String string2) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        archive.setExtraClasspath(string2);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public Archive openNestedArchive(LooseArchive looseArchive, Archive archive) throws OpenFailureException {
        String string = looseArchive.getUri();
        try {
            LoadStrategy loadStrategy = this.createLoadStrategy(looseArchive.getBinariesPath());
            loadStrategy.setLooseArchive(looseArchive);
            ArchiveOptions archiveOptions = archive.getOptions().cloneWith(loadStrategy, looseArchive.getUri());
            return this.primOpenArchive(archiveOptions, string);
        }
        catch (IOException iOException) {
            throw new OpenFailureException(ResourceHandler.getString("open_nested_EXC_", new Object[]{string, archive.getURI()}), iOException);
        }
    }

    public Archive openNestedArchive(String string, Archive archive) throws OpenFailureException {
        try {
            LoadStrategy loadStrategy = this.createChildLoadStrategy(string, archive.getLoadStrategy());
            ArchiveOptions archiveOptions = archive.getOptions().cloneWith(loadStrategy, string);
            if (archiveOptions.shouldDiscriminateNestedArchives()) {
                return this.openArchive(archiveOptions, string);
            }
            return this.primOpenArchive(archiveOptions, string);
        }
        catch (IOException iOException) {
            throw new OpenFailureException(ResourceHandler.getString("open_nested_EXC_", new Object[]{string, archive.getURI()}), iOException);
        }
    }

    public RARFile openRARFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public RARFile openRARFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public RARFile openRARFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public ReadOnlyDirectory openReadOnlyDirectory(String string) throws IOException {
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(ResourceHandler.getString("could_not_find_dir_EXC_", new Object[]{string}));
        }
        if (!file.isDirectory()) {
            throw new IOException(ResourceHandler.getString("not_a_dir_EXC_", new Object[]{string}));
        }
        ReadOnlyDirectoryLoadStrategyImpl readOnlyDirectoryLoadStrategyImpl = new ReadOnlyDirectoryLoadStrategyImpl(string);
        ReadOnlyDirectory readOnlyDirectory = this.createReadOnlyDirectory();
        readOnlyDirectory.setURI(string);
        readOnlyDirectory.setLoadStrategy(readOnlyDirectoryLoadStrategyImpl);
        readOnlyDirectory.setLastModified(file.lastModified());
        return readOnlyDirectory;
    }

    protected Archive openSpecificArchive(Archive archive, ArchiveTypeDiscriminator archiveTypeDiscriminator) throws OpenFailureException {
        if (!archiveTypeDiscriminator.canImport(archive)) {
            archive.close();
            throw new OpenFailureException(archiveTypeDiscriminator.getUnableToOpenMessage());
        }
        Archive archive2 = archiveTypeDiscriminator.openArchive(archive);
        archive2.initializeAfterOpen();
        return archive2;
    }

    protected Archive openSpecificArchive(Archive archive, RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl) throws OpenFailureException {
        Archive archive2 = this.openSpecificArchive(archive, (ArchiveTypeDiscriminator)rootEJBJarDescriminatorImpl);
        if (archive2 == archive) {
            archive.close();
            throw new OpenFailureException(rootEJBJarDescriminatorImpl.getUnableToOpenMessage());
        }
        return archive2;
    }

    public WARFile openWARFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = War22ImportStrategyImpl.getDiscriminator();
        return (WARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public WARFile openWARFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = War22ImportStrategyImpl.getDiscriminator();
        return (WARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public WARFile openWARFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = War22ImportStrategyImpl.getDiscriminator();
        return (WARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public Archive primOpenArchive(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        if (archiveOptions.getLoadStrategy() == null) {
            try {
                archiveOptions.setLoadStrategy(this.createLoadStrategy(string));
            }
            catch (IOException iOException) {
                throw new OpenFailureException(ResourceHandler.getString("could_not_open_EXC_", new Object[]{string}), iOException);
            }
        }
        Archive archive = this.createArchive();
        archive.setURI(string);
        archive.setOriginalURI(string);
        archive.setLoadStrategy(archiveOptions.getLoadStrategy());
        archive.setOptions(archiveOptions);
        return archive;
    }

    public Archive primOpenArchive(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        return this.primOpenArchive(this.defaultOptions(loadStrategy), string);
    }

    public Archive primOpenArchive(String string) throws OpenFailureException {
        return this.primOpenArchive(new ArchiveOptions(), string);
    }

    protected void setOpenArchives(Map map) {
        this.openArchives = map;
    }

    public EJBComponent createEJBComponent() {
        EJBComponentImpl eJBComponentImpl = new EJBComponentImpl();
        return eJBComponentImpl;
    }

    public ModuleComponent createModuleComponent() {
        ModuleComponentImpl moduleComponentImpl = new ModuleComponentImpl();
        return moduleComponentImpl;
    }

    public ServletComponent createServletComponent() {
        ServletComponentImpl servletComponentImpl = new ServletComponentImpl();
        return servletComponentImpl;
    }

    public WARFile createWARFile() {
        WARFileImpl wARFileImpl = new WARFileImpl();
        return wARFileImpl;
    }

    public EJBJarFile createEJBJarFile() {
        EJBJarFileImpl eJBJarFileImpl = new EJBJarFileImpl();
        return eJBJarFileImpl;
    }

    public ApplicationClientFile createApplicationClientFile() {
        ApplicationClientFileImpl applicationClientFileImpl = new ApplicationClientFileImpl();
        return applicationClientFileImpl;
    }

    public EARFile createEARFile() {
        EARFileImpl eARFileImpl = new EARFileImpl();
        return eARFileImpl;
    }

    public RARFile createRARFile() {
        RARFileImpl rARFileImpl = new RARFileImpl();
        return rARFileImpl;
    }

    public File createFile() {
        FileImpl fileImpl = new FileImpl();
        return fileImpl;
    }

    public EJBClientJarFile createEJBClientJarFile() {
        EJBClientJarFileImpl eJBClientJarFileImpl = new EJBClientJarFileImpl();
        return eJBClientJarFileImpl;
    }

    public ReadOnlyDirectory createReadOnlyDirectory() {
        ReadOnlyDirectoryImpl readOnlyDirectoryImpl = new ReadOnlyDirectoryImpl();
        return readOnlyDirectoryImpl;
    }

    public CommonarchivePackage getCommonarchivePackage() {
        return (CommonarchivePackage)this.getEPackage();
    }

    public static CommonarchivePackage getPackage() {
        return CommonarchivePackage.eINSTANCE;
    }

    public EJBModuleRef createEJBModuleRef() {
        EJBModuleRefImpl eJBModuleRefImpl = new EJBModuleRefImpl();
        return eJBModuleRefImpl;
    }

    public WebModuleRef createWebModuleRef() {
        WebModuleRefImpl webModuleRefImpl = new WebModuleRefImpl();
        return webModuleRefImpl;
    }

    public ClientModuleRef createClientModuleRef() {
        ClientModuleRefImpl clientModuleRefImpl = new ClientModuleRefImpl();
        return clientModuleRefImpl;
    }

    public ConnectorModuleRef createConnectorModuleRef() {
        ConnectorModuleRefImpl connectorModuleRefImpl = new ConnectorModuleRefImpl();
        return connectorModuleRefImpl;
    }

    public ClientModuleRef createClientModuleRef(ApplicationClientFile applicationClientFile) {
        ClientModuleRef clientModuleRef = this.createClientModuleRef();
        clientModuleRef.setModuleFile(applicationClientFile);
        return clientModuleRef;
    }

    public ConnectorModuleRef createConnectorModuleRef(RARFile rARFile) {
        ConnectorModuleRef connectorModuleRef = this.createConnectorModuleRef();
        connectorModuleRef.setModuleFile(rARFile);
        return connectorModuleRef;
    }

    public EJBModuleRef createEJBModuleRef(EJBJarFile eJBJarFile) {
        EJBModuleRef eJBModuleRef = this.createEJBModuleRef();
        eJBModuleRef.setModuleFile(eJBJarFile);
        return eJBModuleRef;
    }

    public WebModuleRef createWebModuleRef(WARFile wARFile) {
        WebModuleRef webModuleRef = this.createWebModuleRef();
        webModuleRef.setModuleFile(wARFile);
        return webModuleRef;
    }

    public Archive createArchive() {
        ArchiveImpl archiveImpl = new ArchiveImpl();
        return archiveImpl;
    }

    public FARFile createFARFile() {
        FARFileImpl fARFileImpl = new FARFileImpl();
        return fARFileImpl;
    }

    public FARFile createFARFileInitialized(String string) {
        FARFile fARFile = this.createFARFile();
        this.initializeNewArchive(fARFile, string);
        fARFile.makeDeploymentDescriptorResource();
        return fARFile;
    }

    public FARFile openFARFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        FARFileDiscriminatorImpl fARFileDiscriminatorImpl = FARFileDiscriminatorImpl.singleton();
        return (FARFile)this.openSpecificArchive(archive, fARFileDiscriminatorImpl);
    }

    public FARFile openFARFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        FARFileDiscriminatorImpl fARFileDiscriminatorImpl = FARFileDiscriminatorImpl.singleton();
        return (FARFile)this.openSpecificArchive(archive, fARFileDiscriminatorImpl);
    }

    static {
        CommonarchiveFactoryImpl.initializePkg();
    }
}

