/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.impl;

import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.impl.FileImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class ContainerImpl
extends FileImpl
implements Container {
    protected LoadStrategy loadStrategy;
    protected Map fileIndex;
    protected FileNotificationAdapter fileIndexAdapter;
    protected EList files = null;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$File;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$Container;

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getContainer();
    }

    public boolean containsFile(String string) {
        String string2;
        String string3 = string2 = string.startsWith("/") ? ArchiveUtil.truncateFromFrontIgnoreCase(string, "/") : string;
        if (this.isIndexed()) {
            return this.getFileIndex().containsKey(string2);
        }
        return this.getLoadStrategy().contains(string2);
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getLoadStrategy().getAbsolutePath();
    }

    public File getFile(String string) throws FileNotFoundException {
        File file;
        if (!this.isIndexed()) {
            this.getFiles();
        }
        if ((file = (File)this.getFileIndex().get(string)) == null) {
            throw new FileNotFoundException(string);
        }
        return file;
    }

    protected Map getFileIndex() {
        if (this.fileIndex == null) {
            this.getFileIndexAdapter().rebuildFileIndex();
        }
        return this.fileIndex;
    }

    protected FileNotificationAdapter getFileIndexAdapter() {
        if (this.fileIndexAdapter == null) {
            this.fileIndexAdapter = new FileNotificationAdapter();
            this.eAdapters().add((Object)this.fileIndexAdapter);
        }
        return this.fileIndexAdapter;
    }

    public EList getFiles() {
        EList eList = this.getFilesGen();
        if (!this.isIndexed()) {
            if (eList.isEmpty() && this.getLoadStrategy() != null) {
                eList.addAll((Collection)this.getLoadStrategy().collectFiles());
            }
            this.getFileIndex();
        }
        return eList;
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        if (this.isIndexed()) {
            return this.getFile(string).getInputStream();
        }
        return this.primGetInputStream(string);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean isIndexed() {
        return this.fileIndex != null;
    }

    public InputStream primGetInputStream(String string) throws IOException, FileNotFoundException {
        return this.getLoadStrategy().getInputStream(string);
    }

    public void rebuildFileIndex() {
        this.getFileIndexAdapter().rebuildFileIndex();
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
        if (loadStrategy != null) {
            loadStrategy.setContainer(this);
        }
    }

    public EList getFilesGen() {
        if (this.files == null) {
            this.files = new EObjectContainmentWithInverseEList(class$com$ibm$etools$commonarchive$File == null ? (class$com$ibm$etools$commonarchive$File = ContainerImpl.class$("com.ibm.etools.commonarchive.File")) : class$com$ibm$etools$commonarchive$File, (InternalEObject)this, 7, 6);
        }
        return this.files;
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 6: {
                    if (this.eContainer != null) {
                        notificationChain = this.eBasicRemoveFromContainer(notificationChain);
                    }
                    return this.eBasicSetContainer(internalEObject, 6, notificationChain);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseAdd(internalEObject, n, clazz, notificationChain);
        }
        if (this.eContainer != null) {
            notificationChain = this.eBasicRemoveFromContainer(notificationChain);
        }
        return this.eBasicSetContainer(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, notificationChain);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseRemove(internalEObject, n, clazz, notificationChain);
        }
        return this.eBasicSetContainer(null, n, notificationChain);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain notificationChain) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 6: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, class$com$ibm$etools$commonarchive$Container == null ? (class$com$ibm$etools$commonarchive$Container = ContainerImpl.class$("com.ibm.etools.commonarchive.Container")) : class$com$ibm$etools$commonarchive$Container, notificationChain);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(notificationChain);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, notificationChain);
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (bl) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setURI((String)object);
                return;
            }
            case 1: {
                this.setLastModified((Long)object);
                return;
            }
            case 2: {
                this.setSize((Long)object);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)object);
                return;
            }
            case 4: {
                this.setOriginalURI((String)object);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)object);
                return;
            }
            case 6: {
                this.setContainer((Container)object);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setURI(FileImpl.URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(FileImpl.ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return FileImpl.URI_EDEFAULT == null ? this.uri != null : !FileImpl.URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return FileImpl.ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !FileImpl.ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public void clearFiles() {
        boolean bl = this.eDeliver();
        this.files.clear();
        this.eSetDeliver(bl);
        if (this.isIndexed()) {
            this.eAdapters().remove((Object)this.fileIndexAdapter);
            this.fileIndexAdapter = null;
            this.fileIndex = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class FileNotificationAdapter
    extends AdapterImpl {
        protected FileNotificationAdapter() {
        }

        public boolean isAdapterForType(Object object) {
            return object == "FileNotificationAdapter";
        }

        public void addIndexedFile(String string, Notifier notifier) {
            ContainerImpl.this.fileIndex.put(string, notifier);
            if (notifier.eAdapters() == null || !notifier.eAdapters().contains((Object)this)) {
                notifier.eAdapters().add((Object)this);
            }
        }

        public void removeIndexedFile(String string, Notifier notifier) {
            ContainerImpl.this.fileIndex.remove(string);
            notifier.eAdapters().remove((Object)this);
        }

        public void notifyChanged(Notification notification) {
            if (ContainerImpl.this.fileIndex == null || notification.getFeature() == null) {
                return;
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getFile_URI()) && ((File)notification.getNotifier()).getContainer() == ContainerImpl.this) {
                ContainerImpl.this.fileIndex.remove(notification.getOldValue());
                ContainerImpl.this.fileIndex.put(notification.getNewValue(), notification.getNotifier());
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getContainer_Files()) && notification.getNotifier() == ContainerImpl.this) {
                switch (notification.getEventType()) {
                    case 3: {
                        File file = (File)notification.getNewValue();
                        this.addIndexedFile(file.getURI(), (Notifier)file);
                        break;
                    }
                    case 4: {
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (Notifier)((File)notification.getOldValue()));
                        break;
                    }
                    case 5: {
                        this.filesAdded((List)notification.getNewValue());
                        break;
                    }
                    case 6: {
                        this.filesRemoved((List)notification.getOldValue());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        if (notification.getPosition() == -1) break;
                        File file = (File)notification.getNewValue();
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (Notifier)((File)notification.getOldValue()));
                        this.addIndexedFile(file.getURI(), (Notifier)file);
                    }
                }
            }
        }

        public void filesAdded(List list) {
            int n = 0;
            while (n < list.size()) {
                File file = (File)list.get(n);
                this.addIndexedFile(file.getURI(), (Notifier)file);
                ++n;
            }
        }

        public void filesRemoved(List list) {
            int n = 0;
            while (n < list.size()) {
                File file = (File)list.get(n);
                this.removeIndexedFile(file.getURI(), (Notifier)file);
                ++n;
            }
        }

        public void rebuildFileIndex() {
            this.removeAdaptersIfNecessary();
            ContainerImpl.this.fileIndex = new HashMap();
            if (ContainerImpl.this.getFiles().size() > 0) {
                Iterator iterator = ContainerImpl.this.getFiles().iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    this.addIndexedFile(file.getURI(), (Notifier)file);
                }
            }
        }

        public void removeAdaptersIfNecessary() {
            if (ContainerImpl.this.fileIndex == null) {
                return;
            }
            Iterator iterator = ContainerImpl.this.fileIndex.values().iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                file.eAdapters().remove((Object)this);
            }
        }
    }
}

