/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.impl;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBindingsHelper;
import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBindingsHelper;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBindingsHelper;
import com.ibm.ejs.models.base.extensions.applicationclientext.ApplicationClientExtension;
import com.ibm.ejs.models.base.extensions.applicationclientext.ApplicationClientExtensionsHelper;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtensionsHelper;
import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtensionsHelper;
import com.ibm.etools.application.Application;
import com.ibm.etools.application.ApplicationFactory;
import com.ibm.etools.application.ApplicationPackage;
import com.ibm.etools.application.ConnectorModule;
import com.ibm.etools.application.EjbModule;
import com.ibm.etools.application.JavaClientModule;
import com.ibm.etools.application.Module;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.archive.exception.DeploymentDescriptorLoadException;
import com.ibm.etools.archive.exception.DuplicateObjectException;
import com.ibm.etools.archive.exception.EmptyResourceException;
import com.ibm.etools.archive.exception.ObjectNotFoundException;
import com.ibm.etools.archive.exception.OpenFailureException;
import com.ibm.etools.archive.exception.ResourceLoadException;
import com.ibm.etools.archive.impl.ArchiveOptions;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.client.impl.ApplicationClientResourceFactory;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.impl.AltResourceRegister;
import com.ibm.etools.commonarchive.impl.ArchiveCopyUtility;
import com.ibm.etools.commonarchive.impl.FileImpl;
import com.ibm.etools.commonarchive.impl.ModuleFileImpl;
import com.ibm.etools.commonarchive.looseconfig.LooseArchive;
import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EJBResource;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.impl.EJBJarResourceFactory;
import com.ibm.etools.emf.ecore.utilities.copy.CopyGroup;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.common.impl.J2EEResourceFactoryRegistry;
import com.ibm.etools.j2ee.xml.rar.readers.RarFileResourceFactory;
import com.ibm.etools.jca.Connector;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.etools.webapplication.impl.WebAppResourceFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class EARFileImpl
extends ModuleFileImpl
implements EARFile {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Application deploymentDescriptor = null;
    protected ApplicationBinding bindings = null;
    protected ApplicationExtension extensions = null;
    protected EList moduleRefs = null;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$ModuleRef;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$Container;

    public ModuleFile getModuleFile(Module module) {
        ModuleRef moduleRef = this.getModuleRef(module);
        return moduleRef == null ? null : moduleRef.getModuleFile();
    }

    public ModuleFile addCopy(ModuleFile moduleFile) throws DuplicateObjectException {
        Object object = this.primAddCopyRef(moduleFile);
        if (object instanceof ModuleRef) {
            return ((ModuleRef)object).getModuleFile();
        }
        return (ModuleFile)object;
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getEARFile();
    }

    public Archive addCopy(Archive archive) throws DuplicateObjectException {
        if (archive.isModuleFile()) {
            return this.addCopy((ModuleFile)archive);
        }
        Archive archive2 = super.addCopy(archive);
        archive2.initializeClassLoader();
        return archive2;
    }

    protected Object primAddCopyRef(ModuleFile moduleFile) throws DuplicateObjectException {
        EList eList = this.getModuleRefs();
        if (moduleFile.isEARFile()) {
            return (ModuleFile)super.addCopy(moduleFile);
        }
        this.checkAddValid(moduleFile);
        ModuleFile moduleFile2 = this.getCommonArchiveFactory().copy(moduleFile);
        Module module = this.createModuleForCopying(moduleFile);
        this.getFiles().add((Object)moduleFile2);
        moduleFile2.initializeClassLoader();
        if (!moduleFile2.getURI().equals(module.getUri())) {
            moduleFile2.setURI(module.getUri());
        }
        this.getDeploymentDescriptor().getModules().add((Object)module);
        ModuleRef moduleRef = this.createModuleRef(module, moduleFile2);
        eList.add((Object)moduleRef);
        return moduleRef;
    }

    public ModuleRef addCopyRef(ModuleFile moduleFile) throws DuplicateObjectException {
        Object object = this.primAddCopyRef(moduleFile);
        if (object instanceof ModuleRef) {
            return (ModuleRef)object;
        }
        return null;
    }

    public SecurityRole addCopy(SecurityRole securityRole, Module module) throws DuplicateObjectException {
        EObject eObject = null;
        try {
            eObject = this.getDeploymentDescriptor(module);
        }
        catch (Exception exception) {
            throw new DeploymentDescriptorLoadException(ResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{module.getUri(), this.getURI()}), exception);
        }
        String string = securityRole.getRoleName();
        SecurityRole securityRole2 = (SecurityRole)ArchiveCopyUtility.createCopy((EObject)securityRole);
        if (module.isEjbModule()) {
            EJBJar eJBJar = (EJBJar)eObject;
            if (eJBJar.containsSecurityRole(string)) {
                throw new DuplicateObjectException(ResourceHandler.getString("dup_sec_role_module_EXC_", new Object[]{module.getUri(), string}), eJBJar.getAssemblyDescriptor().getSecurityRoleNamed(string));
            }
            this.getAssemblyDescriptorAddIfNecessary(eJBJar).getSecurityRoles().add((Object)securityRole2);
        } else if (module.isWebModule()) {
            WebApp webApp = (WebApp)eObject;
            if (webApp.containsSecurityRole(string)) {
                throw new DuplicateObjectException(ResourceHandler.getString("dup_sec_role_module_EXC_", new Object[]{module.getUri(), string}), webApp.getSecurityRoleNamed(string));
            }
            webApp.getSecurityRoles().add((Object)securityRole2);
        }
        this.addCopyIfNotExists(securityRole);
        return securityRole2;
    }

    public SecurityRole addCopyIfNotExists(SecurityRole securityRole) {
        Application application = this.getDeploymentDescriptor();
        SecurityRole securityRole2 = null;
        if (!application.containsSecurityRole(securityRole.getRoleName())) {
            securityRole2 = (SecurityRole)ArchiveCopyUtility.createCopy((EObject)securityRole);
            application.getSecurityRoles().add((Object)securityRole2);
        }
        return securityRole2;
    }

    protected void checkDuplicate(String string) throws DuplicateObjectException {
        if (this.isDuplicate(string)) {
            throw new DuplicateObjectException(ResourceHandler.getString("dup_resource_EXC_", new Object[]{string, this.getURI()}));
        }
    }

    protected Module createModuleForCopying(ModuleFile moduleFile) {
        WebModule webModule = null;
        if (moduleFile.isWARFile()) {
            webModule = this.getApplicationFactory().createWebModule();
        } else if (moduleFile.isEJBJarFile()) {
            webModule = this.getApplicationFactory().createEjbModule();
        } else if (moduleFile.isApplicationClientFile()) {
            webModule = this.getApplicationFactory().createJavaClientModule();
        } else if (moduleFile.isRARFile()) {
            webModule = this.getApplicationFactory().createConnectorModule();
        }
        webModule.setUri(moduleFile.getURI());
        return webModule;
    }

    public EObject getAltBindings(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return this.getAltBindings(module, this.getAltDeploymentDescriptor(module));
    }

    protected EObject getAltBindings(Module module, EObject eObject) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        if (eObject == null) {
            return null;
        }
        if (module.isEjbModule()) {
            return EJBBindingsHelper.getEJBJarBinding((EJBJar)((EJBJar)eObject));
        }
        if (module.isWebModule()) {
            return WebAppBindingsHelper.getWebAppBinding((WebApp)((WebApp)eObject));
        }
        if (module.isJavaModule()) {
            return ApplicationClientBindingsHelper.getApplicationClientBinding((ApplicationClient)((ApplicationClient)eObject));
        }
        return null;
    }

    public EObject getAltDeploymentDescriptor(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        XMLResource xMLResource;
        String string = module.getAltDD();
        if (ArchiveUtil.isNullOrEmpty(string)) {
            return null;
        }
        if (!this.isMofResourceLoaded(string.trim())) {
            this.registerResourceFactory(module, string);
        }
        if (!(xMLResource = (XMLResource)this.getMofResource(string.trim())).isAlt()) {
            xMLResource.setIsAlt(true);
            xMLResource.setApplication(this.getDeploymentDescriptor());
        }
        return ArchiveUtil.getRoot((Resource)xMLResource);
    }

    public EObject getAltExtensions(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return this.getAltExtensions(module, this.getAltDeploymentDescriptor(module));
    }

    protected EObject getAltExtensions(Module module, EObject eObject) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        if (eObject == null) {
            return null;
        }
        if (module.isEjbModule()) {
            return EjbExtensionsHelper.getEJBJarExtension((EJBJar)((EJBJar)eObject));
        }
        if (module.isWebModule()) {
            return WebAppExtensionsHelper.getWebAppExtension((WebApp)((WebApp)eObject));
        }
        if (module.isJavaModule()) {
            return ApplicationClientExtensionsHelper.getApplicationClientExtension((ApplicationClient)((ApplicationClient)eObject));
        }
        return null;
    }

    public List getApplicationClientFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.isApplicationClientFile()) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    protected ApplicationFactory getApplicationFactory() {
        return ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory();
    }

    protected AssemblyDescriptor getAssemblyDescriptorAddIfNecessary(EJBJar eJBJar) {
        AssemblyDescriptor assemblyDescriptor = eJBJar.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createAssemblyDescriptor();
            eJBJar.setAssemblyDescriptor(assemblyDescriptor);
        }
        return assemblyDescriptor;
    }

    public ApplicationBinding getBindings() throws ResourceLoadException, DeploymentDescriptorLoadException {
        block3: {
            ApplicationBinding applicationBinding = this.getBindingsGen();
            try {
                if (applicationBinding != null || this.getDeploymentDescriptor() == null) break block3;
                this.setBindings(ApplicationBindingsHelper.getApplicationBinding((Application)this.getDeploymentDescriptor()));
            }
            catch (DeploymentDescriptorLoadException deploymentDescriptorLoadException) {
                throw deploymentDescriptorLoadException;
            }
            catch (Exception exception) {
                this.throwResourceLoadException(this.getBindingsUri(), exception);
            }
        }
        return this.getBindingsGen();
    }

    public EJBJarBinding getBindings(EjbModule ejbModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (EJBJarBinding)this.getBindings((Module)ejbModule);
    }

    public ApplicationClientBinding getBindings(JavaClientModule javaClientModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (ApplicationClientBinding)this.getBindings((Module)javaClientModule);
    }

    public EObject getBindings(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        EObject eObject = this.getAltBindings(module);
        if (eObject == null) {
            eObject = this.getModuleFile(module).getStandardBindings();
        }
        return eObject;
    }

    public WebAppBinding getBindings(WebModule webModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (WebAppBinding)this.getBindings((Module)webModule);
    }

    public String getBindingsUri() {
        return "META-INF/ibm-application-bnd.xmi";
    }

    public Application getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        Application application = this.getDeploymentDescriptorGen();
        if (application == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception exception) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), exception);
            }
        }
        return this.getDeploymentDescriptorGen();
    }

    public Connector getDeploymentDescriptor(ConnectorModule connectorModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (Connector)this.getDeploymentDescriptor((Module)connectorModule);
    }

    public EJBJar getDeploymentDescriptor(EjbModule ejbModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (EJBJar)this.getDeploymentDescriptor((Module)ejbModule);
    }

    public ApplicationClient getDeploymentDescriptor(JavaClientModule javaClientModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (ApplicationClient)this.getDeploymentDescriptor((Module)javaClientModule);
    }

    public EObject getDeploymentDescriptor(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        EObject eObject = this.getAltDeploymentDescriptor(module);
        if (eObject == null) {
            eObject = this.getModuleFile(module).getStandardDeploymentDescriptor();
        }
        return eObject;
    }

    public WebApp getDeploymentDescriptor(WebModule webModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (WebApp)this.getDeploymentDescriptor((Module)webModule);
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/application.xml";
    }

    public List getEJBJarFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.isEJBJarFile()) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ejbRef) {
        String string = ejbRef.getLink();
        if (string == null) {
            return null;
        }
        List list = this.getEJBJarFiles();
        int n = 0;
        while (n < list.size()) {
            EnterpriseBean enterpriseBean = ((EJBJarFile)list.get(n)).getDeploymentDescriptor().getEnterpriseBeanNamed(string);
            if (enterpriseBean != null) {
                return enterpriseBean;
            }
            ++n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ejbRef, String string) {
        String string2 = ejbRef.getLink();
        if (string2 == null) {
            return null;
        }
        if (string2.indexOf(35) == -1) {
            Object object;
            EnterpriseBean enterpriseBean = null;
            XMLResource xMLResource = (XMLResource)ejbRef.eResource();
            if (xMLResource instanceof EJBResource && (object = ((EJBResource)xMLResource).getEJBJar()) != null) {
                enterpriseBean = object.getEnterpiseBeanFromRef(ejbRef);
            }
            if (enterpriseBean != null) return enterpriseBean;
            object = this.getEJBJarFiles();
            int n = 0;
            while (n < object.size()) {
                enterpriseBean = ((EJBJarFile)object.get(n)).getDeploymentDescriptor().getEnterpriseBeanNamed(string2);
                if (enterpriseBean != null) {
                    return enterpriseBean;
                }
                ++n;
            }
            return null;
        } else {
            String string3;
            String string4 = string2.substring(string2.indexOf("#") + 1, string2.length());
            String string5 = string2.substring(0, string2.indexOf("#"));
            if (string4 == null || string5 == null || (string3 = ArchiveUtil.deriveEARRelativeURI(string5, string)) == null) return null;
            try {
                File file = this.getFile(string3);
                if (file == null || !file.isEJBJarFile()) {
                    return null;
                }
                EJBJarFile eJBJarFile = (EJBJarFile)this.getFile(string3);
                EList eList = eJBJarFile.getDeploymentDescriptor().getEnterpriseBeans();
                if (eList == null || eList.isEmpty()) return null;
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                    if (enterpriseBean == null || !enterpriseBean.getName().equals(string4)) continue;
                    return enterpriseBean;
                }
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }

    public ApplicationExtension getExtensions() throws ResourceLoadException {
        block3: {
            ApplicationExtension applicationExtension = this.getExtensionsGen();
            try {
                if (applicationExtension != null || this.getDeploymentDescriptor() == null) break block3;
                this.setExtensions(ApplicationExtensionsHelper.getApplicationExtension((Application)this.getDeploymentDescriptor()));
            }
            catch (DeploymentDescriptorLoadException deploymentDescriptorLoadException) {
                throw deploymentDescriptorLoadException;
            }
            catch (Exception exception) {
                this.throwResourceLoadException(this.getExtensionsUri(), exception);
            }
        }
        return this.getExtensionsGen();
    }

    public EJBJarExtension getExtensions(EjbModule ejbModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (EJBJarExtension)this.getExtensions((Module)ejbModule);
    }

    public ApplicationClientExtension getExtensions(JavaClientModule javaClientModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (ApplicationClientExtension)this.getExtensions((Module)javaClientModule);
    }

    public EObject getExtensions(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        EObject eObject = this.getAltExtensions(module);
        if (eObject == null) {
            eObject = this.getModuleFile(module).getStandardExtensions();
        }
        return eObject;
    }

    public WebAppExtension getExtensions(WebModule webModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (WebAppExtension)this.getExtensions((Module)webModule);
    }

    public Resource getExtensionsResource() throws ResourceLoadException, FileNotFoundException {
        return this.getMofResource(this.getExtensionsUri());
    }

    public String getExtensionsUri() {
        return "META-INF/ibm-application-ext.xmi";
    }

    public Module getModule(String string, String string2) {
        return this.getDeploymentDescriptor().getModule(string, string2);
    }

    public ModuleExtension getModuleExtension(String string, String string2) {
        Module module = this.getModule(string, string2);
        if (module == null) {
            return null;
        }
        return this.getExtensions().getModuleExtension(module);
    }

    public ModuleRef getModuleRef(Module module) {
        EList eList = this.getModuleRefs();
        int n = 0;
        while (n < eList.size()) {
            ModuleRef moduleRef = (ModuleRef)eList.get(n);
            if (moduleRef.getModule() == module) {
                return moduleRef;
            }
            ++n;
        }
        return null;
    }

    public List getModuleFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.isModuleFile()) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    protected ArchiveOptions getOptionsForOpening(String string) throws IOException {
        LoadStrategy loadStrategy = this.getCommonArchiveFactory().createChildLoadStrategy(string, this.getLoadStrategy());
        return this.getOptions().cloneWith(loadStrategy, string);
    }

    protected ArchiveOptions getOptionsForOpening(LooseArchive looseArchive) throws IOException {
        LoadStrategy loadStrategy = this.getCommonArchiveFactory().createLoadStrategy(looseArchive.getBinariesPath());
        loadStrategy.setLooseArchive(looseArchive);
        return this.getOptions().cloneWith(loadStrategy, looseArchive.getUri());
    }

    public List getRARFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.isRARFile()) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    public EList getRolesFromAllModules() {
        BasicEList basicEList = new BasicEList();
        EList eList = this.getDeploymentDescriptor().getModules();
        int n = 0;
        int n2 = eList.size();
        while (n < n2) {
            Module module = (Module)eList.get(n);
            EList eList2 = this.getRolesFromModule(module);
            int n3 = 0;
            int n4 = eList2.size();
            while (n3 < n4) {
                basicEList.add(eList2.get(n3));
                ++n3;
            }
            ++n;
        }
        return basicEList;
    }

    public EList getRolesFromModule(Module module) {
        Object object = new BasicEList();
        try {
            if (module.isWebModule()) {
                object = this.getDeploymentDescriptor((WebModule)module).getSecurityRoles();
            } else if (module.isEjbModule()) {
                EJBJar eJBJar = this.getDeploymentDescriptor((EjbModule)module);
                AssemblyDescriptor assemblyDescriptor = eJBJar.getAssemblyDescriptor();
                object = assemblyDescriptor == null ? new BasicEList() : assemblyDescriptor.getSecurityRoles();
            }
        }
        catch (Exception exception) {
            throw new DeploymentDescriptorLoadException(ResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{module.getUri(), this.getURI()}), exception);
        }
        return object;
    }

    public String getSpecVersion() {
        Application application = this.getDeploymentDescriptor();
        String string = ((XMLResource)application.eResource()).getSystemId();
        if (string.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd")) {
            return "1.2";
        }
        if (string.equals("http://java.sun.com/dtd/application_1_3.dtd")) {
            return "1.3";
        }
        return super.getSpecVersion();
    }

    public EObject getStandardBindings() throws ResourceLoadException {
        return this.getBindings();
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public EObject getStandardExtensions() throws ResourceLoadException {
        return this.getExtensions();
    }

    public List getWARFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.isWARFile()) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    public void initializeAfterOpen() {
        super.initializeAfterOpen();
        this.initializeModuleExtensions();
    }

    protected void initializeModuleExtensions() {
        EList eList = this.getDeploymentDescriptor().getModules();
        int n = 0;
        while (n < eList.size()) {
            ModuleExtension moduleExtension;
            Module module = (Module)eList.get(n);
            if (!ArchiveUtil.isNullOrEmpty(module.getAltDD()) && (moduleExtension = this.getExtensions().getModuleExtension(module)) != null) {
                String string;
                if (moduleExtension.getAltBindings() == null || moduleExtension.getAltBindings().length() == 0) {
                    string = ArchiveUtil.getDefaultAltBindingsUri(moduleExtension, this);
                    moduleExtension.setAltBindings(string);
                }
                if (moduleExtension.usesExtensions() && (moduleExtension.getAltExtensions() == null || moduleExtension.getAltExtensions().length() == 0)) {
                    string = ArchiveUtil.getDefaultAltExtensionsUri(moduleExtension, this);
                    moduleExtension.setAltExtensions(string);
                }
            }
            ++n;
        }
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isEARFile() {
        return true;
    }

    public boolean isNestedArchive(String string) {
        if (super.isNestedArchive(string)) {
            return true;
        }
        return this.getDeploymentDescriptor().getFirstModule(string) != null;
    }

    public void makeAltDescriptorsAndResources(ModuleRef moduleRef) throws DuplicateObjectException {
        Module module = moduleRef.getModule();
        ModuleExtension moduleExtension = this.getExtensions().getModuleExtension(module);
        String string = module.getAltDD();
        if (ArchiveUtil.isNullOrEmpty(string)) {
            string = ArchiveUtil.getDefaultAltDDUri(moduleExtension, this);
            this.checkDuplicate(string);
            module.setAltDD(string);
        }
        this.registerResourceFactory(module, string);
        String string2 = moduleExtension.getAltBindings();
        if (ArchiveUtil.isNullOrEmpty(string2)) {
            string2 = ArchiveUtil.getDefaultAltBindingsUri(moduleExtension, this);
            this.checkDuplicate(string2);
            moduleExtension.setAltBindings(string2);
        }
        String string3 = moduleExtension.getAltExtensions();
        if (moduleExtension.usesExtensions() && ArchiveUtil.isNullOrEmpty(string3)) {
            string3 = ArchiveUtil.getDefaultAltExtensionsUri(moduleExtension, this);
            this.checkDuplicate(string3);
            moduleExtension.setAltExtensions(string3);
        }
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.add(moduleRef.getStandardDeploymentDescriptor().eResource(), string);
        copyGroup.add(moduleRef.getStandardBindings().eResource(), string2);
        if (moduleExtension.usesExtensions()) {
            copyGroup.add(moduleRef.getStandardExtensions().eResource(), string3);
        }
        this.addRegisteredAltResources(copyGroup, moduleRef, moduleExtension);
        ArchiveCopyUtility.createCopy(copyGroup);
        List list = copyGroup.getCopiedResources();
        int n = 0;
        while (n < list.size()) {
            this.addOrReplaceMofResource((Resource)list.get(n));
            ++n;
        }
    }

    protected void addRegisteredAltResources(CopyGroup copyGroup, ModuleRef moduleRef, ModuleExtension moduleExtension) {
        Iterator iterator = AltResourceRegister.getRegisteredURIs().iterator();
        Resource resource = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                resource = moduleRef.getLocalMofResource(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            String string2 = ArchiveUtil.getOrCreateAltRoot(moduleExtension, this);
            String string3 = ArchiveUtil.concatUri(string2, string, '/');
            copyGroup.add(resource, string3);
        }
    }

    public EObject makeDeploymentDescriptor(XMLResource xMLResource) {
        Application application = ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory().createApplication();
        xMLResource.setID((EObject)application, "Application_ID");
        this.setDeploymentDescriptorGen(application);
        xMLResource.getContents().add((Object)application);
        return application;
    }

    public Archive openNestedArchive(LooseArchive looseArchive) throws OpenFailureException {
        Module module = this.getDeploymentDescriptor().getFirstModule(looseArchive.getUri());
        if (module == null) {
            return super.openNestedArchive(looseArchive);
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(looseArchive);
            return this.openNestedArchive(module, archiveOptions);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Archive openNestedArchive(String string) throws OpenFailureException {
        Module module = this.getDeploymentDescriptor().getFirstModule(string);
        if (module == null) {
            return super.openNestedArchive(string);
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(string);
            return this.openNestedArchive(module, archiveOptions);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Archive openNestedArchive(Module module, ArchiveOptions archiveOptions) throws OpenFailureException {
        String string = module.getUri();
        try {
            if (module.isWebModule()) {
                return this.getCommonArchiveFactory().openWARFile(archiveOptions, string);
            }
            if (module.isEjbModule()) {
                return this.getCommonArchiveFactory().openEJBJarFile(archiveOptions, string);
            }
            if (module.isJavaModule()) {
                return this.getCommonArchiveFactory().openApplicationClientFile(archiveOptions, string);
            }
            if (module.isConnectorModule()) {
                return this.getCommonArchiveFactory().openRARFile(archiveOptions, string);
            }
        }
        catch (OpenFailureException openFailureException) {
            throw new OpenFailureException(ResourceHandler.getString("nested_open_fail_EXC_", new Object[]{string, this.getURI()}), (Exception)((Object)openFailureException));
        }
        return null;
    }

    public void pushDownRole(SecurityRole securityRole) {
        if (securityRole == null) {
            throw new IllegalArgumentException(ResourceHandler.getString("Parameter_should_not_be_nu_EXC_"));
        }
        EList eList = this.getDeploymentDescriptor().getModules();
        int n = 0;
        while (n < eList.size()) {
            Module module = (Module)eList.get(n);
            this.pushDownRole(securityRole, module);
            ++n;
        }
    }

    public void pushDownRole(SecurityRole securityRole, Module module) {
        try {
            AssemblyDescriptor assemblyDescriptor;
            if (module.isWebModule()) {
                WebApp webApp = this.getDeploymentDescriptor((WebModule)module);
                if (webApp.getSecurityRoleNamed(securityRole.getRoleName()) == null) {
                    webApp.getSecurityRoles().add((Object)ArchiveCopyUtility.createCopy((EObject)securityRole));
                }
            } else if (module.isEjbModule() && (assemblyDescriptor = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)module))).getSecurityRoleNamed(securityRole.getRoleName()) == null) {
                assemblyDescriptor.getSecurityRoles().add((Object)ArchiveCopyUtility.createCopy((EObject)securityRole));
            }
        }
        catch (Exception exception) {
            throw new DeploymentDescriptorLoadException(ResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{module.getUri(), this.getURI()}), exception);
        }
    }

    protected void registerResourceFactory(Module module, String string) {
        EJBJarResourceFactory eJBJarResourceFactory = null;
        if (module.isEjbModule()) {
            eJBJarResourceFactory = new EJBJarResourceFactory();
        } else if (module.isWebModule()) {
            eJBJarResourceFactory = new WebAppResourceFactory();
        } else if (module.isJavaModule()) {
            eJBJarResourceFactory = new ApplicationClientResourceFactory();
        } else if (module.isConnectorModule()) {
            eJBJarResourceFactory = new RarFileResourceFactory();
        }
        if (eJBJarResourceFactory != null) {
            ResourceSet resourceSet = this.getResourceSet();
            ((J2EEResourceFactoryRegistry)resourceSet.getResourceFactoryRegistry()).registerLastFileSegment(string, (Resource.Factory)eJBJarResourceFactory);
        }
    }

    public void remove(ModuleRef moduleRef) {
        ModuleExtension moduleExtension;
        if (moduleRef == null) {
            return;
        }
        Module module = moduleRef.getModule();
        ModuleExtension moduleExtension2 = moduleExtension = module == null ? null : this.getExtensions().getModuleExtension(module);
        if (module != null) {
            this.getDeploymentDescriptor().getModules().remove((Object)module);
        }
        if (moduleExtension != null) {
            this.getExtensions().getModuleExtensions().remove((Object)moduleExtension);
        }
        this.getModuleRefs().remove((Object)moduleRef);
        if (this.getModuleRefs(moduleRef.getModuleFile()).isEmpty()) {
            this.getFiles().remove((Object)moduleRef.getModuleFile());
        }
    }

    public List getModuleRefs(ModuleFile moduleFile) {
        EList eList = this.getModuleRefs();
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>(1);
        int n = 0;
        while (n < eList.size()) {
            ModuleRef moduleRef = (ModuleRef)eList.get(n);
            if (moduleRef.getModuleFile() == moduleFile) {
                arrayList.add(moduleRef);
            }
            ++n;
        }
        return arrayList;
    }

    protected void renameRolesInModuleDDs(String string, String string2) {
        EList eList = this.getDeploymentDescriptor().getModules();
        int n = 0;
        while (n < eList.size()) {
            Module module = (Module)eList.get(n);
            try {
                if (module.isEjbModule()) {
                    this.getDeploymentDescriptor((EjbModule)module).renameSecurityRole(string, string2);
                } else if (module.isWebModule()) {
                    this.getDeploymentDescriptor((WebModule)module).renameSecurityRole(string, string2);
                }
            }
            catch (Exception exception) {
                throw new DeploymentDescriptorLoadException(ResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{module.getUri(), this.getURI()}), exception);
            }
            ++n;
        }
    }

    public void renameSecurityRole(String string, String string2) throws ObjectNotFoundException, DuplicateObjectException {
        Application application = this.getDeploymentDescriptor();
        SecurityRole securityRole = application.getSecurityRoleNamed(string);
        if (securityRole == null) {
            throw new ObjectNotFoundException(ResourceHandler.getString("no_sec_role_EXC_", new Object[]{this.getURI(), string}));
        }
        if (application.getSecurityRoleNamed(string2) != null) {
            throw new DuplicateObjectException(ResourceHandler.getString("dup_sec_role_EXC_", new Object[]{this.getURI(), string2}), application.getSecurityRoleNamed(string2));
        }
        securityRole.setRoleName(string2);
        this.renameRolesInModuleDDs(string, string2);
    }

    public void rollUpRoles() {
        EList eList = this.getDeploymentDescriptor().getModules();
        int n = 0;
        while (n < eList.size()) {
            Module module = (Module)eList.get(n);
            this.rollUpRoles(module);
            ++n;
        }
    }

    public void rollUpRoles(Module module) {
        EList eList = null;
        try {
            if (module.isWebModule()) {
                eList = this.getDeploymentDescriptor((WebModule)module).getSecurityRoles();
            } else if (module.isEjbModule()) {
                eList = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)module)).getSecurityRoles();
            }
        }
        catch (Exception exception) {
            throw new DeploymentDescriptorLoadException(ResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{module.getUri(), this.getURI()}), exception);
        }
        if (eList == null) {
            return;
        }
        int n = 0;
        while (n < eList.size()) {
            this.addCopyIfNotExists((SecurityRole)eList.get(n));
            ++n;
        }
    }

    public void setBindings(ApplicationBinding applicationBinding) {
        this.setBindingsGen(applicationBinding);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getBindingsUri()), (EObject)applicationBinding);
    }

    public void setDeploymentDescriptor(Application application) {
        this.setDeploymentDescriptorGen(application);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)application);
    }

    public void setExtensions(ApplicationExtension applicationExtension) {
        this.setExtensionsGen(applicationExtension);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getExtensionsUri()), (EObject)applicationExtension);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return FileImpl.URI_EDEFAULT == null ? this.uri != null : !FileImpl.URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return FileImpl.ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !FileImpl.ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
            case 8: {
                return this.deploymentDescriptor != null;
            }
            case 9: {
                return this.bindings != null;
            }
            case 10: {
                return this.extensions != null;
            }
            case 11: {
                return this.moduleRefs != null && !this.moduleRefs.isEmpty();
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setURI((String)object);
                return;
            }
            case 1: {
                this.setLastModified((Long)object);
                return;
            }
            case 2: {
                this.setSize((Long)object);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)object);
                return;
            }
            case 4: {
                this.setOriginalURI((String)object);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)object);
                return;
            }
            case 6: {
                this.setContainer((Container)object);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)object);
                return;
            }
            case 8: {
                this.setDeploymentDescriptor((Application)object);
                return;
            }
            case 9: {
                this.setBindings((ApplicationBinding)object);
                return;
            }
            case 10: {
                this.setExtensions((ApplicationExtension)object);
                return;
            }
            case 11: {
                this.getModuleRefs().clear();
                this.getModuleRefs().addAll((Collection)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setURI(FileImpl.URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(FileImpl.ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
            case 8: {
                this.setDeploymentDescriptor(null);
                return;
            }
            case 9: {
                this.setBindings(null);
                return;
            }
            case 10: {
                this.setExtensions(null);
                return;
            }
            case 11: {
                this.getModuleRefs().clear();
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public Application getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            Application application = this.deploymentDescriptor;
            this.deploymentDescriptor = (Application)EcoreUtil.resolve((EObject)this.deploymentDescriptor, (EObject)this);
            if (this.deploymentDescriptor != application && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)application, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public Application basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(Application application) {
        Application application2 = this.deploymentDescriptor;
        this.deploymentDescriptor = application;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)application2, (Object)this.deploymentDescriptor));
        }
    }

    public ApplicationBinding getBindingsGen() {
        if (this.bindings != null && this.bindings.eIsProxy()) {
            ApplicationBinding applicationBinding = this.bindings;
            this.bindings = (ApplicationBinding)EcoreUtil.resolve((EObject)this.bindings, (EObject)this);
            if (this.bindings != applicationBinding && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)applicationBinding, (Object)this.bindings));
            }
        }
        return this.bindings;
    }

    public ApplicationBinding basicGetBindings() {
        return this.bindings;
    }

    public void setBindingsGen(ApplicationBinding applicationBinding) {
        ApplicationBinding applicationBinding2 = this.bindings;
        this.bindings = applicationBinding;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)applicationBinding2, (Object)this.bindings));
        }
    }

    public ApplicationExtension getExtensionsGen() {
        if (this.extensions != null && this.extensions.eIsProxy()) {
            ApplicationExtension applicationExtension = this.extensions;
            this.extensions = (ApplicationExtension)EcoreUtil.resolve((EObject)this.extensions, (EObject)this);
            if (this.extensions != applicationExtension && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)applicationExtension, (Object)this.extensions));
            }
        }
        return this.extensions;
    }

    public ApplicationExtension basicGetExtensions() {
        return this.extensions;
    }

    public void setExtensionsGen(ApplicationExtension applicationExtension) {
        ApplicationExtension applicationExtension2 = this.extensions;
        this.extensions = applicationExtension;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)applicationExtension2, (Object)this.extensions));
        }
    }

    public EList getModuleRefsGen() {
        if (this.moduleRefs == null) {
            this.moduleRefs = new EObjectContainmentWithInverseEList(class$com$ibm$etools$commonarchive$ModuleRef == null ? (class$com$ibm$etools$commonarchive$ModuleRef = EARFileImpl.class$("com.ibm.etools.commonarchive.ModuleRef")) : class$com$ibm$etools$commonarchive$ModuleRef, (InternalEObject)this, 11, 3);
        }
        return this.moduleRefs;
    }

    public EList getModuleRefs() {
        EList eList = this.getModuleRefsGen();
        if (eList.isEmpty()) {
            this.initRefs(eList);
        }
        return eList;
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 6: {
                    if (this.eContainer != null) {
                        notificationChain = this.eBasicRemoveFromContainer(notificationChain);
                    }
                    return this.eBasicSetContainer(internalEObject, 6, notificationChain);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)internalEObject, notificationChain);
                }
                case 11: {
                    return ((InternalEList)this.getModuleRefs()).basicAdd((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseAdd(internalEObject, n, clazz, notificationChain);
        }
        if (this.eContainer != null) {
            notificationChain = this.eBasicRemoveFromContainer(notificationChain);
        }
        return this.eBasicSetContainer(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, notificationChain);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)internalEObject, notificationChain);
                }
                case 11: {
                    return ((InternalEList)this.getModuleRefs()).basicRemove((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseRemove(internalEObject, n, clazz, notificationChain);
        }
        return this.eBasicSetContainer(null, n, notificationChain);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain notificationChain) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 6: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, class$com$ibm$etools$commonarchive$Container == null ? (class$com$ibm$etools$commonarchive$Container = EARFileImpl.class$("com.ibm.etools.commonarchive.Container")) : class$com$ibm$etools$commonarchive$Container, notificationChain);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(notificationChain);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, notificationChain);
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (bl) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
            case 8: {
                if (bl) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
            case 9: {
                if (bl) {
                    return this.getBindings();
                }
                return this.basicGetBindings();
            }
            case 10: {
                if (bl) {
                    return this.getExtensions();
                }
                return this.basicGetExtensions();
            }
            case 11: {
                return this.getModuleRefs();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public void initRefs(EList eList) {
        EList eList2 = this.getDeploymentDescriptor().getModules();
        int n = 0;
        while (n < eList2.size()) {
            Module module = (Module)eList2.get(n);
            eList.add((Object)this.createModuleRef(module, null));
            ++n;
        }
    }

    protected ModuleRef createModuleRef(Module module, ModuleFile moduleFile) {
        ModuleRef moduleRef = null;
        if (module.isEjbModule()) {
            moduleRef = this.getCommonArchiveFactory().createEJBModuleRef();
        } else if (module.isWebModule()) {
            moduleRef = this.getCommonArchiveFactory().createWebModuleRef();
        } else if (module.isConnectorModule()) {
            moduleRef = this.getCommonArchiveFactory().createConnectorModuleRef();
        } else if (module.isJavaModule()) {
            moduleRef = this.getCommonArchiveFactory().createClientModuleRef();
        }
        moduleRef.setModule(module);
        moduleRef.setModuleFile(moduleFile);
        return moduleRef;
    }

    public List getClientModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        int n = 0;
        while (n < eList.size()) {
            ModuleRef moduleRef = (ModuleRef)eList.get(n);
            if (moduleRef.isClient()) {
                arrayList.add(moduleRef);
            }
            ++n;
        }
        return arrayList;
    }

    public List getConnectorModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        int n = 0;
        while (n < eList.size()) {
            ModuleRef moduleRef = (ModuleRef)eList.get(n);
            if (moduleRef.isConnector()) {
                arrayList.add(moduleRef);
            }
            ++n;
        }
        return arrayList;
    }

    public List getEJBModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        int n = 0;
        while (n < eList.size()) {
            ModuleRef moduleRef = (ModuleRef)eList.get(n);
            if (moduleRef.isEJB()) {
                arrayList.add(moduleRef);
            }
            ++n;
        }
        return arrayList;
    }

    public List getWebModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        int n = 0;
        while (n < eList.size()) {
            ModuleRef moduleRef = (ModuleRef)eList.get(n);
            if (moduleRef.isWeb()) {
                arrayList.add(moduleRef);
            }
            ++n;
        }
        return arrayList;
    }

    public List getFARFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        int n = 0;
        while (n < eList.size()) {
            File file = (File)eList.get(n);
            if (file.isFARFile()) {
                arrayList.add(file);
            }
            ++n;
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

