/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.impl;

import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.etools.application.Module;
import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.exception.ArchiveWrappedException;
import com.ibm.etools.archive.exception.DuplicateObjectException;
import com.ibm.etools.archive.exception.NoModuleFileException;
import com.ibm.etools.archive.exception.ResourceLoadException;
import com.ibm.etools.archive.exception.SubclassResponsibilityException;
import com.ibm.etools.archive.nls.ResourceHandler;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.commonarchive.ModuleComponent;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ModuleRef;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ModuleRefImpl
extends EObjectImpl
implements ModuleRef,
EObject {
    protected EList components = null;
    protected Module module = null;
    protected ModuleFile moduleFile = null;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$ModuleComponent;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$EARFile;

    protected ModuleRefImpl() {
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getModuleRef();
    }

    public boolean containsComponent(String string) {
        if (string == null) {
            return false;
        }
        EList eList = this.getComponents();
        int n = 0;
        while (n < eList.size()) {
            ModuleComponent moduleComponent = (ModuleComponent)eList.get(n);
            if (string.equals(moduleComponent.getComponentName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void remove(ModuleComponent moduleComponent) {
        throw new SubclassResponsibilityException("remove(ModuleComponent)");
    }

    public ModuleComponent addCopy(ModuleComponent moduleComponent) throws DuplicateObjectException {
        ModuleComponent moduleComponent2 = this.getComponent(moduleComponent.getComponentName());
        if (moduleComponent2 != null) {
            throw new DuplicateObjectException(moduleComponent.getComponentName(), moduleComponent2);
        }
        ModuleComponent moduleComponent3 = ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory().copy(moduleComponent);
        this.basicAdd(moduleComponent3);
        this.addCopyRequiredFiles(moduleComponent);
        return moduleComponent3;
    }

    public void addCopyRequiredFiles(ModuleComponent moduleComponent) {
    }

    protected CommonarchiveFactory getCommonArchiveFactory() {
        return ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory();
    }

    public void basicAdd(ModuleComponent moduleComponent) {
        throw new SubclassResponsibilityException("basicAdd(ModuleComponent)");
    }

    protected void buildComponentList(EList eList) {
    }

    public ModuleComponent getComponent(String string) {
        if (string == null) {
            return null;
        }
        EList eList = this.getComponents();
        int n = 0;
        while (n < eList.size()) {
            ModuleComponent moduleComponent = (ModuleComponent)eList.get(n);
            if (string.equals(moduleComponent.getComponentName())) {
                return moduleComponent;
            }
            ++n;
        }
        return null;
    }

    public EList getComponents() {
        EList eList = this.getComponentsGen();
        if (eList.isEmpty()) {
            this.buildComponentList(eList);
        }
        return this.getComponentsGen();
    }

    public void makeAltDescriptorsAndResources() throws DuplicateObjectException {
        this.getEarFile().makeAltDescriptorsAndResources(this);
    }

    public EList getComponentsGen() {
        if (this.components == null) {
            this.components = new EObjectContainmentWithInverseEList(class$com$ibm$etools$commonarchive$ModuleComponent == null ? (class$com$ibm$etools$commonarchive$ModuleComponent = ModuleRefImpl.class$("com.ibm.etools.commonarchive.ModuleComponent")) : class$com$ibm$etools$commonarchive$ModuleComponent, (InternalEObject)this, 0, 0);
        }
        return this.components;
    }

    public Module getModule() {
        if (this.module != null && this.module.eIsProxy()) {
            Module module = this.module;
            this.module = (Module)EcoreUtil.resolve((EObject)this.module, (EObject)this);
            if (this.module != module && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)module, (Object)this.module));
            }
        }
        return this.module;
    }

    public Module basicGetModule() {
        return this.module;
    }

    public void setModule(Module module) {
        Module module2 = this.module;
        this.module = module;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)module2, (Object)this.module));
        }
    }

    public ModuleFile getModuleFileGen() {
        if (this.moduleFile != null && this.moduleFile.eIsProxy()) {
            ModuleFile moduleFile = this.moduleFile;
            this.moduleFile = (ModuleFile)EcoreUtil.resolve((EObject)this.moduleFile, (EObject)this);
            if (this.moduleFile != moduleFile && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)moduleFile, (Object)this.moduleFile));
            }
        }
        return this.moduleFile;
    }

    public ModuleFile getModuleFile() {
        if (this.moduleFile == null) {
            this.initModuleFileFromEAR();
        }
        return this.moduleFile;
    }

    public ModuleFile basicGetModuleFile() {
        return this.moduleFile;
    }

    protected void initModuleFileFromEAR() {
        this.checkEARFile();
        ModuleFile moduleFile = null;
        try {
            moduleFile = (ModuleFile)this.getEarFile().getFile(this.module.getUri());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.checkType(this.module, moduleFile);
        this.setModuleFile(moduleFile);
    }

    public void setModuleFile(ModuleFile moduleFile) {
        ModuleFile moduleFile2 = this.moduleFile;
        this.moduleFile = moduleFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)moduleFile2, (Object)this.moduleFile));
        }
    }

    public boolean usesAltDD() {
        if (this.module == null) {
            return false;
        }
        return !ArchiveUtil.isNullOrEmpty(this.module.getAltDD());
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.components != null && !this.components.isEmpty();
            }
            case 1: {
                return this.module != null;
            }
            case 2: {
                return this.moduleFile != null;
            }
            case 3: {
                return this.getEarFile() != null;
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.getComponents().clear();
                this.getComponents().addAll((Collection)object);
                return;
            }
            case 1: {
                this.setModule((Module)object);
                return;
            }
            case 2: {
                this.setModuleFile((ModuleFile)object);
                return;
            }
            case 3: {
                this.setEarFile((EARFile)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.getComponents().clear();
                return;
            }
            case 1: {
                this.setModule(null);
                return;
            }
            case 2: {
                this.setModuleFile(null);
                return;
            }
            case 3: {
                this.setEarFile(null);
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public EObject getAltDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return null;
        }
        try {
            return this.getEarFile().getAltDeploymentDescriptor(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return this.getStandardDeploymentDescriptor();
        }
        try {
            return this.getEarFile().getDeploymentDescriptor(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getStandardDeploymentDescriptor() {
        if (this.getModuleFile() == null) {
            return null;
        }
        return this.getModuleFile().getStandardDeploymentDescriptor();
    }

    public EObject getAltBindings() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return null;
        }
        try {
            return this.getEarFile().getAltBindings(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getAltExtensions() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return null;
        }
        try {
            return this.getEarFile().getAltExtensions(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getBindings() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return this.getStandardBindings();
        }
        try {
            return this.getEarFile().getBindings(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getExtensions() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return this.getStandardExtensions();
        }
        try {
            return this.getEarFile().getExtensions(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getStandardBindings() {
        if (this.getModuleFile() == null) {
            return null;
        }
        return this.getModuleFile().getStandardBindings();
    }

    public EObject getStandardExtensions() {
        if (this.getModuleFile() == null) {
            return null;
        }
        return this.getModuleFile().getStandardExtensions();
    }

    public void setURI(String string) {
        if (this.getModuleFile() != null) {
            this.getModuleFile().setURI(string);
        }
        if (this.getModule() != null) {
            this.getModule().setUri(string);
        }
    }

    public boolean isClient() {
        return false;
    }

    public boolean isConnector() {
        return false;
    }

    public boolean isEJB() {
        return false;
    }

    public boolean isWeb() {
        return false;
    }

    public EARFile getEarFile() {
        if (this.eContainerFeatureID != 3) {
            return null;
        }
        return (EARFile)this.eContainer;
    }

    public void setEarFile(EARFile eARFile) {
        if (eARFile != this.eContainer || this.eContainerFeatureID != 3 && eARFile != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)eARFile)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain notificationChain = null;
            if (this.eContainer != null) {
                notificationChain = this.eBasicRemoveFromContainer(notificationChain);
            }
            if (eARFile != null) {
                notificationChain = ((InternalEObject)eARFile).eInverseAdd((InternalEObject)this, 11, class$com$ibm$etools$commonarchive$EARFile == null ? (class$com$ibm$etools$commonarchive$EARFile = ModuleRefImpl.class$("com.ibm.etools.commonarchive.EARFile")) : class$com$ibm$etools$commonarchive$EARFile, notificationChain);
            }
            if ((notificationChain = this.eBasicSetContainer((InternalEObject)eARFile, 3, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)eARFile, (Object)eARFile));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 0: {
                    return ((InternalEList)this.getComponents()).basicAdd((Object)internalEObject, notificationChain);
                }
                case 3: {
                    if (this.eContainer != null) {
                        notificationChain = this.eBasicRemoveFromContainer(notificationChain);
                    }
                    return this.eBasicSetContainer(internalEObject, 3, notificationChain);
                }
            }
            return this.eDynamicInverseAdd(internalEObject, n, clazz, notificationChain);
        }
        if (this.eContainer != null) {
            notificationChain = this.eBasicRemoveFromContainer(notificationChain);
        }
        return this.eBasicSetContainer(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 0: {
                    return ((InternalEList)this.getComponents()).basicRemove((Object)internalEObject, notificationChain);
                }
                case 3: {
                    return this.eBasicSetContainer(null, 3, notificationChain);
                }
            }
            return this.eDynamicInverseRemove(internalEObject, n, clazz, notificationChain);
        }
        return this.eBasicSetContainer(null, n, notificationChain);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain notificationChain) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 3: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 11, class$com$ibm$etools$commonarchive$EARFile == null ? (class$com$ibm$etools$commonarchive$EARFile = ModuleRefImpl.class$("com.ibm.etools.commonarchive.EARFile")) : class$com$ibm$etools$commonarchive$EARFile, notificationChain);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(notificationChain);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, notificationChain);
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getComponents();
            }
            case 1: {
                if (bl) {
                    return this.getModule();
                }
                return this.basicGetModule();
            }
            case 2: {
                if (bl) {
                    return this.getModuleFile();
                }
                return this.basicGetModuleFile();
            }
            case 3: {
                return this.getEarFile();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public InputStream getResourceInputStream(String string) throws IOException {
        if (this.usesAltDD()) {
            return this.getAltResourceInputStream(string);
        }
        return this.getLocalResourceInputStream(string);
    }

    public InputStream getLocalResourceInputStream(String string) throws IOException {
        this.checkModuleFile();
        return this.moduleFile.getResourceInputStream(string);
    }

    public InputStream getAltResourceInputStream(String string) throws IOException {
        this.checkEARFile();
        return this.getEarFile().getResourceInputStream(string);
    }

    public String getUri() {
        if (this.module != null) {
            return this.module.getUri();
        }
        if (this.moduleFile != null) {
            return this.moduleFile.getURI();
        }
        return null;
    }

    public Resource getAltMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        this.checkEARFile();
        return this.getEarFile().getMofResource(string);
    }

    public Resource getLocalMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        this.checkModuleFile();
        return this.moduleFile.getMofResource(string);
    }

    public Resource getMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        if (this.usesAltDD()) {
            return this.getAltMofResource(string);
        }
        return this.getLocalMofResource(string);
    }

    public Resource makeAltMofResource(String string) throws DuplicateObjectException {
        this.checkEARFile();
        return this.getEarFile().makeMofResource(string);
    }

    protected void checkEARFile() {
        if (this.getEarFile() == null) {
            throw new ArchiveRuntimeException(ResourceHandler.getString("Module_not_in_EAR", new Object[]{this.getUri()}));
        }
    }

    public Resource makeLocalMofResource(String string) throws DuplicateObjectException {
        this.checkModuleFile();
        return this.moduleFile.makeMofResource(string);
    }

    protected void checkModuleFile() {
        this.getModuleFile();
        if (this.moduleFile == null) {
            throw new NoModuleFileException(ResourceHandler.getString("Module_file_does_not_exist_2", new Object[]{this.getUri()}));
        }
    }

    protected void checkType(Module module, File file) {
        if (file == null) {
            String string = ResourceHandler.getString("A_file_does_not_exist_for_module", new Object[]{module.getUri()});
            throw new NoModuleFileException(string);
        }
        boolean bl = true;
        String string = ResourceHandler.getString("Module_file");
        if (module.isWebModule() && !file.isWARFile()) {
            bl = false;
            string = ResourceHandler.getString("A_WAR_file");
        } else if (module.isEjbModule() && !file.isEJBJarFile()) {
            bl = false;
            string = ResourceHandler.getString("An_EJB_JAR_file");
        } else if (module.isJavaModule() && !file.isApplicationClientFile()) {
            bl = false;
            string = ResourceHandler.getString("An_Application_Client_JAR_file");
        } else if (module.isConnectorModule() && !file.isRARFile()) {
            bl = false;
            string = ResourceHandler.getString("A_RAR_file");
        } else if (!file.isModuleFile()) {
            bl = false;
        }
        if (bl) {
            return;
        }
        String string2 = "";
        if (this.getEarFile() != null) {
            string2 = this.getEarFile().getURI();
        }
        String string3 = ResourceHandler.getString("File_not_correct_type", new Object[]{file.getURI(), string2, string});
        throw new ArchiveRuntimeException(string3);
    }

    public Resource makeMofResource(String string) throws DuplicateObjectException {
        if (this.usesAltDD()) {
            return this.makeAltMofResource(string);
        }
        return this.makeLocalMofResource(string);
    }

    public String getAltRoot() {
        EARFile eARFile = this.getEarFile();
        if (this.module == null || eARFile == null) {
            return null;
        }
        ModuleExtension moduleExtension = eARFile.getExtensions().getModuleExtension(this.module);
        return ArchiveUtil.getOrCreateAltRoot(moduleExtension, eARFile);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

