/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.looseconfig;

import com.ibm.etools.application.Module;
import com.ibm.etools.archive.exception.ArchiveRuntimeException;
import com.ibm.etools.archive.util.ArchiveUtil;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.looseconfig.LooseApplication;
import com.ibm.etools.commonarchive.looseconfig.LooseArchive;
import com.ibm.etools.commonarchive.looseconfig.LooseConfiguration;
import com.ibm.etools.commonarchive.looseconfig.LooseModule;
import com.ibm.etools.commonarchive.looseconfig.LooseWARFile;
import com.ibm.etools.wft.util.StringUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class LooseConfigRegister {
    public static final String LOOSE_CONFIG_PROPERTY = "was.loose.config";
    protected static LooseConfigRegister singleton;
    protected LooseConfiguration looseConfiguration;
    protected ResourceSet resourceSet;
    protected boolean loadAttempted = false;

    protected LooseConfigRegister() {
        this.initialize();
    }

    public static LooseConfigRegister singleton() {
        if (singleton == null) {
            singleton = new LooseConfigRegister();
        }
        return singleton;
    }

    public LooseApplication findLooseApplication(String string) {
        if (this.getLooseConfiguration() != null) {
            EList eList = this.getLooseConfiguration().getApplications();
            int n = 0;
            while (n < eList.size()) {
                LooseApplication looseApplication = (LooseApplication)eList.get(n);
                if (looseApplication.getUri().equals(string)) {
                    return looseApplication;
                }
                ++n;
            }
        }
        return null;
    }

    public LooseModule findLooseModule(LooseApplication looseApplication, String string, String string2) {
        EList eList = looseApplication.getLooseArchives();
        int n = 0;
        while (n < eList.size()) {
            LooseArchive looseArchive = (LooseArchive)eList.get(n);
            if (looseArchive.isModule() && StringUtil.stringsEqual((String)string, (String)looseArchive.getUri()) && StringUtil.stringsEqual((String)string2, (String)((LooseModule)looseArchive).getAltDD())) {
                return (LooseModule)looseArchive;
            }
            ++n;
        }
        return null;
    }

    public LooseModule findLooseModule(Module module, EARFile eARFile) {
        LooseApplication looseApplication = this.findLooseApplication(eARFile.getURI());
        return looseApplication == null ? null : this.findLooseModule(looseApplication, module.getUri(), module.getAltDD());
    }

    public void flush() {
        this.loadAttempted = false;
        this.looseConfiguration = null;
        this.resourceSet = new ResourceSetImpl();
    }

    protected void initialize() {
        this.resourceSet = new ResourceSetImpl();
    }

    protected void loadLooseConfiguration() {
        Resource resource = this.loadLooseConfigurationResource();
        if (resource != null && !resource.getContents().isEmpty()) {
            this.setLooseConfiguration((LooseConfiguration)resource.getContents().get(0));
        }
        this.loadAttempted = true;
    }

    protected Resource loadLooseConfigurationResource() {
        String string = this.getDocumentURI();
        if (ArchiveUtil.isNullOrEmpty(string)) {
            return null;
        }
        try {
            return this.resourceSet.getResource(URI.createURI((String)string), true);
        }
        catch (Exception exception) {
            throw new ArchiveRuntimeException("Exception occurred loading loose configuration", exception);
        }
    }

    public LooseConfiguration primGetLooseConfiguration() {
        return this.looseConfiguration;
    }

    protected String getDocumentURI() {
        return System.getProperty(LOOSE_CONFIG_PROPERTY);
    }

    public LooseConfiguration getLooseConfiguration() {
        if (this.looseConfiguration == null && !this.loadAttempted) {
            this.loadLooseConfiguration();
        }
        return this.looseConfiguration;
    }

    public List getLooseChildren(LooseArchive looseArchive) {
        if (looseArchive != null) {
            if (looseArchive.isEAR()) {
                return ((LooseApplication)looseArchive).getLooseArchives();
            }
            if (looseArchive.isWAR()) {
                return ((LooseWARFile)looseArchive).getLooseLibs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public LooseArchive findFirstLooseChild(String string, LooseArchive looseArchive) {
        List list = this.getLooseChildren(looseArchive);
        int n = 0;
        while (n < list.size()) {
            LooseArchive looseArchive2 = (LooseArchive)list.get(n);
            if (StringUtil.stringsEqual((String)string, (String)looseArchive2.getUri())) {
                return looseArchive;
            }
            ++n;
        }
        return null;
    }

    public void setLooseConfiguration(LooseConfiguration looseConfiguration) {
        this.looseConfiguration = looseConfiguration;
    }

    public boolean getLoadAttempted() {
        return this.loadAttempted;
    }
}

