/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.jflt;

import com.tivoli.jflt.GenericLogger;
import com.tivoli.jflt.LogAdapter;
import com.tivoli.jflt.LogCatalog;
import com.tivoli.jflt.LogManager;
import com.tivoli.jflt.LoggerParameters;

public class GenericLoggerSupport
implements GenericLogger {
    private LoggerParameters params;
    private volatile long sequenceNumber;
    protected volatile LogAdapter adapter;
    protected volatile LogCatalog catalog;
    private boolean isLog;

    protected GenericLoggerSupport(LoggerParameters params, long managerId) {
        this.sequenceNumber = managerId;
        this.params = params;
        this.isLog = true;
        this.adapter = this.updateConfig();
    }

    public boolean isLogging() {
        return this.isLog && this.adapter.isLogging();
    }

    public synchronized void setLogging(boolean flag) {
        this.isLog = flag;
        this.adapter.setLogging(flag);
    }

    public void log(long type, Object loggingClass, String loggingMethod, String text) {
        if (this.isLogging()) {
            this.adapter.log(type, loggingClass, loggingMethod, text);
        }
    }

    public void message(long type, Object loggingClass, String loggingMethod, String key) {
        if (this.isLogging()) {
            this.checkLogManagerConfig();
            String msg = this.catalog.getMessage(key);
            this.adapter.log(type, loggingClass, loggingMethod, msg);
        }
    }

    public void message(long type, Object loggingClass, String loggingMethod, String key, Object param1) {
        if (this.isLogging()) {
            this.checkLogManagerConfig();
            String msg = this.catalog.getMessage(key, param1);
            this.adapter.log(type, loggingClass, loggingMethod, msg);
        }
    }

    public void message(long type, Object loggingClass, String loggingMethod, String key, Object param1, Object param2) {
        if (this.isLogging()) {
            this.checkLogManagerConfig();
            String msg = this.catalog.getMessage(key, param1, param2);
            this.adapter.log(type, loggingClass, loggingMethod, msg);
        }
    }

    public void message(long type, Object loggingClass, String loggingMethod, String key, Object[] params) {
        if (this.isLogging()) {
            this.checkLogManagerConfig();
            String msg = this.catalog.getMessage(key, params);
            this.adapter.log(type, loggingClass, loggingMethod, msg);
        }
    }

    public LogCatalog getMessageCatalog() {
        return this.catalog;
    }

    private void checkLogManagerConfig() {
        long id = LogManager.getSequenceNumber();
        if (this.sequenceNumber == id) {
            return;
        }
        GenericLoggerSupport genericLoggerSupport = this;
        synchronized (genericLoggerSupport) {
            id = LogManager.getSequenceNumber();
            if (this.sequenceNumber == id) {
                return;
            }
            LogAdapter newAdapter = this.updateConfig();
            this.adapter.dumpQueue(newAdapter);
            this.adapter = newAdapter;
            this.sequenceNumber = id;
        }
    }

    private synchronized LogAdapter updateConfig() {
        try {
            LogManager manager = LogManager.getManager();
            this.catalog = manager.createLogCatalog(this.params.getCatalogName());
            return manager.createLogAdapter(this.params);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException(exc.getLocalizedMessage());
        }
    }
}

