/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.jflt.buffering;

import com.tivoli.jflt.LogItem;

public class CircularBuffer {
    public static final int DEFAULT_SIZE = 1000;
    private int maxSize;
    private int base = 0;
    private int size = 0;
    private LogItem[] circBuffer;

    public CircularBuffer() {
        this(1000);
    }

    public CircularBuffer(int size) {
        this.maxSize = size;
        this.circBuffer = new LogItem[size];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized LogItem get() {
        if (this.size == 0) {
            return null;
        }
        int index = this.base;
        this.base = (this.base + 1) % this.maxSize;
        --this.size;
        LogItem item = this.circBuffer[index];
        this.circBuffer[index] = null;
        return item;
    }

    public synchronized void put(LogItem value) {
        int index = (this.base + this.size) % this.maxSize;
        this.circBuffer[index] = value;
        if (this.size != this.maxSize) {
            ++this.size;
        } else {
            this.base = (this.base + 1) % this.maxSize;
        }
    }
}

