/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.jflt.buffering;

import com.tivoli.jflt.LogAdapter;
import com.tivoli.jflt.LogItem;
import com.tivoli.jflt.buffering.CircularBuffer;

public class CircularBufferAdapter
implements LogAdapter {
    private CircularBuffer buffer = new CircularBuffer();
    private boolean isLogEnabled = true;

    public void log(LogItem item) {
        if (this.isLogEnabled) {
            this.buffer.put(item);
        }
    }

    public void log(long type, Object className, String methodName, String text) {
        if (this.isLogEnabled) {
            LogItem item = new LogItem(type, className, methodName, text, System.currentTimeMillis());
            this.buffer.put(item);
        }
    }

    public synchronized void dumpQueue(LogAdapter adapter) {
        while (!this.buffer.isEmpty()) {
            adapter.log(this.buffer.get());
        }
    }

    public boolean isLogging() {
        return this.isLogEnabled;
    }

    public void setLogging(boolean flag) {
        this.isLogEnabled = flag;
    }
}

