/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.jflt.standard;

import com.tivoli.jflt.LogAdapter;
import com.tivoli.jflt.LogItem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class StandardAdapter
implements LogAdapter {
    private PrintWriter out;
    private boolean isLogEnabled = true;

    public StandardAdapter(String fileName) {
        try {
            this.out = fileName == null ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(fileName));
        }
        catch (IOException exc) {
            System.err.println(exc);
        }
    }

    public void log(LogItem item) {
        this.log(item.getType(), item.getLoggingClass(), item.getLoggingMethod(), item.getText());
    }

    public void log(long type, Object loggingClass, String methodName, String text) {
        if (this.isLogEnabled) {
            String className = null;
            className = loggingClass instanceof String ? (String)loggingClass : loggingClass.getClass().getName();
            String msg = this.getStringType(type) + "[" + className + "." + methodName + "]: " + text;
            this.out.println(msg);
            this.out.flush();
        }
    }

    public void dumpQueue(LogAdapter adapter) {
    }

    public boolean isLogging() {
        return this.isLogEnabled;
    }

    public void setLogging(boolean flag) {
        this.isLogEnabled = flag;
    }

    private final String getStringType(long type) {
        if (type == 4L) {
            return "ERROR ";
        }
        if (type == 1L) {
            return "INFO ";
        }
        if (type == 2L) {
            return "WARNING ";
        }
        return "";
    }
}

