/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;

public final class JMSConnectionFactoryFactory
implements ObjectFactory {
    static String ADDR_TYPE_JCA = "JCA";
    static String ADDR_TYPE_JMS = "JMS";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (!(object instanceof Reference)) throw new Exception("Expected javax.naming.Reference not " + object);
        String string = this.onServer() ? ADDR_TYPE_JCA : ADDR_TYPE_JMS;
        RefAddr refAddr = ((Reference)object).get(string);
        if (refAddr == null) throw new Exception("Reference did not contain " + string + " address");
        byte[] byArray = (byte[])refAddr.getContent();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object2 = objectInputStream.readObject();
        if (object2 instanceof ConnectionFactory) {
            return (ConnectionFactory)object2;
        }
        if (!(object2 instanceof Reference)) throw new Exception("Address " + string + " of Reference contained " + object2 + " not javax.jms.ConnectionFactory");
        Object object3 = NamingManager.getObjectInstance((Reference)object2, name, context, hashtable);
        if (object3 instanceof ConnectionFactory) {
            return (ConnectionFactory)object3;
        }
        if (!(object3 instanceof Reference)) throw new Exception("De-reference of JMS provider's Reference returned " + object3 + " not javax.jms.ConnectionFactory");
        throw new Exception("De-reference of JMS provider's Reference failed - check provider is on classpath");
    }

    private boolean onServer() {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("com.ibm.ejs.ras.RasHelper");
            bl = (Boolean)clazz.getMethod("isServer", null).invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }
}

