/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.View;

public class LayoutData
extends RequestData {
    private String query = "";
    private View[] views;

    public LayoutData(ServletContext context, HttpServletRequest request) {
        super(context, request);
        String qs = request.getQueryString();
        if (qs != null && qs.length() > 0) {
            this.query = "?" + qs;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getBannerURL() {
        String banner = this.preferences.getBanner();
        if (banner == null || banner.trim().length() == 0) {
            banner = "about:blank";
        } else if (!banner.startsWith("http:/")) {
            banner = banner.startsWith("file:/") ? "topic/" + banner : "topic" + banner;
        }
        return banner;
    }

    public String getBannerHeight() {
        String height = this.preferences.getBannerHeight();
        if (height == null || height.length() == 0) {
            height = "0";
        }
        return height;
    }

    public String getContentURL() {
        TocData tocData = new TocData(this.context, this.request);
        String topic = tocData.getSelectedTopic();
        String help_home = this.preferences.getHelpHome();
        help_home = topic != null ? topic : UrlUtil.getHelpURL(help_home);
        return help_home;
    }

    public View[] getViews() {
        if (this.views != null) {
            return this.views;
        }
        View tocview = new View("toc", "", String.valueOf(this.preferences.getImagesDirectory()) + "/contents_view.gif");
        View searchview = new View("search", "", String.valueOf(this.preferences.getImagesDirectory()) + "/search_results_view.gif");
        View linksview = null;
        View bookmarksview = null;
        if (this.preferences.isLinksView()) {
            linksview = new View("links", "", String.valueOf(this.preferences.getImagesDirectory()) + "/links_view.gif");
        }
        if (this.preferences.isBookmarksView()) {
            bookmarksview = new View("bookmarks", "", String.valueOf(this.preferences.getImagesDirectory()) + "/bookmarks_view.gif");
        }
        this.views = linksview != null && bookmarksview != null ? new View[]{tocview, searchview, linksview, bookmarksview} : (linksview != null ? new View[]{tocview, searchview, linksview} : (bookmarksview != null ? new View[]{tocview, searchview, bookmarksview} : new View[]{tocview, searchview}));
        return this.views;
    }

    public String getVisibleView() {
        String view = this.request.getParameter("tab");
        if (view != null && view.length() > 0) {
            return view;
        }
        return "toc";
    }

    public View getCurrentView() {
        String name = this.request.getParameter("view");
        this.views = this.getViews();
        int i = 0;
        while (i < this.views.length) {
            if (this.views[i].getName().equals(name)) {
                return this.views[i];
            }
            ++i;
        }
        return null;
    }
}

